/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.cache;

import android.content.Context;
import android.support.v4.util.LruCache;
import android.text.TextUtils;
import in.srain.cube.cache.CacheInfo;
import in.srain.cube.cache.CacheResultType;
import in.srain.cube.cache.ICacheAble;
import in.srain.cube.concurrent.SimpleExecutor;
import in.srain.cube.concurrent.SimpleTask;
import in.srain.cube.file.FileUtil;
import in.srain.cube.file.LruFileCache;
import in.srain.cube.request.JsonData;
import in.srain.cube.util.CLog;
import in.srain.cube.util.Debug;

public class CacheManager {
    private static final boolean DEBUG = Debug.DEBUG_CACHE;
    private static final String LOG_TAG = "cube_cache";
    private LruCache<String, CacheInfo> mMemoryCache;
    private LruFileCache mFileCache;
    private static final byte AFTER_READ_FROM_FILE = 1;
    private static final byte AFTER_READ_FROM_ASSERT = 2;
    private static final byte AFTER_CONVERT = 4;
    private static final byte DO_READ_FROM_FILE = 1;
    private static final byte DO_READ_FROM_ASSERT = 2;
    private static final byte DO_CONVERT = 4;
    private static final byte CONVERT_FOR_MEMORY = 3;
    private static final byte CONVERT_FOR_FILE = 1;
    private static final byte CONVERT_FOR_ASSERT = 2;
    private static final byte CONVERT_FOR_CREATE = 4;
    private Context mContext;

    public CacheManager(Context content, String cacheDir, int memoryCacheSizeInKB, int fileCacheSizeInKB) {
        this.mContext = content;
        this.mMemoryCache = new LruCache<String, CacheInfo>(memoryCacheSizeInKB * 1024){

            protected int sizeOf(String key, CacheInfo value) {
                return value.getSize() + key.getBytes().length;
            }
        };
        this.mFileCache = new LruFileCache(content, cacheDir, fileCacheSizeInKB * 1024);
        this.mFileCache.initDiskCacheAsync();
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"init file cache. dir: %s => %s, size: %s, used: %s", (Object[])new Object[]{cacheDir, this.mFileCache.getCachePath(), this.mFileCache.getMaxSize(), this.mFileCache.getUsedSpace()});
        }
    }

    public <T> void requestCache(ICacheAble<T> cacheAble) {
        InnerCacheTask<T> task = new InnerCacheTask<T>(cacheAble);
        task.beginQuery();
    }

    public <T> void continueAfterCreateData(ICacheAble<T> cacheAble, String data) {
        this.setCacheData(cacheAble.getCacheKey(), data);
        InnerCacheTask<T> task = new InnerCacheTask<T>(cacheAble);
        ((InnerCacheTask)task).beginConvertDataAsync((byte)4);
    }

    public void setCacheData(final String cacheKey, final String data) {
        if (TextUtils.isEmpty((CharSequence)cacheKey) || TextUtils.isEmpty((CharSequence)data)) {
            return;
        }
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"%s, setCacheData", (Object[])new Object[]{cacheKey});
        }
        SimpleExecutor.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                CacheInfo cacheInfo = CacheInfo.createForNow(data);
                CacheManager.this.putDataToMemoryCache(cacheKey, cacheInfo);
                CacheManager.this.mFileCache.write(cacheKey, cacheInfo.getCacheData());
                CacheManager.this.mFileCache.flushDiskCacheAsyncWithDelay(1000);
            }
        });
    }

    private void putDataToMemoryCache(String key, CacheInfo data) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"%s, set cache to runtime cache list", (Object[])new Object[]{key});
        }
        this.mMemoryCache.put((Object)key, (Object)data);
    }

    public void invalidateCache(String key) {
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"%s, invalidateCache", (Object[])new Object[]{key});
        }
        this.mFileCache.delete(key);
        this.mMemoryCache.remove((Object)key);
    }

    public void clearMemoryCache() {
        if (this.mMemoryCache != null) {
            this.mMemoryCache.evictAll();
        }
    }

    public int getMemoryCacheUsedSpace() {
        return this.mMemoryCache.size();
    }

    public int getMemoryCacheMaxSpace() {
        return this.mMemoryCache.maxSize();
    }

    public void clearDiskCache() {
        if (null != this.mFileCache) {
            this.mFileCache.clearCache();
        }
    }

    public String getFileCachePath() {
        if (null != this.mFileCache) {
            return this.mFileCache.getCachePath();
        }
        return null;
    }

    public long getFileCacheUsedSpace() {
        return null != this.mFileCache ? this.mFileCache.getUsedSpace() : 0L;
    }

    public long getFileCacheMaxSpace() {
        if (null != this.mFileCache) {
            return this.mFileCache.getMaxSize();
        }
        return 0L;
    }

    private class InnerCacheTask<T1>
    extends SimpleTask {
        private ICacheAble<T1> mCacheAble;
        private CacheInfo mRawData;
        private T1 mResult;
        private byte mWorkType = 0;
        private byte mConvertFor = 0;
        private byte mCurrentStatus = 0;

        public InnerCacheTask(ICacheAble<T1> cacheAble) {
            this.mCacheAble = cacheAble;
        }

        void beginQuery() {
            if (this.mCacheAble.cacheIsDisabled()) {
                if (DEBUG) {
                    CLog.d((String)CacheManager.LOG_TAG, (String)"%s, Cache is disabled, query from server", (Object[])new Object[]{this.mCacheAble.getCacheKey()});
                }
                this.mCacheAble.createDataForCache(CacheManager.this);
                return;
            }
            String cacheKey = this.mCacheAble.getCacheKey();
            this.mRawData = (CacheInfo)CacheManager.this.mMemoryCache.get((Object)cacheKey);
            if (this.mRawData != null) {
                if (DEBUG) {
                    CLog.d((String)CacheManager.LOG_TAG, (String)"%s, exist in list", (Object[])new Object[]{this.mCacheAble.getCacheKey()});
                }
                this.beginConvertDataAsync((byte)3);
                return;
            }
            boolean hasFileCache = CacheManager.this.mFileCache.has(this.mCacheAble.getCacheKey());
            if (hasFileCache) {
                this.beginQueryFromCacheFileAsync();
                return;
            }
            String assertInitDataPath = this.mCacheAble.getAssertInitDataPath();
            if (assertInitDataPath != null && assertInitDataPath.length() > 0) {
                this.beginQueryFromAssertCacheFileAsync();
                return;
            }
            if (DEBUG) {
                CLog.d((String)CacheManager.LOG_TAG, (String)"%s, cache file not exist", (Object[])new Object[]{this.mCacheAble.getCacheKey()});
            }
            this.mCacheAble.createDataForCache(CacheManager.this);
        }

        @Override
        public void doInBackground() {
            if (DEBUG) {
                CLog.d((String)CacheManager.LOG_TAG, (String)"%s, doInBackground: mWorkType: %s", (Object[])new Object[]{this.mCacheAble.getCacheKey(), this.mWorkType});
            }
            switch (this.mWorkType) {
                case 1: {
                    this.doQueryFromCacheFileInBackground();
                    this.setCurrentStatus((byte)1);
                    break;
                }
                case 2: {
                    this.doQueryFromAssertCacheFileInBackground();
                    this.setCurrentStatus((byte)2);
                    break;
                }
                case 4: {
                    this.doConvertDataInBackground();
                    this.setCurrentStatus((byte)4);
                    break;
                }
            }
        }

        @Override
        public void onFinish() {
            switch (this.mCurrentStatus) {
                case 1: {
                    this.beginConvertDataAsync((byte)1);
                    break;
                }
                case 2: {
                    this.beginConvertDataAsync((byte)2);
                    break;
                }
                case 4: {
                    this.done();
                    break;
                }
            }
        }

        private void beginQueryFromCacheFileAsync() {
            if (DEBUG) {
                CLog.d((String)CacheManager.LOG_TAG, (String)"%s, beginQueryFromCacheFileAsync", (Object[])new Object[]{this.mCacheAble.getCacheKey()});
            }
            this.mWorkType = 1;
            this.restart();
            SimpleExecutor.getInstance().execute(this);
        }

        private void beginQueryFromAssertCacheFileAsync() {
            if (DEBUG) {
                CLog.d((String)CacheManager.LOG_TAG, (String)"%s, beginQueryFromAssertCacheFileAsync", (Object[])new Object[]{this.mCacheAble.getCacheKey()});
            }
            this.mWorkType = (byte)2;
            this.restart();
            SimpleExecutor.getInstance().execute(this);
        }

        private void beginConvertDataAsync(byte convertFor) {
            if (DEBUG) {
                CLog.d((String)CacheManager.LOG_TAG, (String)"%s, beginConvertDataAsync", (Object[])new Object[]{this.mCacheAble.getCacheKey()});
            }
            this.mConvertFor = convertFor;
            this.mWorkType = (byte)4;
            this.restart();
            SimpleExecutor.getInstance().execute(this);
        }

        private void doQueryFromCacheFileInBackground() {
            if (DEBUG) {
                CLog.d((String)CacheManager.LOG_TAG, (String)"%s, try read cache data from file", (Object[])new Object[]{this.mCacheAble.getCacheKey()});
            }
            String cacheContent = CacheManager.this.mFileCache.read(this.mCacheAble.getCacheKey());
            JsonData jsonData = JsonData.create(cacheContent);
            this.mRawData = CacheInfo.createFromJson(jsonData);
        }

        private void doQueryFromAssertCacheFileInBackground() {
            if (DEBUG) {
                CLog.d((String)CacheManager.LOG_TAG, (String)"%s, try read cache data from assert file", (Object[])new Object[]{this.mCacheAble.getCacheKey()});
            }
            String cacheContent = FileUtil.readAssert(CacheManager.this.mContext, this.mCacheAble.getAssertInitDataPath());
            this.mRawData = CacheInfo.createInvalidated(cacheContent);
            CacheManager.this.putDataToMemoryCache(this.mCacheAble.getCacheKey(), this.mRawData);
        }

        private void doConvertDataInBackground() {
            if (DEBUG) {
                CLog.d((String)CacheManager.LOG_TAG, (String)"%s, doConvertDataInBackground", (Object[])new Object[]{this.mCacheAble.getCacheKey()});
            }
            JsonData data = JsonData.create(this.mRawData.getData());
            this.mResult = this.mCacheAble.processRawDataFromCache(data);
        }

        private void setCurrentStatus(byte status) {
            this.mCurrentStatus = status;
            if (DEBUG) {
                CLog.d((String)CacheManager.LOG_TAG, (String)"%s, setCurrentStatus: %s", (Object[])new Object[]{this.mCacheAble.getCacheKey(), status});
            }
        }

        private void done() {
            long lastTime = this.mRawData.getTime();
            long timeInterval = System.currentTimeMillis() / 1000L - lastTime;
            boolean outOfDate = timeInterval > this.mCacheAble.getCacheTime() || timeInterval < 0L;
            switch (this.mConvertFor) {
                case 2: {
                    this.mCacheAble.onCacheData(CacheResultType.FROM_INIT_FILE, this.mResult, outOfDate);
                    break;
                }
                case 4: {
                    this.mCacheAble.onCacheData(CacheResultType.FROM_CREATED, this.mResult, outOfDate);
                    break;
                }
                case 1: {
                    this.mCacheAble.onCacheData(CacheResultType.FROM_INIT_FILE, this.mResult, outOfDate);
                    break;
                }
                case 3: {
                    this.mCacheAble.onCacheData(CacheResultType.FROM_CACHE_FILE, this.mResult, outOfDate);
                }
            }
            if (outOfDate) {
                this.mCacheAble.createDataForCache(CacheManager.this);
            }
        }
    }
}

