/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.cache;

import android.text.TextUtils;
import in.srain.cube.cache.CacheManager;
import in.srain.cube.cache.CacheResultType;
import in.srain.cube.cache.ICacheAble;
import in.srain.cube.cache.QueryHandler;
import in.srain.cube.request.JsonData;

public class Query<T>
implements ICacheAble<T> {
    private QueryHandler mHandler;
    private CacheManager mCacheManager;

    public Query(CacheManager cacheManager) {
        this.mCacheManager = cacheManager;
    }

    public void continueAfterCreateData(String data) {
        if (!TextUtils.isEmpty((CharSequence)data)) {
            this.mCacheManager.continueAfterCreateData(this, data);
        } else {
            this.queryFail();
        }
    }

    private void queryFail() {
        this.mHandler.onQueryFinish(RequestType.FAIL, null, true);
    }

    public <T> void setHandler(QueryHandler<T> handler) {
        this.mHandler = handler;
    }

    public void query() {
        this.mCacheManager.requestCache(this);
    }

    @Override
    public long getCacheTime() {
        if (this.mHandler != null) {
            return this.mHandler.getCacheTime();
        }
        return 0L;
    }

    @Override
    public String getCacheKey() {
        if (this.mHandler != null) {
            return this.mHandler.getCacheKey();
        }
        return null;
    }

    @Override
    public String getAssertInitDataPath() {
        if (this.mHandler != null) {
            return this.mHandler.getAssertInitDataPath();
        }
        return null;
    }

    @Override
    public T processRawDataFromCache(JsonData rawData) {
        if (this.mHandler != null) {
            return this.mHandler.processRawDataFromCache(rawData);
        }
        return null;
    }

    @Override
    public void onCacheData(CacheResultType cacheResultType, T cacheData, boolean outOfDate) {
        switch (cacheResultType) {
            case FROM_CACHE_FILE: {
                break;
            }
            case FROM_INIT_FILE: {
                break;
            }
            case FROM_MEMORY: {
                break;
            }
        }
        if (outOfDate) {
            if (this.mHandler != null && this.mHandler.useCacheAnyway()) {
                this.mHandler.onQueryFinish(RequestType.USE_CACHE_ANYWAY, cacheData, outOfDate);
            }
        } else {
            switch (cacheResultType) {
                case FROM_CACHE_FILE: {
                    break;
                }
                case FROM_INIT_FILE: {
                    break;
                }
                case FROM_MEMORY: {
                    break;
                }
            }
            this.mHandler.onQueryFinish(RequestType.USE_CACHE_NOT_EXPIRED, cacheData, true);
        }
    }

    @Override
    public void createDataForCache(CacheManager cacheManager) {
        if (this.mHandler != null) {
            this.continueAfterCreateData(this.mHandler.createDataForCache(this));
        } else {
            this.queryFail();
        }
    }

    @Override
    public boolean cacheIsDisabled() {
        return this.mHandler != null && this.mHandler.disableCache();
    }

    public static enum RequestType {
        USE_CACHE_NOT_EXPIRED,
        USE_DATA_CREATED,
        USE_CACHE_ANYWAY,
        FAIL;

    }
}

