/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.concurrent;

import android.annotation.TargetApi;
import in.srain.cube.util.Version;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleExecutor {
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT;
    private static final int KEEP_ALIVE_TIME = 1;
    private static SimpleExecutor sInstance;
    private final ThreadPoolExecutor mThreadPool;
    private final BlockingQueue<Runnable> mTaskWorkQueue = new LinkedBlockingQueue<Runnable>();

    public static SimpleExecutor getInstance() {
        return sInstance;
    }

    @TargetApi(value=9)
    private SimpleExecutor() {
        this.mThreadPool = new ThreadPoolExecutor(1, 1, 1L, KEEP_ALIVE_TIME_UNIT, this.mTaskWorkQueue, new DefaultThreadFactory());
        if (Version.hasGingerbread()) {
            this.mThreadPool.allowCoreThreadTimeOut(true);
        }
    }

    public void execute(Runnable runnable) {
        this.mThreadPool.execute(runnable);
    }

    static {
        sInstance = null;
        KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
        sInstance = new SimpleExecutor();
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private static final String sPre = "simple-excutor-pool-";
        private static final String sPost = "-thread-";
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = sPre + poolNumber.getAndIncrement() + sPost;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

