/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.file;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;
import android.os.StatFs;
import in.srain.cube.util.Version;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileUtil {
    public static CacheDirInfo getDiskCacheDir(Context context, String uniqueName, long requireSpace) {
        File sdPath = null;
        File internalPath = null;
        Long sdCardFree = 0L;
        boolean usingInternal = false;
        if (FileUtil.hasSDCardMounted()) {
            sdPath = FileUtil.getExternalCacheDir(context);
            sdCardFree = FileUtil.getUsableSpace(sdPath);
        }
        CacheDirInfo cacheDirInfo = new CacheDirInfo();
        cacheDirInfo.requireSize = requireSpace;
        if (sdPath == null || sdCardFree < requireSpace) {
            internalPath = context.getCacheDir();
            long internalFree = FileUtil.getUsableSpace(internalPath);
            if (internalFree < requireSpace) {
                if (internalFree > sdCardFree) {
                    usingInternal = true;
                    cacheDirInfo.realSize = internalFree;
                } else {
                    usingInternal = false;
                    cacheDirInfo.realSize = sdCardFree;
                }
                cacheDirInfo.isNotEnough = true;
            } else {
                usingInternal = true;
                cacheDirInfo.realSize = requireSpace;
            }
        } else {
            usingInternal = false;
            cacheDirInfo.realSize = requireSpace;
        }
        cacheDirInfo.isInternal = usingInternal;
        cacheDirInfo.path = usingInternal ? new File(internalPath.getPath() + File.separator + uniqueName) : new File(sdPath.getPath() + File.separator + uniqueName);
        return cacheDirInfo;
    }

    @TargetApi(value=8)
    public static File getExternalCacheDir(Context context) {
        File path;
        if (Version.hasFroyo() && (path = context.getExternalCacheDir()) != null) {
            return path;
        }
        String cacheDir = "/Android/data/" + context.getPackageName() + "/cache/";
        return new File(Environment.getExternalStorageDirectory().getPath() + cacheDir);
    }

    @TargetApi(value=9)
    public static long getUsableSpace(File path) {
        if (path == null) {
            return -1L;
        }
        if (Version.hasGingerbread()) {
            return path.getUsableSpace();
        }
        if (!path.exists()) {
            return 0L;
        }
        StatFs stats = new StatFs(path.getPath());
        return (long)stats.getBlockSize() * (long)stats.getAvailableBlocks();
    }

    @TargetApi(value=9)
    public static long getUsedSpace(File path) {
        if (path == null) {
            return -1L;
        }
        if (Version.hasGingerbread()) {
            return path.getTotalSpace() - path.getUsableSpace();
        }
        if (!path.exists()) {
            return -1L;
        }
        StatFs stats = new StatFs(path.getPath());
        return (long)stats.getBlockSize() * (long)(stats.getBlockCount() - stats.getAvailableBlocks());
    }

    @TargetApi(value=9)
    public static long getTotalSpace(File path) {
        if (path == null) {
            return -1L;
        }
        if (Version.hasGingerbread()) {
            return path.getTotalSpace();
        }
        if (!path.exists()) {
            return 0L;
        }
        StatFs stats = new StatFs(path.getPath());
        return (long)stats.getBlockSize() * (long)stats.getBlockCount();
    }

    public static boolean hasSDCardMounted() {
        String state = Environment.getExternalStorageState();
        return state != null && state.equals("mounted");
    }

    public static String wantFilesPath(Context context, boolean externalStorageFirst) {
        String path = null;
        path = externalStorageFirst && FileUtil.hasSDCardMounted() ? context.getExternalFilesDir("").getAbsolutePath() : context.getFilesDir().getAbsolutePath();
        return path;
    }

    public static File wantFile(String dir, String fileName) {
        File wallpaperDirectory = new File(dir);
        wallpaperDirectory.mkdirs();
        File outputFile = new File(wallpaperDirectory, fileName);
        return outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write(String filePath, String content) {
        File file = new File(filePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write(content);
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                    return true;
                }
            }
            catch (IOException e) {}
        }
        return false;
    }

    public static String readAssert(Context context, String filePath) {
        try {
            if (filePath.startsWith(File.separator)) {
                filePath = filePath.substring(File.separator.length());
            }
            AssetManager assetManager = context.getAssets();
            InputStream inputStream = assetManager.open(filePath);
            DataInputStream stream = new DataInputStream(inputStream);
            int length = stream.available();
            byte[] buffer = new byte[length];
            stream.readFully(buffer);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(buffer);
            stream.close();
            return byteArrayOutputStream.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        FileInputStream fileInput = null;
        FileChannel channel = null;
        try {
            fileInput = new FileInputStream(filePath);
            channel = fileInput.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate((int)channel.size());
            channel.read(buffer);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(buffer.array());
            String string = byteArrayOutputStream.toString();
            return string;
        }
        catch (Exception e) {
        }
        finally {
            if (fileInput != null) {
                try {
                    fileInput.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static class CacheDirInfo {
        public File path;
        public boolean isInternal = false;
        public boolean isNotEnough = false;
        public long realSize;
        public long requireSize;
    }
}

