/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.file;

import android.content.Context;
import android.util.Log;
import in.srain.cube.cache.IFileCache;
import in.srain.cube.concurrent.SimpleExecutor;
import in.srain.cube.concurrent.SimpleTask;
import in.srain.cube.file.DiskLruCache;
import in.srain.cube.file.FileUtil;
import java.io.File;
import java.io.IOException;

public class LruFileCache
implements IFileCache {
    protected static final boolean DEBUG = true;
    protected static final String TAG = "cube-file-cache";
    private static final String DEFAULT_CACHE_DIR = "cube-cache";
    private static final int DEFAULT_CACHE_SIZE = 0xA00000;
    private static LruFileCache sDefault;
    private static final int DISK_CACHE_INDEX = 0;
    private DiskLruCache mDiskLruCache;
    private final Object mDiskCacheLock = new Object();
    private boolean mDiskCacheStarting = true;
    private boolean mDiskCacheReady = false;
    private File mDiskCacheDir;
    private long mDiskCacheSize;
    private boolean mIsDelayFlushing = false;

    public LruFileCache(Context context, String path, long size) {
        this.mDiskCacheSize = size;
        FileUtil.CacheDirInfo cacheDirInfo = FileUtil.getDiskCacheDir(context, path, size);
        this.mDiskCacheDir = cacheDirInfo.path;
        this.mDiskCacheSize = cacheDirInfo.realSize;
        if (cacheDirInfo.isNotEnough) {
            Log.e((String)TAG, (String)String.format("no enough space for initDiskCache %s %s", cacheDirInfo.requireSize, cacheDirInfo.realSize));
        }
    }

    public static LruFileCache getDefault(Context context) {
        if (null == sDefault) {
            sDefault = new LruFileCache(context, DEFAULT_CACHE_DIR, 0xA00000L);
            sDefault.initDiskCacheAsync();
        }
        return sDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDiskCache() {
        Log.d((String)TAG, (String)("initDiskCache " + this));
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if ((this.mDiskLruCache == null || this.mDiskLruCache.isClosed()) && this.mDiskCacheDir != null) {
                if (!this.mDiskCacheDir.exists()) {
                    this.mDiskCacheDir.mkdirs();
                }
                try {
                    this.mDiskLruCache = DiskLruCache.open(this.mDiskCacheDir, 1, 1, this.mDiskCacheSize);
                    Log.d((String)TAG, (String)("Disk cache initialized " + this));
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("initDiskCache - " + e));
                }
            }
            this.mDiskCacheStarting = false;
            this.mDiskCacheReady = true;
            this.mDiskCacheLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String key, String str) {
        if (key == null) {
            return;
        }
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                try {
                    DiskLruCache.Editor editor = this.mDiskLruCache.edit(key);
                    if (editor != null) {
                        editor.set(0, str);
                        editor.commit();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(String fileCacheKey) {
        if (!this.mDiskCacheReady) {
            this.initDiskCache();
        }
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            while (this.mDiskCacheStarting) {
                try {
                    Log.d((String)TAG, (String)("read wait " + this));
                    this.mDiskCacheLock.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.mDiskLruCache != null) {
                DiskLruCache.Snapshot snapshot = null;
                try {
                    snapshot = this.mDiskLruCache.get(fileCacheKey);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (snapshot == null) {
                    return null;
                }
                String str = null;
                try {
                    str = snapshot.getString(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return str;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean has(String key) {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            while (this.mDiskCacheStarting) {
                try {
                    Log.d((String)TAG, (String)("check has wait " + this));
                    this.mDiskCacheLock.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.mDiskLruCache != null) {
                try {
                    DiskLruCache.Snapshot snapshot = this.mDiskLruCache.get(key);
                    if (snapshot == null) {
                        return false;
                    }
                    return snapshot.has(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String key) {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            while (this.mDiskCacheStarting) {
                try {
                    Log.d((String)TAG, (String)("delete wait " + this));
                    this.mDiskCacheLock.wait();
                }
                catch (InterruptedException e) {}
            }
            try {
                this.mDiskLruCache.remove(key);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public DiskLruCache.Editor open(String key) throws IOException {
        if (null != this.mDiskLruCache) {
            return this.mDiskLruCache.edit(key);
        }
        Log.e((String)TAG, (String)"mDiskLruCache is null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            this.mDiskCacheStarting = true;
            this.mDiskCacheReady = false;
            if (this.mDiskLruCache != null && !this.mDiskLruCache.isClosed()) {
                try {
                    this.mDiskLruCache.delete();
                    Log.d((String)TAG, (String)"Disk cache cleared");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Log.e((String)TAG, (String)("clearCache - " + e));
                }
                this.mDiskLruCache = null;
                this.initDiskCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushDiskCache() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            this.mIsDelayFlushing = false;
            if (this.mDiskLruCache != null) {
                try {
                    this.mDiskLruCache.flush();
                    Log.d((String)TAG, (String)"Disk cache flushed");
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("flush - " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDiskCache() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                try {
                    if (!this.mDiskLruCache.isClosed()) {
                        this.mDiskLruCache.close();
                        this.mDiskLruCache = null;
                        Log.d((String)TAG, (String)"Disk cache closed");
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("close - " + e));
                }
            }
        }
    }

    public void initDiskCacheAsync() {
        Log.d((String)TAG, (String)("initDiskCacheAsync " + this));
        new FileCacheTask(FileCacheTaskType.init_cache).execute();
    }

    public void closeDiskCacheAsync() {
        Log.d((String)TAG, (String)"closeDiskCacheAsync");
        new FileCacheTask(FileCacheTaskType.close_cache).execute();
    }

    public void flushDiskCacheAsync() {
        Log.d((String)TAG, (String)"flushDishCacheAsync");
        new FileCacheTask(FileCacheTaskType.flush_cache).execute();
    }

    public void flushDiskCacheAsyncWithDelay(int delay) {
        Log.d((String)TAG, (String)"flushDishCacheAsync");
        if (this.mIsDelayFlushing) {
            return;
        }
        this.mIsDelayFlushing = true;
        new FileCacheTask(FileCacheTaskType.flush_cache).execute(delay);
    }

    @Override
    public String getCachePath() {
        return this.mDiskCacheDir.getPath();
    }

    @Override
    public long getUsedSpace() {
        if (null == this.mDiskLruCache) {
            return 0L;
        }
        return this.mDiskLruCache.size();
    }

    @Override
    public long getMaxSize() {
        return this.mDiskCacheSize;
    }

    private class FileCacheTask
    extends SimpleTask {
        private FileCacheTaskType mTaskType;

        private FileCacheTask(FileCacheTaskType taskType) {
            this.mTaskType = taskType;
        }

        @Override
        public void doInBackground() {
            switch (this.mTaskType) {
                case init_cache: {
                    LruFileCache.this.initDiskCache();
                    break;
                }
                case close_cache: {
                    LruFileCache.this.closeDiskCache();
                    break;
                }
                case flush_cache: {
                    LruFileCache.this.flushDiskCache();
                    break;
                }
            }
        }

        @Override
        public void onFinish() {
        }

        void execute() {
            SimpleExecutor.getInstance().execute(this);
        }

        void execute(int delay) {
            SimpleTask.postDelay(new Runnable(){

                @Override
                public void run() {
                    FileCacheTask.this.execute();
                }
            }, delay);
        }
    }

    protected static enum FileCacheTaskType {
        init_cache,
        close_cache,
        flush_cache;

    }
}

