/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import in.srain.cube.image.ImageLoader;
import in.srain.cube.image.ImageReuseInfo;
import in.srain.cube.image.ImageTask;
import in.srain.cube.image.drawable.RecyclingBitmapDrawable;

public class CubeImageView
extends ImageView {
    private String mUrl = "";
    private int mSpecifiedWidth = 0;
    private int mSpecifiedHeight = 0;
    private ImageLoader mImageLoader;
    private ImageReuseInfo mImageReuseInfo;
    private ImageTask mImageTask;
    private boolean mClearWhenDetached = true;

    public CubeImageView(Context context) {
        super(context);
    }

    public CubeImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setClearDrawableWhenDetached(boolean clearWhenDetached) {
        this.mClearWhenDetached = clearWhenDetached;
    }

    public void clearDrawable() {
        this.setImageDrawable(null);
        if (null != this.mImageTask && null != this.mImageLoader) {
            this.mImageLoader.detachImageViewFromImageTask(this.mImageTask, this);
            this.clearLoadTask();
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mClearWhenDetached) {
            this.clearDrawable();
        }
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mClearWhenDetached) {
            this.tryLoadImage();
        }
    }

    public void setImageDrawable(Drawable drawable) {
        Drawable previousDrawable = this.getDrawable();
        super.setImageDrawable(drawable);
        CubeImageView.notifyDrawable(drawable, true);
        CubeImageView.notifyDrawable(previousDrawable, false);
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.clearLoadTask();
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.clearLoadTask();
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.clearLoadTask();
    }

    private static void notifyDrawable(Drawable drawable, boolean isDisplayed) {
        if (drawable instanceof RecyclingBitmapDrawable) {
            ((RecyclingBitmapDrawable)drawable).setIsDisplayed(isDisplayed);
        } else if (drawable instanceof LayerDrawable) {
            LayerDrawable layerDrawable = (LayerDrawable)drawable;
            int z = layerDrawable.getNumberOfLayers();
            for (int i = 0; i < z; ++i) {
                CubeImageView.notifyDrawable(layerDrawable.getDrawable(i), isDisplayed);
            }
        }
    }

    public void onLoadFinish() {
    }

    private void clearLoadTask() {
        this.mImageTask = null;
    }

    public void loadImage(ImageLoader imageLoader, String url) {
        this.loadImage(imageLoader, url, 0, 0, null);
    }

    public void loadImage(ImageLoader imageLoader, String url, ImageReuseInfo imageReuseInfo) {
        this.loadImage(imageLoader, url, 0, 0, imageReuseInfo);
    }

    public void loadImage(ImageLoader imageLoader, String url, int specifiedSize) {
        this.loadImage(imageLoader, url, specifiedSize, specifiedSize, null);
    }

    public void loadImage(ImageLoader imageLoader, String url, int specifiedSize, ImageReuseInfo imageReuseInfo) {
        this.loadImage(imageLoader, url, specifiedSize, specifiedSize, imageReuseInfo);
    }

    public void loadImage(ImageLoader imageLoader, String url, int specifiedWidth, int specifieHeight) {
        this.loadImage(imageLoader, url, specifiedWidth, specifieHeight, null);
    }

    public void loadImage(ImageLoader imageLoader, String url, int specifiedWidth, int specifieHeight, ImageReuseInfo imageReuseInfo) {
        this.mImageLoader = imageLoader;
        this.mUrl = url;
        this.mSpecifiedWidth = specifiedWidth;
        this.mSpecifiedHeight = specifieHeight;
        this.mImageReuseInfo = imageReuseInfo;
        this.tryLoadImage();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.tryLoadImage();
    }

    private void tryLoadImage() {
        ImageTask imageTask;
        boolean isFullyWrapContent;
        if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        ViewGroup.LayoutParams lyp = this.getLayoutParams();
        boolean bl = isFullyWrapContent = lyp != null && lyp.height == -2 && lyp.width == -2;
        if (width == 0 && height == 0 && !isFullyWrapContent) {
            return;
        }
        if (this.mSpecifiedWidth != 0) {
            width = this.mSpecifiedWidth;
        }
        if (this.mSpecifiedHeight != 0) {
            height = this.mSpecifiedHeight;
        }
        if (null != this.mImageTask) {
            if (this.mImageTask.isLoadingThisUrl(this.mUrl)) {
                return;
            }
            this.mImageLoader.detachImageViewFromImageTask(this.mImageTask, this);
        }
        this.mImageTask = imageTask = this.mImageLoader.createImageTask(this.mUrl, width, height, this.mImageReuseInfo);
        boolean hitCache = this.mImageLoader.queryCache(imageTask, this);
        if (hitCache) {
            return;
        }
        this.mImageLoader.addImageTask(this.mImageTask, this);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }
}

