/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import in.srain.cube.app.CubeFragment;
import in.srain.cube.app.lifecycle.LifeCycleComponent;
import in.srain.cube.app.lifecycle.LifeCycleComponentManager;
import in.srain.cube.concurrent.SimpleTask;
import in.srain.cube.image.CubeImageView;
import in.srain.cube.image.ImageProvider;
import in.srain.cube.image.ImageReuseInfo;
import in.srain.cube.image.ImageTask;
import in.srain.cube.image.iface.ImageLoadHandler;
import in.srain.cube.image.iface.ImageLoadProgressHandler;
import in.srain.cube.image.iface.ImageResizer;
import in.srain.cube.image.iface.ImageTaskExecutor;
import in.srain.cube.util.CLog;
import in.srain.cube.util.Debug;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ImageLoader
implements LifeCycleComponent {
    private static final String MSG_ATTACK_TO_RUNNING_TASK = "%s attach to running: %s";
    private static final String MSG_TASK_DO_IN_BACKGROUND = "%s doInBackground";
    private static final String MSG_TASK_FINISH = "%s onFinish";
    private static final String MSG_TASK_CANCEL = "%s onCancel";
    private static final String MSG_TASK_HIT_CACHE = "%s hit cache %s %s";
    protected static final boolean DEBUG = Debug.DEBUG_IMAGE;
    protected static final String LOG_TAG = Debug.DEBUG_IMAGE_LOG_TAG;
    protected ImageTaskExecutor mImageTaskExecutor;
    protected ImageResizer mImageResizer;
    protected ImageProvider mImageProvider;
    protected ImageLoadHandler mImageLoadHandler;
    protected ImageLoadProgressHandler mLoadProgressHandler;
    protected boolean mPauseWork = false;
    protected boolean mExitTasksEarly = false;
    private final Object mPauseWorkLock = new Object();
    private HashMap<String, LoadImageTask> mLoadWorkList;
    protected Context mContext;
    protected Resources mResources;

    public ImageLoader(Context context, ImageProvider imageProvider, ImageTaskExecutor imageTaskExecutor, ImageResizer imageResizer, ImageLoadHandler imageLoadHandler) {
        this.mContext = context;
        this.mResources = context.getResources();
        this.mImageProvider = imageProvider;
        this.mImageTaskExecutor = imageTaskExecutor;
        this.mImageResizer = imageResizer;
        this.mImageLoadHandler = imageLoadHandler;
        this.mLoadWorkList = new HashMap();
    }

    public void setImageLoadHandler(ImageLoadHandler imageLoadHandler) {
        this.mImageLoadHandler = imageLoadHandler;
    }

    public ImageLoadHandler getImageLoadHandler() {
        return this.mImageLoadHandler;
    }

    public void setImageResizer(ImageResizer resizer) {
        this.mImageResizer = resizer;
    }

    public ImageResizer getImageResizer() {
        return this.mImageResizer;
    }

    public ImageProvider getImageProvider() {
        return this.mImageProvider;
    }

    public void preLoadImages(String[] urls) {
        int len = urls.length;
        for (int i = 0; i < len; ++i) {
            ImageTask imageTask = this.createImageTask(urls[i], 0, 0, null);
            imageTask.setIsPreLoad();
            this.addImageTask(imageTask, null);
        }
    }

    public ImageTask createImageTask(String url, int requestWidth, int requestHeight, ImageReuseInfo imageReuseInfo) {
        ImageTask imageTask = ImageTask.obtain();
        if (imageTask == null) {
            imageTask = new ImageTask();
        }
        imageTask.renew().setOriginUrl(url).setRequestSize(requestWidth, requestHeight).setReuseInfo(imageReuseInfo);
        return imageTask;
    }

    public void detachImageViewFromImageTask(ImageTask imageTask, CubeImageView imageView) {
        imageTask.removeImageView(imageView);
        if (imageTask.isLoading() && !imageTask.isPreLoad() && !imageTask.stillHasRelatedImageView()) {
            LoadImageTask task = this.mLoadWorkList.get(imageTask.getIdentityKey());
            if (task != null) {
                task.cancel(true);
            }
            if (DEBUG) {
                CLog.d((String)LOG_TAG, (String)"%s previous work is cancelled.", (Object[])new Object[]{imageTask});
            }
        }
        if (!imageTask.stillHasRelatedImageView()) {
            imageTask.tryToRecycle();
        }
    }

    public void addImageTask(ImageTask imageTask, CubeImageView imageView) {
        LoadImageTask runningTask = this.mLoadWorkList.get(imageTask.getIdentityKey());
        if (runningTask != null) {
            if (imageView != null) {
                if (DEBUG) {
                    CLog.d((String)LOG_TAG, (String)MSG_ATTACK_TO_RUNNING_TASK, (Object[])new Object[]{imageTask, runningTask.getImageTask()});
                }
                runningTask.getImageTask().addImageView(imageView);
            }
            return;
        }
        imageTask.addImageView(imageView);
        imageTask.onLoading(this.mImageLoadHandler);
        LoadImageTask loadImageTask = new LoadImageTask(imageTask);
        this.mLoadWorkList.put(imageTask.getIdentityKey(), loadImageTask);
        this.mImageTaskExecutor.execute(loadImageTask);
    }

    public boolean queryCache(ImageTask imageTask, CubeImageView imageView) {
        if (null == this.mImageProvider) {
            return false;
        }
        BitmapDrawable drawable = this.mImageProvider.getBitmapFromMemCache(imageTask);
        if (imageTask.getStatistics() != null) {
            imageTask.getStatistics().afterMemoryCache(drawable != null);
        }
        if (drawable == null) {
            return false;
        }
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)MSG_TASK_HIT_CACHE, (Object[])new Object[]{imageTask, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight()});
            if (drawable.getIntrinsicWidth() == 270) {
                CLog.d((String)LOG_TAG, (String)MSG_TASK_HIT_CACHE, (Object[])new Object[]{imageTask, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight()});
            }
        }
        imageTask.addImageView(imageView);
        imageTask.onLoadFinish(drawable, this.mImageLoadHandler);
        return true;
    }

    public void setTaskOrder(ImageTaskOrder order) {
        if (null != this.mImageTaskExecutor) {
            this.mImageTaskExecutor.setTaskOrder(order);
        }
    }

    public void flushFileCache() {
        if (this.mImageProvider != null) {
            this.mImageProvider.flushFileCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPause(boolean pause) {
        Object object = this.mPauseWorkLock;
        synchronized (object) {
            this.mPauseWork = pause;
            if (!pause) {
                this.mPauseWorkLock.notifyAll();
            }
        }
    }

    public void pauseWork() {
        this.mExitTasksEarly = false;
        this.setPause(true);
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"work_status: pauseWork %s", (Object[])new Object[]{this});
        }
    }

    public void resumeWork() {
        this.mExitTasksEarly = false;
        this.setPause(false);
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"work_status: resumeWork %s", (Object[])new Object[]{this});
        }
    }

    public void recoverWork() {
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"work_status: recoverWork %s", (Object[])new Object[]{this});
        }
        this.mExitTasksEarly = false;
        this.setPause(false);
        for (Map.Entry<String, LoadImageTask> item : this.mLoadWorkList.entrySet()) {
            LoadImageTask task = item.getValue();
            task.restart();
            this.mImageTaskExecutor.execute(task);
        }
    }

    public void stopWork() {
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"work_status: stopWork %s", (Object[])new Object[]{this});
        }
        this.mExitTasksEarly = true;
        this.setPause(false);
        this.flushFileCache();
    }

    public void destroy() {
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"work_status: destroy %s", (Object[])new Object[]{this});
        }
        this.mExitTasksEarly = true;
        this.setPause(false);
        Iterator<Map.Entry<String, LoadImageTask>> it = this.mLoadWorkList.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, LoadImageTask> item = it.next();
            LoadImageTask task = item.getValue();
            it.remove();
            if (task == null) continue;
            task.cancel(true);
        }
        this.mLoadWorkList.clear();
    }

    @Override
    public void onBecomesPartiallyInvisible() {
        this.pauseWork();
    }

    @Override
    public void onBecomesVisible() {
        this.resumeWork();
    }

    @Override
    public void onBecomesTotallyInvisible() {
        this.stopWork();
    }

    @Override
    public void onBecomesVisibleFromTotallyInvisible() {
        this.recoverWork();
    }

    @Override
    public void onDestroy() {
        this.destroy();
    }

    public ImageLoader tryToAttachToContainer(Object object) {
        this.tryToAttachToContainer(object, true);
        return this;
    }

    public ImageLoader tryToAttachToContainer(Object object, boolean throwEx) {
        LifeCycleComponentManager.tryAddComponentToContainer(this, object, throwEx);
        return this;
    }

    public ImageLoader attachToCubeFragment(CubeFragment fragment) {
        if (fragment != null) {
            LifeCycleComponentManager.tryAddComponentToContainer(this, fragment);
        }
        return this;
    }

    private class LoadImageTask
    extends SimpleTask {
        private ImageTask mImageTask;
        private BitmapDrawable mDrawable;

        public LoadImageTask(ImageTask imageTask) {
            this.mImageTask = imageTask;
        }

        public ImageTask getImageTask() {
            return this.mImageTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doInBackground() {
            if (DEBUG) {
                CLog.d((String)LOG_TAG, (String)ImageLoader.MSG_TASK_DO_IN_BACKGROUND, (Object[])new Object[]{this.mImageTask});
            }
            if (this.mImageTask.getStatistics() != null) {
                this.mImageTask.getStatistics().beginLoad();
            }
            Bitmap bitmap = null;
            Object object = ImageLoader.this.mPauseWorkLock;
            synchronized (object) {
                while (ImageLoader.this.mPauseWork && !this.isCancelled()) {
                    try {
                        if (DEBUG) {
                            CLog.d((String)LOG_TAG, (String)"%s wait to begin", (Object[])new Object[]{this.mImageTask});
                        }
                        ImageLoader.this.mPauseWorkLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.isCancelled() && !ImageLoader.this.mExitTasksEarly && (this.mImageTask.isPreLoad() || this.mImageTask.stillHasRelatedImageView())) {
                try {
                    bitmap = ImageLoader.this.mImageProvider.fetchBitmapData(ImageLoader.this, this.mImageTask, ImageLoader.this.mImageResizer);
                    if (this.mImageTask.getStatistics() != null) {
                        this.mImageTask.getStatistics().afterDecode();
                    }
                    this.mDrawable = ImageLoader.this.mImageProvider.createBitmapDrawable(ImageLoader.this.mResources, bitmap);
                    ImageLoader.this.mImageProvider.addBitmapToMemCache(this.mImageTask.getIdentityKey(), this.mDrawable);
                    if (this.mImageTask.getStatistics() != null) {
                        this.mImageTask.getStatistics().afterCreateBitmapDrawable();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                catch (OutOfMemoryError e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void onFinish() {
            if (DEBUG) {
                CLog.d((String)LOG_TAG, (String)ImageLoader.MSG_TASK_FINISH, (Object[])new Object[]{this.mImageTask});
            }
            if (ImageLoader.this.mExitTasksEarly) {
                return;
            }
            ImageLoader.this.mLoadWorkList.remove(this.mImageTask.getIdentityKey());
            if (!this.isCancelled() && !ImageLoader.this.mExitTasksEarly) {
                this.mImageTask.onLoadFinish(this.mDrawable, ImageLoader.this.mImageLoadHandler);
            }
            this.mImageTask.tryToRecycle();
        }

        @Override
        public void onCancel() {
            if (DEBUG) {
                CLog.d((String)LOG_TAG, (String)ImageLoader.MSG_TASK_CANCEL, (Object[])new Object[]{this.mImageTask});
            }
            ImageLoader.this.mLoadWorkList.remove(this.mImageTask.getIdentityKey());
            this.mImageTask.onCancel();
            this.mImageTask.tryToRecycle();
        }
    }

    public static enum ImageTaskOrder {
        FIRST_IN_FIRST_OUT,
        LAST_IN_FIRST_OUT;

    }
}

