/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image;

import android.content.Context;
import in.srain.cube.file.FileUtil;
import in.srain.cube.image.ImageLoader;
import in.srain.cube.image.ImageProvider;
import in.srain.cube.image.iface.ImageLoadHandler;
import in.srain.cube.image.iface.ImageResizer;
import in.srain.cube.image.iface.ImageTaskExecutor;
import in.srain.cube.image.impl.DefaultImageLoadHandler;
import in.srain.cube.image.impl.DefaultImageResizer;
import in.srain.cube.image.impl.DefaultImageTaskExecutor;
import in.srain.cube.image.impl.DefaultMemoryCache;
import in.srain.cube.image.impl.LruImageFileProvider;

public class ImageLoaderFactory {
    private static ImageProvider sMutableImageProvider;
    private static ImageProvider sStableImageProvider;
    private static ImageResizer sDefaultImageResizer;
    private static ImageTaskExecutor sDefaultImageTaskExecutor;
    private static ImageLoadHandler sDefaultImageLoadHandler;

    public static void init(Context context) {
        int mutableDiskCacheSizeInKB = 10240;
        int stableDiskCacheSizeInKB = 10240;
        float percent = 0.2f;
        int memoryCacheSizeInKB = Math.round(percent * (float)Runtime.getRuntime().maxMemory() / 1024.0f);
        ImageLoaderFactory.init(context, mutableDiskCacheSizeInKB, stableDiskCacheSizeInKB, memoryCacheSizeInKB);
    }

    public static void init(Context context, int mutableDiskCacheSizeInKB, int stableDiskCacheSizeInKB, int memoryCacheSizeInKB) {
        FileUtil.CacheDirInfo dirInfo1 = FileUtil.getDiskCacheDir(context, "mutable_image", mutableDiskCacheSizeInKB * 1024);
        FileUtil.CacheDirInfo dirInfo2 = FileUtil.getDiskCacheDir(context, "stable_image", stableDiskCacheSizeInKB * 1024);
        LruImageFileProvider mutableImageFileProvider = new LruImageFileProvider(dirInfo1.realSize, dirInfo1.path);
        LruImageFileProvider stableImageFileProvider = new LruImageFileProvider(dirInfo2.realSize, dirInfo2.path);
        DefaultMemoryCache defaultMemoryCache = new DefaultMemoryCache(memoryCacheSizeInKB);
        mutableImageFileProvider.initDiskCacheAsync();
        stableImageFileProvider.initDiskCacheAsync();
        sMutableImageProvider = new ImageProvider(context, defaultMemoryCache, mutableImageFileProvider);
        sStableImageProvider = new ImageProvider(context, defaultMemoryCache, stableImageFileProvider);
    }

    public static ImageLoader createStableImageLoader(Context context) {
        return ImageLoaderFactory.createStableImageLoader(context, sDefaultImageLoadHandler);
    }

    public static ImageLoader createStableImageLoader(Context context, ImageLoadHandler imageLoadHandler) {
        return ImageLoaderFactory.createInner(context, sStableImageProvider, imageLoadHandler);
    }

    public static ImageLoader create(Context context) {
        return ImageLoaderFactory.createMutableImageLoader(context, sDefaultImageLoadHandler);
    }

    public static ImageLoader create(Context context, ImageLoadHandler imageLoadHandler) {
        return ImageLoaderFactory.createMutableImageLoader(context, imageLoadHandler);
    }

    public static ImageLoader createMutableImageLoader(Context context) {
        return ImageLoaderFactory.createMutableImageLoader(context, sDefaultImageLoadHandler);
    }

    public static ImageLoader createMutableImageLoader(Context context, ImageLoadHandler imageLoadHandler) {
        return ImageLoaderFactory.createInner(context, sMutableImageProvider, imageLoadHandler);
    }

    private static ImageLoader createInner(Context context, ImageProvider imageProvider, ImageLoadHandler imageLoadHandler) {
        return ImageLoaderFactory.create(context, imageProvider, sDefaultImageTaskExecutor, sDefaultImageResizer, imageLoadHandler);
    }

    private static ImageLoader create(Context context, ImageProvider imageProvider, ImageTaskExecutor imageTaskExecutor, ImageResizer imageResizer, ImageLoadHandler imageLoadHandler) {
        if (imageProvider == null) {
            imageProvider = ImageProvider.getDefault(context);
        }
        if (imageTaskExecutor == null) {
            imageTaskExecutor = DefaultImageTaskExecutor.getInstance();
        }
        if (imageResizer == null) {
            imageResizer = DefaultImageResizer.getInstance();
        }
        if (imageLoadHandler == null) {
            imageLoadHandler = new DefaultImageLoadHandler(context);
        }
        ImageLoader imageLoader = new ImageLoader(context, imageProvider, imageTaskExecutor, imageResizer, imageLoadHandler);
        return imageLoader;
    }

    public static void setDefaultImageResizer(ImageResizer imageResizer) {
        sDefaultImageResizer = imageResizer;
    }

    public static void setDefaultImageTaskExecutor(ImageTaskExecutor imageTaskExecutor) {
        sDefaultImageTaskExecutor = imageTaskExecutor;
    }

    public static void setDefaultImageLoadHandler(ImageLoadHandler imageLoadHandler) {
        sDefaultImageLoadHandler = imageLoadHandler;
    }

    public static void setDefaultImageProvider(ImageProvider imageProvider) {
        sMutableImageProvider = imageProvider;
    }

    public static void setMutableImageProvider(ImageProvider imageProvider) {
        sMutableImageProvider = imageProvider;
    }

    public static void setStableImageProvider(ImageProvider imageProvider) {
        sMutableImageProvider = imageProvider;
    }
}

