/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image;

public class ImageTaskStatistics {
    private long mStart = System.currentTimeMillis();
    private long mAfterMemoryCache;
    private long mBeginLoad;
    private long mAfterFileCache;
    private long mAfterDownload;
    private long mAfterDecode;
    private long mAfterCreateBitmapDrawable;
    private long mShowBegin;
    private long mShowComplete;
    private int mSize;
    private boolean mHitMemoryCache;
    private boolean mHitFileCache;

    public void afterMemoryCache(boolean hasCache) {
        this.mHitMemoryCache = hasCache;
        this.mAfterMemoryCache = System.currentTimeMillis();
        if (hasCache) {
            this.mAfterDecode = this.mAfterCreateBitmapDrawable = this.mAfterMemoryCache;
            this.mAfterDownload = this.mAfterCreateBitmapDrawable;
            this.mAfterFileCache = this.mAfterCreateBitmapDrawable;
            this.mBeginLoad = this.mAfterCreateBitmapDrawable;
        }
    }

    public void beginLoad() {
        this.mBeginLoad = System.currentTimeMillis();
    }

    public void afterFileCache(boolean hasCache) {
        this.mHitFileCache = hasCache;
        this.mAfterFileCache = System.currentTimeMillis();
        if (hasCache) {
            this.mAfterDownload = this.mAfterFileCache;
        }
    }

    public void afterDownload() {
        this.mAfterDownload = System.currentTimeMillis();
    }

    public void afterDecode() {
        this.mAfterDecode = System.currentTimeMillis();
    }

    public void showBegin() {
        this.mShowBegin = System.currentTimeMillis();
    }

    public void afterCreateBitmapDrawable() {
        this.mAfterCreateBitmapDrawable = System.currentTimeMillis();
    }

    public void showComplete(int s) {
        this.mShowComplete = System.currentTimeMillis();
        this.mSize = s;
    }

    public int getMemoryCacheTime() {
        return (int)(this.mAfterMemoryCache - this.mStart);
    }

    public int getWaitForLoadTime() {
        return (int)(this.mBeginLoad - this.mAfterMemoryCache);
    }

    public int getFileCacheTime() {
        return (int)(this.mAfterFileCache - this.mBeginLoad);
    }

    public int getDownloadTime() {
        return (int)(this.mAfterDownload - this.mAfterFileCache);
    }

    public int getDecodeTime() {
        return (int)(this.mAfterDecode - this.mAfterDownload);
    }

    public int getCreateBitmapDrawableTime() {
        return (int)(this.mAfterCreateBitmapDrawable - this.mAfterDecode);
    }

    public int getWaitForPostMessage() {
        return (int)(this.mShowBegin - this.mAfterCreateBitmapDrawable);
    }

    public int getDisplayTime() {
        return (int)(this.mShowComplete - this.mShowBegin);
    }

    public int getTotalLoadTime() {
        return (int)(this.mShowComplete - this.mBeginLoad);
    }

    public boolean hitMemoryCache() {
        return this.mHitMemoryCache;
    }

    public boolean hitFileCache() {
        return this.mHitFileCache;
    }

    public int getSize() {
        return this.mSize;
    }

    public String getInfo() {
        return String.format("mc=%d, w=%d, fc=%d, dl=%d, de=%d, crt=%d, w2=%s, dis=%d, all=%d, size=%d", this.getMemoryCacheTime(), this.getWaitForLoadTime(), this.getFileCacheTime(), this.getDownloadTime(), this.getDecodeTime(), this.getCreateBitmapDrawableTime(), this.getWaitForPostMessage(), this.getDisplayTime(), this.getTotalLoadTime(), this.getSize());
    }
}

