/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image.drawable;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;

public class RoundedDrawable
extends Drawable {
    protected final float mCornerRadius;
    protected final int mMargin;
    protected final RectF mRect = new RectF();
    protected final BitmapShader mBitmapShader;
    protected final Paint mPaint;

    public RoundedDrawable(Bitmap bitmap, float cornerRadius, int margin) {
        this.mCornerRadius = cornerRadius;
        this.mMargin = margin;
        this.mBitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setShader((Shader)this.mBitmapShader);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mRect.set((float)this.mMargin, (float)this.mMargin, (float)(bounds.width() - this.mMargin), (float)(bounds.height() - this.mMargin));
    }

    public void draw(Canvas canvas) {
        canvas.drawRoundRect(this.mRect, this.mCornerRadius, this.mCornerRadius, this.mPaint);
    }

    public int getOpacity() {
        return -3;
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }
}

