/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image.impl;

import android.graphics.drawable.BitmapDrawable;
import android.support.v4.util.LruCache;
import android.util.Log;
import in.srain.cube.image.ImageProvider;
import in.srain.cube.image.drawable.RecyclingBitmapDrawable;
import in.srain.cube.image.iface.ImageMemoryCache;
import in.srain.cube.util.Debug;

public class DefaultMemoryCache
implements ImageMemoryCache {
    protected static final boolean DEBUG = Debug.DEBUG_IMAGE;
    protected static final String LOG_TAG = Debug.DEBUG_IMAGE_LOG_TAG_PROVIDER;
    private LruCache<String, BitmapDrawable> mMemoryCache;
    private static DefaultMemoryCache sDefault;

    public static DefaultMemoryCache getDefault() {
        if (null == sDefault) {
            int size = Math.round(0.2f * (float)Runtime.getRuntime().maxMemory() / 1024.0f);
            sDefault = new DefaultMemoryCache(size);
        }
        return sDefault;
    }

    public DefaultMemoryCache(int cacheSizeInKB) {
        if (DEBUG) {
            Log.d((String)LOG_TAG, (String)("Memory cache created (size = " + cacheSizeInKB + " KB)"));
        }
        this.mMemoryCache = new LruCache<String, BitmapDrawable>(cacheSizeInKB){

            protected void entryRemoved(boolean evicted, String key, BitmapDrawable oldValue, BitmapDrawable newValue) {
                if (RecyclingBitmapDrawable.class.isInstance(oldValue)) {
                    ((RecyclingBitmapDrawable)oldValue).setIsCached(false);
                }
            }

            protected int sizeOf(String key, BitmapDrawable value) {
                int bitmapSize = ImageProvider.getBitmapSize(value) / 1024;
                return bitmapSize == 0 ? 1 : bitmapSize;
            }
        };
    }

    @Override
    public void set(String key, BitmapDrawable drawable) {
        if (key == null || drawable == null) {
            return;
        }
        if (this.mMemoryCache != null) {
            if (RecyclingBitmapDrawable.class.isInstance(drawable)) {
                ((RecyclingBitmapDrawable)drawable).setIsCached(true);
            }
            this.mMemoryCache.put((Object)key, (Object)drawable);
        }
    }

    @Override
    public BitmapDrawable get(String key) {
        BitmapDrawable memValue = null;
        if (this.mMemoryCache != null) {
            memValue = (BitmapDrawable)this.mMemoryCache.get((Object)key);
        }
        return memValue;
    }

    @Override
    public void clear() {
        if (this.mMemoryCache != null) {
            this.mMemoryCache.evictAll();
            if (DEBUG) {
                Log.d((String)LOG_TAG, (String)"Memory cache cleared");
            }
        }
    }

    @Override
    public void delete(String key) {
        this.mMemoryCache.remove((Object)key);
    }

    @Override
    public long getMaxSize() {
        return this.mMemoryCache.maxSize() * 1024;
    }

    @Override
    public long getUsedSpace() {
        return this.mMemoryCache.size() * 1024;
    }
}

