/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image.impl;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import in.srain.cube.concurrent.SimpleExecutor;
import in.srain.cube.concurrent.SimpleTask;
import in.srain.cube.file.DiskLruCache;
import in.srain.cube.file.FileUtil;
import in.srain.cube.image.iface.ImageFileProvider;
import in.srain.cube.image.impl.SimpleDownloader;
import in.srain.cube.util.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LruImageFileProvider
implements ImageFileProvider {
    protected static final boolean DEBUG = Debug.DEBUG_IMAGE;
    protected static final String LOG_TAG = Debug.DEBUG_IMAGE_LOG_TAG_PROVIDER;
    private static final String DEFAULT_CACHE_DIR = "cube-image";
    private static final int DEFAULT_CACHE_SIZE = 0xA00000;
    private static LruImageFileProvider sDefault;
    private static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT;
    private static final int DEFAULT_COMPRESS_QUALITY = 70;
    private static final int DISK_CACHE_INDEX = 0;
    private DiskLruCache mDiskLruCache;
    private final Object mDiskCacheLock = new Object();
    private boolean mDiskCacheStarting = true;
    private boolean mDiskCacheReady = false;
    private File mDiskCacheDir;
    private long mDiskCacheSize;
    private long mLastFlushTime = 0L;

    @Override
    public FileInputStream getInputStream(String fileCacheKey) {
        return this.read(fileCacheKey);
    }

    @Override
    public FileInputStream downloadAndGetInputStream(String fileCacheKey, String url) {
        try {
            DiskLruCache.Editor editor = this.open(fileCacheKey);
            if (editor != null) {
                OutputStream outputStream = editor.newOutputStream(0);
                boolean ret = SimpleDownloader.downloadUrlToStream(url, outputStream);
                if (ret) {
                    editor.commit();
                } else {
                    editor.abort();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.read(fileCacheKey);
    }

    public LruImageFileProvider(long size, File path) {
        this.mDiskCacheSize = size;
        this.mDiskCacheDir = path;
    }

    public static LruImageFileProvider getDefault(Context context) {
        if (null == sDefault) {
            FileUtil.CacheDirInfo cacheDirInfo = FileUtil.getDiskCacheDir(context, DEFAULT_CACHE_DIR, 0xA00000L);
            sDefault = new LruImageFileProvider(cacheDirInfo.realSize, cacheDirInfo.path);
            sDefault.initDiskCacheAsync();
        }
        return sDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDiskCache() {
        if (DEBUG) {
            Log.d((String)LOG_TAG, (String)("initDiskCache " + this));
        }
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if ((this.mDiskLruCache == null || this.mDiskLruCache.isClosed()) && this.mDiskCacheDir != null) {
                if (!this.mDiskCacheDir.exists()) {
                    this.mDiskCacheDir.mkdirs();
                }
                if (FileUtil.getUsableSpace(this.mDiskCacheDir) > this.mDiskCacheSize) {
                    try {
                        this.mDiskLruCache = DiskLruCache.open(this.mDiskCacheDir, 1, 1, this.mDiskCacheSize);
                        if (DEBUG) {
                            Log.d((String)LOG_TAG, (String)("Disk cache initialized " + this));
                        }
                    }
                    catch (IOException e) {
                        Log.e((String)LOG_TAG, (String)("initDiskCache - " + e));
                    }
                } else {
                    Log.e((String)LOG_TAG, (String)String.format("no enough space for initDiskCache %s %s", FileUtil.getUsableSpace(this.mDiskCacheDir), this.mDiskCacheSize));
                }
            }
            this.mDiskCacheStarting = false;
            this.mDiskCacheReady = true;
            this.mDiskCacheLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String key, Bitmap bitmap) {
        if (key == null || bitmap == null) {
            return;
        }
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                OutputStream out = null;
                try {
                    DiskLruCache.Editor editor;
                    DiskLruCache.Snapshot snapshot = this.mDiskLruCache.get(key);
                    if (snapshot == null && (editor = this.mDiskLruCache.edit(key)) != null) {
                        out = editor.newOutputStream(0);
                        bitmap.compress(DEFAULT_COMPRESS_FORMAT, 70, out);
                        editor.commit();
                        out.close();
                    }
                }
                catch (IOException e) {
                    Log.e((String)LOG_TAG, (String)("addBitmapToCache - " + e));
                }
                catch (Exception e) {
                    Log.e((String)LOG_TAG, (String)("addBitmapToCache - " + e));
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInputStream read(String fileCacheKey) {
        if (!this.mDiskCacheReady) {
            this.initDiskCache();
        }
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            while (this.mDiskCacheStarting) {
                try {
                    if (DEBUG) {
                        Log.d((String)LOG_TAG, (String)("read wait " + this));
                    }
                    this.mDiskCacheLock.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.mDiskLruCache != null) {
                InputStream inputStream = null;
                DiskLruCache.Snapshot snapshot = null;
                try {
                    snapshot = this.mDiskLruCache.get(fileCacheKey);
                }
                catch (IOException e) {
                    Log.e((String)LOG_TAG, (String)("getBitmapFromDiskCache - " + e));
                }
                if (snapshot == null) {
                    return null;
                }
                inputStream = snapshot.getInputStream(0);
                return (FileInputStream)inputStream;
            }
            return null;
        }
    }

    public DiskLruCache.Editor open(String key) throws IOException {
        if (null != this.mDiskLruCache) {
            return this.mDiskLruCache.edit(key);
        }
        Log.e((String)LOG_TAG, (String)"mDiskLruCache is null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            this.mDiskCacheStarting = true;
            this.mDiskCacheReady = false;
            if (this.mDiskLruCache != null && !this.mDiskLruCache.isClosed()) {
                try {
                    this.mDiskLruCache.delete();
                    if (DEBUG) {
                        Log.d((String)LOG_TAG, (String)"Disk cache cleared");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Log.e((String)LOG_TAG, (String)("clearCache - " + e));
                }
                this.mDiskLruCache = null;
                this.initDiskCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushDiskCache() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            if (now - 1000L < this.mLastFlushTime) {
                return;
            }
            this.mLastFlushTime = now;
            if (this.mDiskLruCache != null) {
                try {
                    this.mDiskLruCache.flush();
                    if (DEBUG) {
                        Log.d((String)LOG_TAG, (String)"Disk cache flushed");
                    }
                }
                catch (IOException e) {
                    Log.e((String)LOG_TAG, (String)("flush - " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDiskCache() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                try {
                    if (!this.mDiskLruCache.isClosed()) {
                        this.mDiskLruCache.close();
                        this.mDiskLruCache = null;
                        if (DEBUG) {
                            Log.d((String)LOG_TAG, (String)"Disk cache closed");
                        }
                    }
                }
                catch (IOException e) {
                    Log.e((String)LOG_TAG, (String)("close - " + e));
                }
            }
        }
    }

    @Override
    public void initDiskCacheAsync() {
        if (DEBUG) {
            Log.d((String)LOG_TAG, (String)("initDiskCacheAsync " + this));
        }
        new FileCacheTask(FileCacheTaskType.init_cache).excute();
    }

    public void closeDiskCacheAsync() {
        if (DEBUG) {
            Log.d((String)LOG_TAG, (String)"closeDiskCacheAsync");
        }
        new FileCacheTask(FileCacheTaskType.close_cache).excute();
    }

    @Override
    public void flushDiskCacheAsync() {
        if (DEBUG) {
            Log.d((String)LOG_TAG, (String)"flushDishCacheAsync");
        }
        new FileCacheTask(FileCacheTaskType.flush_cache).excute();
    }

    @Override
    public String getCachePath() {
        return this.mDiskCacheDir.getPath();
    }

    @Override
    public long getUsedSpace() {
        if (null == this.mDiskLruCache) {
            return 0L;
        }
        return this.mDiskLruCache.size();
    }

    @Override
    public long getMaxSize() {
        return this.mDiskCacheSize;
    }

    @Override
    public boolean has(String key) {
        if (this.mDiskLruCache != null) {
            return this.read(key) != null;
        }
        return false;
    }

    static {
        DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.JPEG;
    }

    private class FileCacheTask
    extends SimpleTask {
        private FileCacheTaskType mTaskType;

        private FileCacheTask(FileCacheTaskType taskType) {
            this.mTaskType = taskType;
        }

        @Override
        public void doInBackground() {
            switch (this.mTaskType) {
                case init_cache: {
                    LruImageFileProvider.this.initDiskCache();
                    break;
                }
                case close_cache: {
                    LruImageFileProvider.this.closeDiskCache();
                    break;
                }
                case flush_cache: {
                    LruImageFileProvider.this.flushDiskCache();
                    break;
                }
            }
        }

        @Override
        public void onFinish() {
        }

        void excute() {
            SimpleExecutor.getInstance().execute(this);
        }
    }

    protected static enum FileCacheTaskType {
        init_cache,
        close_cache,
        flush_cache;

    }
}

