/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.image.impl;

import android.os.Build;
import android.util.Log;
import in.srain.cube.util.Debug;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class SimpleDownloader {
    protected static final String LOG_TAG = Debug.DEBUG_IMAGE_LOG_TAG_PROVIDER;
    private static final int IO_BUFFER_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadUrlToStream(String urlString, OutputStream outputStream) {
        SimpleDownloader.disableConnectionReuseIfNecessary();
        HttpURLConnection urlConnection = null;
        FilterOutputStream out = null;
        BufferedInputStream in = null;
        try {
            int b;
            URL url = new URL(urlString);
            urlConnection = (HttpURLConnection)url.openConnection();
            in = new BufferedInputStream(urlConnection.getInputStream(), 8192);
            out = new BufferedOutputStream(outputStream, 8192);
            while ((b = in.read()) != -1) {
                ((BufferedOutputStream)out).write(b);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)("Error in downloadBitmap - " + e));
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
        return false;
    }

    public static void disableConnectionReuseIfNecessary() {
        if (Build.VERSION.SDK_INT < 8) {
            System.setProperty("http.keepAlive", "false");
        }
    }
}

