/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.mints.base;

import android.graphics.Color;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import in.srain.cube.R;
import in.srain.cube.mints.base.TitleBaseFragment;
import in.srain.cube.util.LocalDisplay;
import in.srain.cube.views.block.BlockListAdapter;
import in.srain.cube.views.block.BlockListView;
import java.util.ArrayList;

public abstract class BlockMenuFragment
extends TitleBaseFragment {
    private BlockListView mBlockListView;
    private ArrayList<ItemInfo> mItemInfos = new ArrayList();
    private int mSize = 0;
    private BlockListAdapter<ItemInfo> mBlockListAdapter = new BlockListAdapter<ItemInfo>(){

        @Override
        public View getView(LayoutInflater layoutInflater, int position) {
            return BlockMenuFragment.this.getViewForBlock(layoutInflater, position);
        }
    };

    protected int getLayoutId() {
        return R.layout.cube_mints_base_fragment_block_menu;
    }

    protected View getViewForBlock(LayoutInflater layoutInflater, int position) {
        ItemInfo itemInfo = this.mBlockListAdapter.getItem(position);
        ViewGroup view = (ViewGroup)layoutInflater.inflate(R.layout.cube_mints_base_block_menu_item, null);
        if (itemInfo != null) {
            TextView textView = (TextView)view.findViewById(R.id.cube_mints_base_block_menu_item_title);
            textView.setText((CharSequence)itemInfo.mTitle);
            view.setBackgroundColor(itemInfo.getColor());
        }
        return view;
    }

    protected abstract void addItemInfo(ArrayList<ItemInfo> var1);

    protected abstract void setupViews();

    @Override
    protected View createView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(this.getLayoutId(), null);
        this.mBlockListView = (BlockListView)view.findViewById(R.id.fragment_block_menu_block_list);
        this.addItemInfo(this.mItemInfos);
        this.setupList();
        this.setupViews();
        return view;
    }

    protected void setupList() {
        this.mSize = (LocalDisplay.SCREEN_WIDTH_PIXELS - LocalDisplay.dp2px(35.0f)) / 3;
        int horizontalSpacing = LocalDisplay.dp2px(5.0f);
        int verticalSpacing = LocalDisplay.dp2px(10.5f);
        this.mBlockListView.setOnItemClickListener(new BlockListView.OnItemClickListener(){

            @Override
            public void onItemClick(View v, int position) {
                ItemInfo itemInfo = (ItemInfo)BlockMenuFragment.this.mBlockListAdapter.getItem(position);
                if (itemInfo != null) {
                    itemInfo.mOnClickListener.onClick(v);
                }
            }
        });
        this.mBlockListAdapter.setSpace(horizontalSpacing, verticalSpacing);
        this.mBlockListAdapter.setBlockSize(this.mSize, this.mSize);
        this.mBlockListAdapter.setColumnNum(3);
        this.mBlockListView.setAdapter(this.mBlockListAdapter);
        this.mBlockListAdapter.displayBlocks(this.mItemInfos);
    }

    protected ItemInfo newItemInfo(String title, int color, View.OnClickListener onClickListener) {
        return new ItemInfo(title, this.getResources().getColor(color), onClickListener);
    }

    protected ItemInfo newItemInfo(String title, String color, View.OnClickListener onClickListener) {
        return new ItemInfo(title, Color.parseColor((String)color), onClickListener);
    }

    protected ItemInfo newItemInfo(int title, String color, View.OnClickListener onClickListener) {
        return new ItemInfo(this.getString(title), Color.parseColor((String)color), onClickListener);
    }

    protected ItemInfo newItemInfo(int title, int color, View.OnClickListener onClickListener) {
        return new ItemInfo(this.getString(title), this.getResources().getColor(color), onClickListener);
    }

    @Override
    protected boolean enableDefaultBack() {
        return false;
    }

    protected static class ItemInfo {
        private int mColor;
        private String mTitle;
        private View.OnClickListener mOnClickListener;

        public ItemInfo(String title, int color, View.OnClickListener onClickListener) {
            this.mTitle = title;
            this.mColor = color;
            this.mOnClickListener = onClickListener;
        }

        private int getColor() {
            return this.mColor;
        }
    }
}

