/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.request;

import in.srain.cube.request.IRequest;
import in.srain.cube.request.JsonData;
import in.srain.cube.request.RequestData;

public abstract class RequestBase<T>
implements IRequest<T> {
    private RequestData mRequestData = new RequestData();
    private boolean mHasBeenCanceled = false;

    @Override
    public RequestData getRequestData() {
        return this.mRequestData;
    }

    @Override
    public void send() {
        this.prepareRequest();
        this.doSendRequest();
    }

    @Override
    public void cancelRequest() {
        this.mHasBeenCanceled = true;
        this.onCancel();
    }

    @Override
    public T onDataFromServer(String data) {
        JsonData jsonData = JsonData.create(data);
        return this.processOriginDataFromServer(jsonData);
    }

    protected boolean hasBeenCanceled() {
        return this.mHasBeenCanceled;
    }

    protected void onCancel() {
    }

    protected abstract void doSendRequest();

    protected abstract void prepareRequest();
}

