/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.request;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class RequestData {
    private static final String CHAR_QM = "?";
    private static final String CHAR_AND = "&";
    private static final String CHAR_EQ = "=";
    private static final String CHAR_SET = "UTF-8";
    public String mUrl;
    private HashMap<String, Object> mQueryData;
    private HashMap<String, Object> mPostData;
    private boolean mUsePost = false;

    public static String buildQueryString(Map<String, ?> data, String url) {
        StringBuilder sb = new StringBuilder();
        boolean append = false;
        if (url != null) {
            sb.append(url);
            if (url.contains(CHAR_QM)) {
                append = true;
            } else {
                sb.append(CHAR_QM);
            }
        }
        for (Map.Entry<String, ?> item : data.entrySet()) {
            if (append) {
                sb.append(CHAR_AND);
            } else {
                append = true;
            }
            try {
                sb.append(URLEncoder.encode(item.getKey(), CHAR_SET));
                sb.append(CHAR_EQ);
                sb.append(URLEncoder.encode(item.getValue().toString(), CHAR_SET));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public void addPostData(String key, Object data) {
        if (this.mPostData == null) {
            this.mPostData = new HashMap();
        }
        this.mPostData.put(key, data);
    }

    public void addPostData(Map<String, ?> data) {
        if (this.mPostData == null) {
            this.mPostData = new HashMap();
        }
        this.mPostData.putAll(data);
    }

    public void addQueryData(String key, Object data) {
        if (this.mQueryData == null) {
            this.mQueryData = new HashMap();
        }
        this.mQueryData.put(key, data);
    }

    public void addQueryData(Map<String, ?> data) {
        if (this.mQueryData == null) {
            this.mQueryData = new HashMap();
        }
        this.mQueryData.putAll(data);
    }

    public String getRequestUrl() {
        if (this.mQueryData != null) {
            return RequestData.buildQueryString(this.mQueryData, this.mUrl);
        }
        return this.mUrl;
    }

    public void setRequestUrl(String url) {
        this.mUrl = url;
    }

    public HashMap<String, Object> getQueryData() {
        return this.mQueryData;
    }

    public HashMap<String, Object> getPostData() {
        return this.mPostData;
    }

    public void usePost(boolean use) {
        this.mUsePost = use;
    }

    public String getPostString() {
        return RequestData.buildQueryString(this.mPostData, null);
    }

    public boolean shouldPost() {
        return this.mUsePost || this.mPostData != null && this.mPostData.size() > 0;
    }
}

