/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.request;

import android.os.Handler;
import android.os.Message;
import in.srain.cube.request.IRequest;
import in.srain.cube.request.RequestData;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

public class SimpleRequestManager {
    private static final int REQUEST_SUCCESS = 1;
    private static final int REQUEST_FAILED = 2;

    public static <T> void sendRequest(final IRequest<T> request) {
        final Handler handler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        request.onRequestSuccess(msg.obj);
                        break;
                    }
                    case 2: {
                        request.onRequestFail(null);
                        break;
                    }
                }
            }
        };
        new Thread(new Runnable(){

            @Override
            public void run() {
                Message msg;
                Object data = null;
                try {
                    int bufferLength;
                    RequestData requestData = request.getRequestData();
                    StringBuilder sb = new StringBuilder();
                    URL url = new URL(request.getRequestData().getRequestUrl());
                    HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
                    if (requestData.shouldPost()) {
                        urlConnection.setRequestMethod("POST");
                        OutputStreamWriter writer = new OutputStreamWriter(urlConnection.getOutputStream());
                        writer.write(requestData.getPostString());
                        writer.flush();
                    }
                    BufferedInputStream ips = new BufferedInputStream(urlConnection.getInputStream());
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)ips, "UTF-8"));
                    char[] buffer = new char[1024];
                    while ((bufferLength = reader.read(buffer, 0, buffer.length)) > 0) {
                        sb.append(buffer, 0, bufferLength);
                    }
                    reader.close();
                    ((InputStream)ips).close();
                    data = request.onDataFromServer(sb.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (null == data) {
                    msg = Message.obtain();
                    msg.what = 2;
                    handler.sendMessage(msg);
                } else {
                    msg = Message.obtain();
                    msg.what = 1;
                    msg.obj = data;
                    handler.sendMessage(msg);
                }
            }
        }, "SimpleRequestBase-Manager").start();
    }
}

