/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.uri;

import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import in.srain.cube.request.JsonData;

public class CustomizedUri {
    private static final String KEY = "CUBE_URL";
    private JsonData mQueryData;
    private String mPath = null;
    private String mQuery = null;
    private String mUrl = null;

    public String getPath() {
        return this.mPath;
    }

    public String getQueryString() {
        return this.mQuery;
    }

    public JsonData getQueryData() {
        return this.mQueryData;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public static CustomizedUri parse(String url, String customizedSchema) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new RuntimeException("url is null");
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new RuntimeException("url is null");
        }
        if (!url.startsWith(customizedSchema)) {
            return null;
        }
        return new CustomizedUri(url, customizedSchema.length());
    }

    public void writeToBundle(Intent intent) {
        intent.putExtra(KEY, this.getUrl());
    }

    public static CustomizedUri fromIntent(Intent intent, String schema) {
        if (intent == null) {
            return null;
        }
        String url = intent.getStringExtra(KEY);
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        return CustomizedUri.parse(url, schema);
    }

    private CustomizedUri(String url, int len) {
        int pos_sp;
        this.mUrl = url;
        int pos_seg = url.indexOf(35);
        if (pos_seg > 0) {
            url = url.substring(0, pos_seg);
        }
        if ((pos_sp = url.indexOf(63)) > 0) {
            this.mQuery = url.substring(pos_sp + 1);
            url = url.substring(0, pos_sp);
        }
        this.mPath = url.substring(len);
        if (!TextUtils.isEmpty((CharSequence)this.mQuery)) {
            this.parseQuery();
        }
    }

    private void parseQuery() {
        this.mQueryData = JsonData.newMap();
        String query = this.mQuery;
        int start = 0;
        while (true) {
            int nextAmpersand;
            int end = (nextAmpersand = query.indexOf(38, start)) != -1 ? nextAmpersand : query.length();
            int separator = query.indexOf(61, start);
            if (separator > end || separator == -1) break;
            if (separator != start) {
                this.mQueryData.put(Uri.decode((String)query.substring(start, separator)), (Object)Uri.decode((String)query.substring(separator + 1, end)));
            }
            if (nextAmpersand == -1) break;
            start = nextAmpersand + 1;
        }
    }
}

