/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;

public class NetworkStatusManager {
    private static final String TAG = "NetworkStatusManager";
    private static final boolean DBG = true;
    private Context mContext;
    private State mState = State.UNKNOWN;
    private boolean mListening;
    private String mReason;
    private boolean mIsFailover;
    private NetworkInfo mNetworkInfo;
    private boolean mIsWifi = false;
    private static NetworkStatusManager sInstance;
    private NetworkInfo mOtherNetworkInfo;
    private ConnectivityBroadcastReceiver mReceiver = new ConnectivityBroadcastReceiver();

    public static void init(Context context) {
        sInstance = new NetworkStatusManager();
        NetworkStatusManager.sInstance.mIsWifi = NetworkStatusManager.checkIsWifi(context);
        sInstance.startListening(context);
    }

    public static NetworkStatusManager getInstance() {
        return sInstance;
    }

    public static boolean checkIsWifi(Context context) {
        NetworkInfo networkInfo;
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        return connectivity != null && (networkInfo = connectivity.getNetworkInfo(1)) != null && networkInfo.isConnectedOrConnecting();
    }

    private NetworkStatusManager() {
    }

    public synchronized void startListening(Context context) {
        if (!this.mListening) {
            this.mContext = context;
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            context.registerReceiver((BroadcastReceiver)this.mReceiver, filter);
            this.mListening = true;
        }
    }

    public synchronized void stopListening() {
        if (this.mListening) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mReceiver);
            this.mContext = null;
            this.mNetworkInfo = null;
            this.mOtherNetworkInfo = null;
            this.mIsFailover = false;
            this.mReason = null;
            this.mListening = false;
        }
    }

    public NetworkInfo getNetworkInfo() {
        return this.mNetworkInfo;
    }

    public NetworkInfo getOtherNetworkInfo() {
        return this.mOtherNetworkInfo;
    }

    public boolean isFailover() {
        return this.mIsFailover;
    }

    public String getReason() {
        return this.mReason;
    }

    public boolean isWifi() {
        return this.mIsWifi;
    }

    public static enum State {
        UNKNOWN,
        CONNECTED,
        NOT_CONNECTED;

    }

    private class ConnectivityBroadcastReceiver
    extends BroadcastReceiver {
        private ConnectivityBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (!action.equals("android.net.conn.CONNECTIVITY_CHANGE") || !NetworkStatusManager.this.mListening) {
                Log.w((String)NetworkStatusManager.TAG, (String)("onReceived() called with " + NetworkStatusManager.this.mState.toString() + " and " + intent));
                return;
            }
            boolean noConnectivity = intent.getBooleanExtra("noConnectivity", false);
            if (noConnectivity) {
                NetworkStatusManager.this.mState = State.NOT_CONNECTED;
            } else {
                NetworkStatusManager.this.mState = State.CONNECTED;
            }
            NetworkStatusManager.this.mNetworkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
            NetworkStatusManager.this.mOtherNetworkInfo = (NetworkInfo)intent.getParcelableExtra("otherNetwork");
            NetworkStatusManager.this.mReason = intent.getStringExtra("reason");
            NetworkStatusManager.this.mIsFailover = intent.getBooleanExtra("isFailover", false);
            Log.d((String)NetworkStatusManager.TAG, (String)("onReceive(): mNetworkInfo=" + NetworkStatusManager.this.mNetworkInfo + " mOtherNetworkInfo = " + (NetworkStatusManager.this.mOtherNetworkInfo == null ? "[none]" : NetworkStatusManager.this.mOtherNetworkInfo + " noConn=" + noConnectivity) + " mState=" + NetworkStatusManager.this.mState.toString()));
            NetworkStatusManager.this.mIsWifi = NetworkStatusManager.checkIsWifi(NetworkStatusManager.this.mContext);
        }
    }
}

