/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.util;

import android.app.ActivityManager;
import android.content.Context;
import android.util.Log;
import java.util.Timer;
import java.util.TimerTask;

public class SystemWatcher {
    private static SystemWatcher sInstance = new SystemWatcher();
    private Context mContext;
    private Timer mTimer;
    private TimerTask mTimerTask;

    private SystemWatcher() {
    }

    public static SystemWatcher getInstance() {
        return sInstance;
    }

    public static void init(Context context) {
        SystemWatcher.sInstance.mContext = context;
    }

    public void run() {
        this.mTimerTask = new TimerTask(){

            @Override
            public void run() {
                ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
                ActivityManager activityManager = (ActivityManager)SystemWatcher.this.mContext.getSystemService("activity");
                activityManager.getMemoryInfo(mi);
                Runtime runtime = Runtime.getRuntime();
                String s = String.format("free:%s%% %sKB total:%sKB max:%sKB ", Float.valueOf((float)runtime.freeMemory() * 100.0f / (float)runtime.totalMemory()), runtime.freeMemory(), runtime.totalMemory() / 1024L, runtime.maxMemory() / 1024L);
                Log.d((String)"memory", (String)s);
            }
        };
        this.mTimer = new Timer();
        this.mTimer.schedule(this.mTimerTask, 1000L, 1000L);
    }
}

