/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import in.srain.cube.R;
import in.srain.cube.views.banner.PagerIndicator;

public class DotView
extends LinearLayout
implements PagerIndicator {
    private int mLittleDotSize = -2;
    private int mDotSpan = 36;
    private float mDotRadius = 6.0f;
    private int mCurrent = 0;
    private int mTotal = 0;
    private int mSelectedColor = -13141010;
    private int mUnSelectedColor = -3813669;
    private OnDotClickHandler mOnDotClickHandler;
    private View.OnClickListener mDotClickHandler = new View.OnClickListener(){

        public void onClick(View v) {
            if (v instanceof LittleDot && null != DotView.this.mOnDotClickHandler) {
                DotView.this.mOnDotClickHandler.onDotClick(((LittleDot)v).getIndex());
            }
        }
    };

    public DotView(Context context) {
        super(context);
    }

    public DotView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setGravity(1);
        TypedArray arr = context.obtainStyledAttributes(attrs, R.styleable.DotView, 0, 0);
        if (arr != null) {
            if (arr.hasValue(0)) {
                this.mDotRadius = arr.getDimension(0, this.mDotRadius);
            }
            if (arr.hasValue(1)) {
                this.mDotSpan = (int)arr.getDimension(1, (float)this.mDotSpan);
            }
            this.mSelectedColor = arr.getColor(3, this.mSelectedColor);
            this.mUnSelectedColor = arr.getColor(2, this.mUnSelectedColor);
            arr.recycle();
        }
        this.mLittleDotSize = (int)((float)(this.mDotSpan / 2) + this.mDotRadius * 2.0f);
    }

    @Override
    public final void setNum(int num) {
        if (num < 0) {
            return;
        }
        this.mTotal = num;
        this.removeAllViews();
        this.setOrientation(0);
        for (int i = 0; i < num; ++i) {
            LittleDot dot = new LittleDot(this.getContext(), i);
            if (i == 0) {
                dot.setColor(this.mSelectedColor);
            } else {
                dot.setColor(this.mUnSelectedColor);
            }
            dot.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.mLittleDotSize, (int)this.mDotRadius * 2, 1.0f));
            dot.setClickable(true);
            dot.setOnClickListener(this.mDotClickHandler);
            this.addView(dot);
        }
    }

    @Override
    public int getTotal() {
        return this.mTotal;
    }

    @Override
    public int getCurrentIndex() {
        return this.mCurrent;
    }

    public void setOnDotClickHandler(OnDotClickHandler handler) {
        this.mOnDotClickHandler = handler;
    }

    @Override
    public final void setSelected(int index) {
        if (index >= this.getChildCount() || index < 0 || this.mCurrent == index) {
            return;
        }
        ((LittleDot)this.getChildAt(this.mCurrent)).setColor(this.mUnSelectedColor);
        ((LittleDot)this.getChildAt(index)).setColor(this.mSelectedColor);
        this.mCurrent = index;
    }

    private class LittleDot
    extends View {
        private int mColor;
        private Paint mPaint;
        private int mIndex;

        public LittleDot(Context context, int index) {
            super(context);
            this.mPaint = new Paint();
            this.mPaint.setAntiAlias(true);
            this.mIndex = index;
        }

        public int getIndex() {
            return this.mIndex;
        }

        public void setColor(int color) {
            if (color == this.mColor) {
                return;
            }
            this.mColor = color;
            this.invalidate();
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            this.mPaint.setColor(this.mColor);
            canvas.drawCircle((float)(DotView.this.mLittleDotSize / 2), DotView.this.mDotRadius, DotView.this.mDotRadius, this.mPaint);
        }
    }

    public static interface OnDotClickHandler {
        public void onDotClick(int var1);
    }
}

