/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import in.srain.cube.R;

public class MoreActionView
extends View {
    private int mColor = -1;
    private Paint mPaint;
    private float mDotRadius = 3.0f;
    private float mDotSpan = 5.0f;

    public MoreActionView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray arr = context.obtainStyledAttributes(attrs, R.styleable.MoreActionView, 0, 0);
        if (arr != null) {
            if (arr.hasValue(0)) {
                this.mDotRadius = arr.getDimension(0, this.mDotRadius);
            }
            if (arr.hasValue(1)) {
                this.mDotSpan = (int)arr.getDimension(1, this.mDotSpan);
            }
            this.mColor = arr.getColor(2, this.mColor);
            arr.recycle();
        }
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(this.mColor);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int desiredHeight = (int)(this.mDotRadius * 2.0f);
        int desiredWidth = (int)(this.mDotRadius * 6.0f + this.mDotSpan * 2.0f);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(desiredWidth, widthSize) : desiredWidth);
        int height = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? Math.min(desiredHeight, heightSize) : desiredHeight);
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int i = 0; i < 3; ++i) {
            float x = (float)i * (this.mDotRadius * 2.0f + this.mDotSpan) + this.mDotRadius;
            canvas.drawCircle(x, this.mDotRadius, this.mDotRadius, this.mPaint);
        }
    }
}

