/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.views.list;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import in.srain.cube.util.CLog;
import in.srain.cube.util.Debug;
import in.srain.cube.views.list.ViewHolderBase;
import in.srain.cube.views.list.ViewHolderCreator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public abstract class ListViewDataAdapterBase<ItemDataType>
extends BaseAdapter {
    private static String LOG_TAG = "cube_list";
    protected ViewHolderCreator<ItemDataType> mViewHolderCreator;
    protected ViewHolderCreator<ItemDataType> mLazyCreator;
    protected boolean mForceCreateView = false;

    public ListViewDataAdapterBase() {
    }

    public ListViewDataAdapterBase(Object enclosingInstance, Class<?> cls) {
        this.setViewHolderClass(enclosingInstance, cls);
    }

    public ListViewDataAdapterBase(ViewHolderCreator<ItemDataType> viewHolderCreator) {
        this.mViewHolderCreator = viewHolderCreator;
    }

    public void setViewHolderCreator(ViewHolderCreator<ItemDataType> viewHolderCreator) {
        this.mViewHolderCreator = viewHolderCreator;
    }

    public void setViewHolderClass(final Object enclosingInstance, final Class<?> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("ViewHolderClass is null.");
        }
        this.mLazyCreator = new ViewHolderCreator<ItemDataType>(){

            @Override
            public ViewHolderBase<ItemDataType> createViewHolder() {
                Object object = null;
                try {
                    if (cls.getEnclosingClass() == null) {
                        Constructor constructor = cls.getDeclaredConstructor(new Class[0]);
                        constructor.setAccessible(true);
                        object = constructor.newInstance(new Object[0]);
                    } else if (Modifier.isStatic(cls.getModifiers())) {
                        Constructor constructor = cls.getDeclaredConstructor(new Class[0]);
                        constructor.setAccessible(true);
                        object = constructor.newInstance(new Object[0]);
                    } else {
                        Constructor constructor = cls.getDeclaredConstructor(enclosingInstance.getClass());
                        constructor.setAccessible(true);
                        object = constructor.newInstance(enclosingInstance);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (object == null || !(object instanceof ViewHolderBase)) {
                    throw new IllegalArgumentException("ViewHolderClass can not be initiated");
                }
                return object;
            }
        };
    }

    private ViewHolderBase<ItemDataType> createViewHolder() {
        if (this.mViewHolderCreator == null && this.mLazyCreator == null) {
            throw new RuntimeException("view holder creator is null");
        }
        if (this.mViewHolderCreator != null) {
            return this.mViewHolderCreator.createViewHolder();
        }
        if (this.mLazyCreator != null) {
            return this.mLazyCreator.createViewHolder();
        }
        return null;
    }

    public void forceCreateView(boolean yes) {
        this.mForceCreateView = yes;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (Debug.DEBUG_LIST) {
            CLog.d((String)LOG_TAG, (String)"getView %s", (Object[])new Object[]{position});
        }
        ItemDataType itemData = this.getItem(position);
        ViewHolderBase holderBase = null;
        if (this.mForceCreateView || convertView == null || !(convertView.getTag() instanceof ViewHolderBase)) {
            LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
            holderBase = this.createViewHolder();
            if (holderBase != null && (convertView = holderBase.createView(inflater)) != null && !this.mForceCreateView) {
                convertView.setTag((Object)holderBase);
            }
        } else {
            holderBase = (ViewHolderBase)convertView.getTag();
        }
        if (holderBase != null) {
            holderBase.setItemData(position, convertView);
            holderBase.showData(position, itemData);
        }
        return convertView;
    }

    public abstract ItemDataType getItem(int var1);
}

