/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.base.activity;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.fragment.app.Fragment;
import com.lodz.android.corekt.utils.ReflectUtils;
import com.lodz.android.pandora.base.activity.UseAnkoLayout;
import com.lodz.android.pandora.base.application.BaseApplication;
import com.lodz.android.pandora.base.fragment.IFragmentBackPressed;
import com.lodz.android.pandora.base.fragment.LazyFragment;
import com.lodz.android.pandora.event.ActivityFinishEvent;
import com.trello.rxlifecycle4.LifecycleTransformer;
import com.trello.rxlifecycle4.android.ActivityEvent;
import com.trello.rxlifecycle4.components.support.RxAppCompatActivity;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u0012\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0004J\b\u0010\u000f\u001a\u00020\u0006H\u0014J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0004J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0011\"\u0004\b\u0000\u0010\u0014H\u0004J\b\u0010\u0015\u001a\u00020\u0006H\u0014J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u0017\u001a\u00020\bH\u0004J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u0012\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u0006H\u0016J\b\u0010\u001d\u001a\u00020\bH%J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!H\u0004J\n\u0010\"\u001a\u0004\u0018\u00010\u001bH\u0014J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0004J\b\u0010$\u001a\u00020\u0006H\u0014J\b\u0010%\u001a\u00020\u0004H\u0002J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010'\u001a\u00020\u0004H\u0004J\u0010\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020*H\u0007J\u0006\u0010+\u001a\u00020\u0006J\u0012\u0010,\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0004J\b\u0010-\u001a\u00020\u0004H\u0014J\u0010\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u001bH\u0014J\u0010\u00100\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u001bH\u0014J\"\u00103\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0004J\b\u00104\u001a\u00020\u0006H\u0014J\u0010\u00105\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0004J\b\u00106\u001a\u00020\u0006H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/lodz/android/pandora/base/activity/AbsActivity;", "Lcom/trello/rxlifecycle4/components/support/RxAppCompatActivity;", "()V", "isPdrUseAnko", "", "addFragment", "", "containerViewId", "", "fragment", "Landroidx/fragment/app/Fragment;", "tag", "", "addToBackStack", "name", "afterSetContentView", "bindAnyDestroyEvent", "Lcom/trello/rxlifecycle4/LifecycleTransformer;", "", "bindDestroyEvent", "T", "endCreate", "findFragmentById", "id", "findFragmentByTag", "findViews", "savedInstanceState", "Landroid/os/Bundle;", "finish", "getAbsLayoutId", "getContext", "Landroid/content/Context;", "getFragments", "", "getSaveBundle", "hideFragment", "initData", "injectAnko", "isFragmentConsumeBackPressed", "isUseAnkoLayout", "onActivityFinishEvent", "event", "Lcom/lodz/android/pandora/event/ActivityFinishEvent;", "onBackPressed", "onCreate", "onPressBack", "onRestore", "bundle", "onRestoreInstanceState", "onSaveInstanceState", "outState", "replaceFragment", "setListeners", "showFragment", "startCreate", "pandora_release"})
public abstract class AbsActivity
extends RxAppCompatActivity {
    private boolean isPdrUseAnko;

    protected final void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.isPdrUseAnko = this.injectAnko();
        EventBus.getDefault().register((Object)this);
        this.startCreate();
        if (!this.isPdrUseAnko) {
            this.setContentView(this.getAbsLayoutId());
        }
        this.afterSetContentView();
        this.findViews(savedInstanceState);
        this.setListeners();
        this.initData();
        this.endCreate();
    }

    protected void startCreate() {
    }

    @LayoutRes
    protected abstract int getAbsLayoutId();

    protected void afterSetContentView() {
    }

    protected void findViews(@Nullable Bundle savedInstanceState) {
    }

    protected void setListeners() {
    }

    protected void initData() {
    }

    protected void endCreate() {
    }

    @NotNull
    protected Context getContext() {
        return (Context)this;
    }

    public void finish() {
        EventBus.getDefault().unregister((Object)this);
        super.finish();
    }

    public final void onBackPressed() {
        List list = this.getSupportFragmentManager().getFragments();
        if (list != null) {
            Collection collection = list;
            boolean bl = false;
            if (!collection.isEmpty()) {
                for (Fragment fragment : list) {
                    if (!this.isFragmentConsumeBackPressed(fragment)) continue;
                    return;
                }
            }
        }
        if (!this.onPressBack()) {
            super.onBackPressed();
        }
    }

    private final boolean isFragmentConsumeBackPressed(Fragment fragment) {
        if (fragment.getChildFragmentManager().getFragments().size() > 0) {
            List list = fragment.getChildFragmentManager().getFragments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fragment.childFragmentManager.fragments");
            List list2 = list;
            for (Fragment f : list2) {
                Intrinsics.checkNotNullExpressionValue((Object)f, (String)"f");
                if (!this.isFragmentConsumeBackPressed(f)) continue;
                return true;
            }
        }
        if (fragment.getUserVisibleHint() && fragment.isVisible() && fragment instanceof IFragmentBackPressed) {
            Fragment parentFragment = fragment.getParentFragment();
            if (parentFragment != null && !parentFragment.getUserVisibleHint()) {
                return false;
            }
            if (fragment instanceof LazyFragment) {
                boolean isAlreadyPause;
                Object obj;
                LazyFragment lazyFragment = (LazyFragment)fragment;
                Class c = ReflectUtils.getClassForName((String)"com.lodz.android.component.base.fragment.LazyFragment");
                if (c != null && (obj = ReflectUtils.getFieldValue((Class)c, (Object)lazyFragment, (String)"isAlreadyPause")) != null && obj instanceof Boolean && (isAlreadyPause = ((Boolean)obj).booleanValue())) {
                    return false;
                }
            }
            IFragmentBackPressed itf = (IFragmentBackPressed)fragment;
            return itf.onPressBack();
        }
        return false;
    }

    protected boolean onPressBack() {
        return false;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public final void onActivityFinishEvent(@NotNull ActivityFinishEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isFinishing()) {
            this.finish();
        }
    }

    protected void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        Bundle bundle = this.getSaveBundle();
        BaseApplication app = BaseApplication.Companion.get();
        if (app != null && bundle != null) {
            String string = ((Object)((Object)this)).getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
            app.putSaveInstanceState(string, bundle);
        }
    }

    @Nullable
    protected Bundle getSaveBundle() {
        return null;
    }

    protected void onRestoreInstanceState(@NotNull Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)savedInstanceState, (String)"savedInstanceState");
        super.onRestoreInstanceState(savedInstanceState);
        BaseApplication baseApplication = BaseApplication.Companion.get();
        if (baseApplication == null) {
            return;
        }
        BaseApplication app = baseApplication;
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        Bundle bundle = app.getSaveInstanceState(string);
        if (bundle != null) {
            this.onRestore(bundle);
        }
    }

    protected void onRestore(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
    }

    protected final void addFragment(@IdRes int containerViewId, @NotNull Fragment fragment, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.getSupportFragmentManager().beginTransaction().add(containerViewId, fragment, tag).commit();
    }

    protected final void replaceFragment(@IdRes int containerViewId, @NotNull Fragment fragment, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.getSupportFragmentManager().beginTransaction().replace(containerViewId, fragment, tag).commit();
    }

    protected final void showFragment(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.getSupportFragmentManager().beginTransaction().show(fragment).commit();
    }

    protected final void hideFragment(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.getSupportFragmentManager().beginTransaction().hide(fragment).commit();
    }

    @NotNull
    protected final List<Fragment> getFragments() {
        List list = this.getSupportFragmentManager().getFragments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"supportFragmentManager.fragments");
        return list;
    }

    @Nullable
    protected final Fragment findFragmentByTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return this.getSupportFragmentManager().findFragmentByTag(tag);
    }

    @Nullable
    protected final Fragment findFragmentById(@IdRes int id) {
        return this.getSupportFragmentManager().findFragmentById(id);
    }

    protected final void addToBackStack(@Nullable String name) {
        this.getSupportFragmentManager().beginTransaction().addToBackStack(name).commit();
    }

    protected final boolean isUseAnkoLayout() {
        return this.isPdrUseAnko;
    }

    private final boolean injectAnko() {
        try {
            if (!((Object)((Object)this)).getClass().isAnnotationPresent(UseAnkoLayout.class)) {
                return false;
            }
            UseAnkoLayout useAnkoLayout = ((Object)((Object)this)).getClass().getAnnotation(UseAnkoLayout.class);
            if (useAnkoLayout == null) {
                return false;
            }
            UseAnkoLayout inject = useAnkoLayout;
            return inject.value();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @NotNull
    protected final <T> LifecycleTransformer<T> bindDestroyEvent() {
        LifecycleTransformer lifecycleTransformer = this.bindUntilEvent(ActivityEvent.DESTROY);
        Intrinsics.checkNotNullExpressionValue((Object)lifecycleTransformer, (String)"bindUntilEvent(ActivityEvent.DESTROY)");
        return lifecycleTransformer;
    }

    @NotNull
    protected final LifecycleTransformer<Object> bindAnyDestroyEvent() {
        LifecycleTransformer lifecycleTransformer = this.bindUntilEvent(ActivityEvent.DESTROY);
        Intrinsics.checkNotNullExpressionValue((Object)lifecycleTransformer, (String)"bindUntilEvent(ActivityEvent.DESTROY)");
        return lifecycleTransformer;
    }

    public void _$_clearFindViewByIdCache() {
    }
}

