/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.photopicker.picker;

import android.content.Context;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.IntRange;
import com.lodz.android.corekt.album.PicInfo;
import com.lodz.android.pandora.photopicker.contract.OnImgLoader;
import com.lodz.android.pandora.photopicker.contract.picker.OnPhotoPickerListener;
import com.lodz.android.pandora.photopicker.picker.PickerBean;
import com.lodz.android.pandora.photopicker.picker.PickerManager;
import com.lodz.android.pandora.photopicker.picker.PickerUIConfig;
import com.lodz.android.pandora.photopicker.preview.AbsImageView;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bJ\u001f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0010\u001a\u00020\u000bJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0012\u001a\u00020\u000bJ \u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00160\u0015JY\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002K\u0010\u0018\u001aG\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b( \u0012\u0004\u0012\u00020!0\u0019J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\"J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0001\u0010$\u001a\u00020%J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010'\u001a\u00020(J\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010*\u001a\u00020(J\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010,\u001a\u00020-J\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010/\u001a\u000200R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/lodz/android/pandora/photopicker/picker/PickerBuilder;", "V", "Landroid/view/View;", "", "()V", "pickerBean", "Lcom/lodz/android/pandora/photopicker/picker/PickerBean;", "build", "Lcom/lodz/android/pandora/photopicker/picker/PickerManager;", "sourceArray", "", "", "([Ljava/lang/String;)Lcom/lodz/android/pandora/photopicker/picker/PickerManager;", "sourceList", "", "setAuthority", "authority", "setCameraSavePath", "savePath", "setImageView", "view", "Lcom/lodz/android/pandora/photopicker/preview/AbsImageView;", "Lcom/lodz/android/corekt/album/PicInfo;", "setImgLoader", "imgLoader", "Lkotlin/Function3;", "Landroid/content/Context;", "Lkotlin/ParameterName;", "name", "context", "source", "Landroid/widget/ImageView;", "imageView", "", "Lcom/lodz/android/pandora/photopicker/contract/OnImgLoader;", "setMaxCount", "maxCount", "", "setNeedCamera", "needCamera", "", "setNeedItemPreview", "needItemPreview", "setOnPhotoPickerListener", "listener", "Lcom/lodz/android/pandora/photopicker/contract/picker/OnPhotoPickerListener;", "setPickerUIConfig", "config", "Lcom/lodz/android/pandora/photopicker/picker/PickerUIConfig;", "pandora_release"})
public final class PickerBuilder<V extends View> {
    @NotNull
    private final PickerBean<V> pickerBean = new PickerBean();

    @NotNull
    public final PickerBuilder<V> setImgLoader(@NotNull OnImgLoader<? super PicInfo> imgLoader) {
        Intrinsics.checkNotNullParameter(imgLoader, (String)"imgLoader");
        this.pickerBean.setImgLoader(imgLoader);
        return this;
    }

    @NotNull
    public final PickerBuilder<V> setImgLoader(@NotNull Function3<? super Context, ? super PicInfo, ? super ImageView, Unit> imgLoader) {
        Intrinsics.checkNotNullParameter(imgLoader, (String)"imgLoader");
        return this.setImgLoader((arg_0, arg_1, arg_2) -> PickerBuilder.setImgLoader$lambda-0(imgLoader, arg_0, arg_1, arg_2));
    }

    @NotNull
    public final PickerBuilder<V> setOnPhotoPickerListener(@NotNull OnPhotoPickerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.pickerBean.setPhotoPickerListener(listener);
        return this;
    }

    @NotNull
    public final PickerBuilder<V> setMaxCount(@IntRange(from=1L) int maxCount) {
        if (maxCount > 0) {
            this.pickerBean.setMaxCount(maxCount);
        }
        return this;
    }

    @NotNull
    public final PickerBuilder<V> setNeedCamera(boolean needCamera) {
        this.pickerBean.setNeedCamera(needCamera);
        return this;
    }

    @NotNull
    public final PickerBuilder<V> setNeedItemPreview(boolean needItemPreview) {
        this.pickerBean.setNeedItemPreview(needItemPreview);
        return this;
    }

    @NotNull
    public final PickerBuilder<V> setCameraSavePath(@NotNull String savePath) {
        Intrinsics.checkNotNullParameter((Object)savePath, (String)"savePath");
        this.pickerBean.setCameraSavePath(savePath);
        return this;
    }

    @NotNull
    public final PickerBuilder<V> setPickerUIConfig(@NotNull PickerUIConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.pickerBean.setPickerUIConfig(config);
        return this;
    }

    @NotNull
    public final PickerBuilder<V> setAuthority(@NotNull String authority) {
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        this.pickerBean.setAuthority(authority);
        return this;
    }

    @NotNull
    public final PickerBuilder<V> setImageView(@NotNull AbsImageView<V, PicInfo> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        this.pickerBean.setImgView(view);
        return this;
    }

    @NotNull
    public final PickerManager<V> build() {
        this.pickerBean.setPickAllPhoto(true);
        return new PickerManager<V>(this.pickerBean);
    }

    @NotNull
    public final PickerManager<V> build(@NotNull List<String> sourceList) {
        Intrinsics.checkNotNullParameter(sourceList, (String)"sourceList");
        ArrayList<PicInfo> infos = new ArrayList<PicInfo>();
        for (String url : sourceList) {
            Uri uri = Uri.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"EMPTY");
            infos.add(new PicInfo(url, uri));
        }
        this.pickerBean.setPickAllPhoto(false);
        this.pickerBean.setSourceList((List<PicInfo>)infos);
        return new PickerManager<V>(this.pickerBean);
    }

    @NotNull
    public final PickerManager<V> build(@NotNull String[] sourceArray) {
        Intrinsics.checkNotNullParameter((Object)sourceArray, (String)"sourceArray");
        ArrayList<PicInfo> infos = new ArrayList<PicInfo>();
        for (String url : sourceArray) {
            Uri uri = Uri.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"EMPTY");
            infos.add(new PicInfo(url, uri));
        }
        this.pickerBean.setPickAllPhoto(false);
        this.pickerBean.setSourceList((List<PicInfo>)infos);
        return new PickerManager<V>(this.pickerBean);
    }

    private static final void setImgLoader$lambda-0(Function3 $imgLoader, Context context, PicInfo source, ImageView imageView) {
        Intrinsics.checkNotNullParameter((Object)$imgLoader, (String)"$imgLoader");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        $imgLoader.invoke((Object)context, (Object)source, (Object)imageView);
    }
}

