/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.photopicker.picker;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.view.View;
import com.lodz.android.corekt.album.AlbumUtils;
import com.lodz.android.corekt.album.PicInfo;
import com.lodz.android.corekt.anko.AnkoArrayKt;
import com.lodz.android.corekt.anko.AnkoToastKt;
import com.lodz.android.corekt.utils.ToastUtils;
import com.lodz.android.pandora.R;
import com.lodz.android.pandora.photopicker.picker.PickerBean;
import com.lodz.android.pandora.photopicker.picker.PickerBuilder;
import com.lodz.android.pandora.photopicker.picker.pick.PhotoPickerActivity;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u000e*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u000eB\u0015\b\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/lodz/android/pandora/photopicker/picker/PickerManager;", "V", "Landroid/view/View;", "", "pickerBean", "Lcom/lodz/android/pandora/photopicker/picker/PickerBean;", "(Lcom/lodz/android/pandora/photopicker/picker/PickerBean;)V", "open", "", "context", "Landroid/content/Context;", "flags", "", "", "Companion", "pandora_release"})
public final class PickerManager<V extends View> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PickerBean<V> pickerBean;

    public PickerManager(@NotNull PickerBean<V> pickerBean) {
        Intrinsics.checkNotNullParameter(pickerBean, (String)"pickerBean");
        this.pickerBean = pickerBean;
    }

    @JvmOverloads
    public final void open(@NotNull Context context, @Nullable List<Integer> flags) {
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.pickerBean.getImgLoader() == null) {
            AnkoToastKt.toastShort((Context)context, (int)R.string.pandora_photo_loader_unset);
            return;
        }
        if (this.pickerBean.getImgView() == null) {
            ToastUtils.Companion.showShort(context, R.string.pandora_preview_img_unset);
            return;
        }
        if (this.pickerBean.getPhotoPickerListener() == null) {
            AnkoToastKt.toastShort((Context)context, (int)R.string.pandora_photo_selected_listener_unset);
            return;
        }
        if (!this.pickerBean.isPickAllPhoto()) {
            object = this.pickerBean.getSourceList();
            bl = false;
            boolean bl2 = false;
            if (object == null || object.isEmpty()) {
                AnkoToastKt.toastShort((Context)context, (int)R.string.pandora_photo_source_list_empty);
                return;
            }
        }
        if (this.pickerBean.isPickAllPhoto() && !this.pickerBean.isNeedCamera() && AlbumUtils.getAllImages((Context)context).isEmpty()) {
            AnkoToastKt.toastShort((Context)context, (int)R.string.pandora_photo_source_list_empty);
            return;
        }
        if (this.pickerBean.getMaxCount() < 1) {
            this.pickerBean.setMaxCount(1);
        }
        if (!this.pickerBean.isPickAllPhoto()) {
            List<PicInfo> list = this.pickerBean.getSourceList();
            Intrinsics.checkNotNull(list);
            this.pickerBean.setSourceList(CollectionsKt.toList((Iterable)AnkoArrayKt.deduplication((Collection)list)));
            this.pickerBean.setNeedCamera(false);
        }
        if (this.pickerBean.isNeedCamera()) {
            object = this.pickerBean.getCameraSavePath();
            bl = false;
            if (object.length() == 0) {
                if (Build.VERSION.SDK_INT >= 29) {
                    String string2;
                    object = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
                    this.pickerBean.setCameraSavePath(object == null ? "" : ((string2 = ((File)object).getAbsolutePath()) == null ? "" : string2));
                }
                object = this.pickerBean.getCameraSavePath();
                bl = false;
                if (object.length() == 0) {
                    object = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getExternalStoragePublicDirectory(Environment.DIRECTORY_PICTURES).absolutePath");
                    this.pickerBean.setCameraSavePath((String)object);
                }
            }
        }
        if (this.pickerBean.isNeedCamera()) {
            String string3 = this.pickerBean.getCameraSavePath();
            object = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"separator");
            if (!StringsKt.endsWith$default((String)string3, (String)object, (boolean)false, (int)2, null)) {
                object = this.pickerBean;
                ((PickerBean)object).setCameraSavePath(Intrinsics.stringPlus((String)((PickerBean)object).getCameraSavePath(), (Object)File.separator));
            }
        }
        if (Build.VERSION.SDK_INT >= 24 && this.pickerBean.isNeedCamera()) {
            object = this.pickerBean.getAuthority();
            bl = false;
            if (object.length() == 0) {
                AnkoToastKt.toastShort((Context)context, (int)R.string.pandora_photo_authority_empty);
                return;
            }
        }
        PhotoPickerActivity.Companion.start$pandora_release(context, this.pickerBean, flags);
    }

    public static /* synthetic */ void open$default(PickerManager pickerManager, Context context, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        pickerManager.open(context, list);
    }

    @JvmOverloads
    public final void open(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PickerManager.open$default(this, context, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final <V extends View> PickerBuilder<V> create() {
        return Companion.create();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/lodz/android/pandora/photopicker/picker/PickerManager$Companion;", "", "()V", "create", "Lcom/lodz/android/pandora/photopicker/picker/PickerBuilder;", "V", "Landroid/view/View;", "pandora_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <V extends View> PickerBuilder<V> create() {
            return new PickerBuilder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

