/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.photopicker.picker.dialog;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.recyclerview.widget.RecyclerView;
import com.lodz.android.corekt.album.ImageFolder;
import com.lodz.android.corekt.album.PicInfo;
import com.lodz.android.corekt.anko.AnkoContextCompatKt;
import com.lodz.android.corekt.anko.AnkoDimensionsKt;
import com.lodz.android.pandora.R;
import com.lodz.android.pandora.photopicker.contract.OnImgLoader;
import com.lodz.android.pandora.photopicker.picker.PickerUIConfig;
import com.lodz.android.pandora.photopicker.picker.dialog.ImageFolderItemBean;
import com.lodz.android.pandora.widget.rv.recycler.BaseRecyclerViewAdapter;
import com.lodz.android.pandora.widget.rv.recycler.DataViewHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\f\u001a\u00020\n2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u00020\n2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0016\u0010\u0019\u001a\u00020\u00112\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007J\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0002H\u0002R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/lodz/android/pandora/photopicker/picker/dialog/ImageFolderAdapter;", "Lcom/lodz/android/pandora/widget/rv/recycler/BaseRecyclerViewAdapter;", "Lcom/lodz/android/pandora/photopicker/picker/dialog/ImageFolderItemBean;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mPdrImgLoader", "Lcom/lodz/android/pandora/photopicker/contract/OnImgLoader;", "Lcom/lodz/android/corekt/album/PicInfo;", "mPdrSelectedBitmap", "Landroid/graphics/Bitmap;", "mPdrUnselectBitmap", "getSelectedBitmap", "color", "", "getUnselectBitmap", "onBind", "", "holder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setOnImgLoader", "imgLoader", "setPickerUIConfig", "config", "Lcom/lodz/android/pandora/photopicker/picker/PickerUIConfig;", "showItem", "Lcom/lodz/android/pandora/widget/rv/recycler/DataViewHolder;", "bean", "pandora_release"})
public final class ImageFolderAdapter
extends BaseRecyclerViewAdapter<ImageFolderItemBean> {
    @Nullable
    private OnImgLoader<? super PicInfo> mPdrImgLoader;
    @Nullable
    private Bitmap mPdrUnselectBitmap;
    @Nullable
    private Bitmap mPdrSelectedBitmap;

    public ImageFolderAdapter(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    public final void setOnImgLoader(@Nullable OnImgLoader<? super PicInfo> imgLoader) {
        this.mPdrImgLoader = imgLoader;
    }

    public final void setPickerUIConfig(@NotNull PickerUIConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.mPdrUnselectBitmap = this.getUnselectBitmap(config.getFolderSelectColor$pandora_release());
        this.mPdrSelectedBitmap = this.getSelectedBitmap(config.getFolderSelectColor$pandora_release());
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return new DataViewHolder(BaseRecyclerViewAdapter.getLayoutView$default(this, parent, R.layout.pandora_item_img_folder, false, 4, null));
    }

    @Override
    public void onBind(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        ImageFolderItemBean bean = (ImageFolderItemBean)this.getItem(position);
        if (bean == null || !(holder instanceof DataViewHolder)) {
            return;
        }
        this.showItem((DataViewHolder)holder, bean);
    }

    private final void showItem(DataViewHolder holder, ImageFolderItemBean bean) {
        Object object = bean.getImageFolder();
        if (object == null) {
            return;
        }
        ImageFolder imageFolder = object;
        object = this.mPdrImgLoader;
        if (object != null) {
            object.displayImg(this.getContext(), imageFolder.getCoverPicInfo(), (ImageView)holder.withView(R.id.pdr_cover_img));
        }
        ((TextView)holder.withView(R.id.pdr_floder_name_tv)).setText((CharSequence)imageFolder.getName());
        object = new Object[]{String.valueOf(imageFolder.getCount())};
        ((TextView)holder.withView(R.id.pdr_count_tv)).setText((CharSequence)this.getContext().getString(R.string.pandora_picker_folder_num, (Object[])object));
        ((ImageView)holder.withView(R.id.pdr_select_img)).setImageBitmap(bean.isSelected() ? this.mPdrSelectedBitmap : this.mPdrUnselectBitmap);
        ((TextView)holder.withView(R.id.pdr_dir_tv)).setText(imageFolder.isAllPicture() ? (CharSequence)imageFolder.getName() : (CharSequence)imageFolder.getDir());
    }

    private final Bitmap getUnselectBitmap(@ColorRes int color) {
        float side = AnkoDimensionsKt.dp2pxRF((Context)this.getContext(), (int)30);
        Bitmap bitmap = Bitmap.createBitmap((int)((int)side), (int)((int)side), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(0);
        Paint paint = new Paint();
        paint.setColor(AnkoContextCompatKt.getColorCompat((Context)this.getContext(), (int)color));
        paint.setStrokeWidth(4.0f);
        paint.setAntiAlias(true);
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawCircle(side / (float)2, side / (float)2, side / (float)2 - (float)10, paint);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }

    private final Bitmap getSelectedBitmap(@ColorRes int color) {
        float side = AnkoDimensionsKt.dp2pxRF((Context)this.getContext(), (int)30);
        Bitmap bitmap = Bitmap.createBitmap((int)((int)side), (int)((int)side), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(0);
        Paint paint = new Paint();
        paint.setColor(AnkoContextCompatKt.getColorCompat((Context)this.getContext(), (int)color));
        paint.setStrokeWidth(4.0f);
        paint.setAntiAlias(true);
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawCircle(side / (float)2, side / (float)2, side / (float)2 - (float)10, paint);
        paint.setAntiAlias(true);
        paint.setStyle(Paint.Style.FILL);
        canvas.drawCircle(side / (float)2, side / (float)2, side / (float)2 - (float)25, paint);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }
}

