/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.photopicker.picker.pick;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.ColorRes;
import androidx.recyclerview.widget.RecyclerView;
import com.lodz.android.corekt.album.PicInfo;
import com.lodz.android.corekt.anko.AnkoContextCompatKt;
import com.lodz.android.corekt.anko.AnkoDimensionsKt;
import com.lodz.android.corekt.anko.AnkoScreenKt;
import com.lodz.android.pandora.R;
import com.lodz.android.pandora.photopicker.contract.OnImgLoader;
import com.lodz.android.pandora.photopicker.picker.PickerItemBean;
import com.lodz.android.pandora.photopicker.picker.PickerUIConfig;
import com.lodz.android.pandora.widget.rv.recycler.BaseRecyclerViewAdapter;
import com.lodz.android.pandora.widget.rv.recycler.DataViewHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003012B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\u0012\u0010\u001b\u001a\u00020\u00162\b\b\u0001\u0010\u001c\u001a\u00020\u000eH\u0002J\u0012\u0010\u001d\u001a\u00020\u00162\b\b\u0001\u0010\u001c\u001a\u00020\u000eH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\u0018\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000eH\u0016J\u0006\u0010&\u001a\u00020\u001fJ\u0018\u0010'\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u000eH\u0014J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u000eH\u0014J\u000e\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u0014J\u0014\u0010+\u001a\u00020\u001f2\n\u0010 \u001a\u00060,R\u00020\u0000H\u0002J$\u0010-\u001a\u00020\u001f2\n\u0010 \u001a\u00060.R\u00020\u00002\u0006\u0010/\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u000eH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/lodz/android/pandora/photopicker/picker/pick/PhotoPickerAdapter;", "Lcom/lodz/android/pandora/widget/rv/recycler/BaseRecyclerViewAdapter;", "Lcom/lodz/android/pandora/photopicker/picker/PickerItemBean;", "context", "Landroid/content/Context;", "imgLoader", "Lcom/lodz/android/pandora/photopicker/contract/OnImgLoader;", "Lcom/lodz/android/corekt/album/PicInfo;", "isNeedCamera", "", "config", "Lcom/lodz/android/pandora/photopicker/picker/PickerUIConfig;", "(Landroid/content/Context;Lcom/lodz/android/pandora/photopicker/contract/OnImgLoader;ZLcom/lodz/android/pandora/photopicker/picker/PickerUIConfig;)V", "VIEW_TYPE_CAMERA", "", "VIEW_TYPE_ITEM", "isPdrNeedCamera", "mPdrConfig", "mPdrImgLoader", "mPdrListener", "Lcom/lodz/android/pandora/photopicker/picker/pick/PhotoPickerAdapter$Listener;", "mPdrSelectedBitmap", "Landroid/graphics/Bitmap;", "mPdrUnselectBitmap", "getItemCount", "getItemViewType", "position", "getSelectedBitmap", "color", "getUnselectBitmap", "onBind", "", "holder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "release", "setItemClick", "setItemLongClick", "setListener", "listener", "showCameraItem", "Lcom/lodz/android/pandora/photopicker/picker/pick/PhotoPickerAdapter$PickerCameraViewHolder;", "showItem", "Lcom/lodz/android/pandora/photopicker/picker/pick/PhotoPickerAdapter$PickerViewHolder;", "bean", "Listener", "PickerCameraViewHolder", "PickerViewHolder", "pandora_release"})
public final class PhotoPickerAdapter
extends BaseRecyclerViewAdapter<PickerItemBean> {
    private final int VIEW_TYPE_CAMERA;
    private final int VIEW_TYPE_ITEM;
    @Nullable
    private OnImgLoader<? super PicInfo> mPdrImgLoader;
    @Nullable
    private Listener mPdrListener;
    @NotNull
    private final Bitmap mPdrUnselectBitmap;
    @NotNull
    private final Bitmap mPdrSelectedBitmap;
    private final boolean isPdrNeedCamera;
    @NotNull
    private final PickerUIConfig mPdrConfig;

    public PhotoPickerAdapter(@NotNull Context context, @Nullable OnImgLoader<? super PicInfo> imgLoader, boolean isNeedCamera, @NotNull PickerUIConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(context);
        this.VIEW_TYPE_ITEM = 1;
        this.mPdrImgLoader = imgLoader;
        this.isPdrNeedCamera = isNeedCamera;
        this.mPdrConfig = config;
        this.mPdrUnselectBitmap = this.getUnselectBitmap(this.mPdrConfig.getSelectedBtnUnselect$pandora_release());
        this.mPdrSelectedBitmap = this.getSelectedBitmap(this.mPdrConfig.getSelectedBtnSelected$pandora_release());
    }

    public int getItemViewType(int position) {
        return this.isPdrNeedCamera && position == 0 ? this.VIEW_TYPE_CAMERA : this.VIEW_TYPE_ITEM;
    }

    @Override
    public int getItemCount() {
        return this.isPdrNeedCamera ? super.getItemCount() + 1 : super.getItemCount();
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return viewType == this.VIEW_TYPE_CAMERA ? (RecyclerView.ViewHolder)new PickerCameraViewHolder(BaseRecyclerViewAdapter.getLayoutView$default(this, parent, R.layout.pandora_item_picker_camera, false, 4, null)) : (RecyclerView.ViewHolder)new PickerViewHolder(BaseRecyclerViewAdapter.getLayoutView$default(this, parent, R.layout.pandora_item_picker, false, 4, null));
    }

    @Override
    public void onBind(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (holder instanceof PickerCameraViewHolder) {
            this.showCameraItem((PickerCameraViewHolder)holder);
            return;
        }
        PickerItemBean bean = (PickerItemBean)this.getItem(this.isPdrNeedCamera ? position - 1 : position);
        if (bean == null || !(holder instanceof PickerViewHolder)) {
            return;
        }
        this.showItem((PickerViewHolder)holder, bean, position);
    }

    private final void showCameraItem(PickerCameraViewHolder holder) {
        View view = holder.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"holder.itemView");
        this.setItemViewHeight(view, AnkoScreenKt.getScreenWidth((Context)this.getContext()) / 3);
        holder.itemView.setBackgroundColor(AnkoContextCompatKt.getColorCompat((Context)this.getContext(), (int)this.mPdrConfig.getCameraBgColor$pandora_release()));
        ImageView cameraBtn = (ImageView)holder.withView(R.id.pdr_camera_btn);
        if (this.mPdrConfig.getCameraImg$pandora_release() != 0) {
            cameraBtn.setImageResource(this.mPdrConfig.getCameraImg$pandora_release());
        }
        cameraBtn.setOnClickListener(arg_0 -> PhotoPickerAdapter.showCameraItem$lambda-0(this, arg_0));
    }

    private final void showItem(PickerViewHolder holder, PickerItemBean bean, int position) {
        Object object = holder.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"holder.itemView");
        this.setItemViewHeight((View)object, AnkoScreenKt.getScreenWidth((Context)this.getContext()) / 3);
        holder.itemView.setBackgroundColor(AnkoContextCompatKt.getColorCompat((Context)this.getContext(), (int)this.mPdrConfig.getItemBgColor$pandora_release()));
        object = this.mPdrImgLoader;
        if (object != null) {
            object.displayImg(this.getContext(), bean.getInfo(), (ImageView)holder.withView(R.id.pdr_photo_img));
        }
        object = holder.withView(R.id.pdr_select_icon_btn);
        boolean bl = false;
        boolean bl2 = false;
        ImageView $this$showItem_u24lambda_u2d2 = (ImageView)object;
        boolean bl3 = false;
        $this$showItem_u24lambda_u2d2.setImageBitmap(bean.isSelected() ? this.mPdrSelectedBitmap : this.mPdrUnselectBitmap);
        $this$showItem_u24lambda_u2d2.setOnClickListener(arg_0 -> PhotoPickerAdapter.showItem$lambda-2$lambda-1(this, bean, position, arg_0));
        Object maskView = holder.withView(R.id.pdr_mask_view);
        if (this.mPdrConfig.getMaskColor$pandora_release() != 0) {
            maskView.setBackgroundColor(AnkoContextCompatKt.getColorCompat((Context)this.getContext(), (int)this.mPdrConfig.getMaskColor$pandora_release()));
        }
        maskView.setVisibility(bean.isSelected() ? 0 : 8);
    }

    private final Bitmap getUnselectBitmap(@ColorRes int color) {
        float side = (float)AnkoScreenKt.getScreenWidth((Context)this.getContext()) / 3.0f / 4.0f;
        Bitmap bitmap = Bitmap.createBitmap((int)((int)side), (int)((int)side), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(0);
        Paint paint = new Paint();
        paint.setColor(AnkoContextCompatKt.getColorCompat((Context)this.getContext(), (int)color));
        paint.setStrokeWidth(4.0f);
        paint.setAntiAlias(true);
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawCircle(side / (float)2, side / (float)2, side / (float)2 - AnkoDimensionsKt.dp2pxRF((Context)this.getContext(), (int)4), paint);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }

    private final Bitmap getSelectedBitmap(@ColorRes int color) {
        float side = (float)AnkoScreenKt.getScreenWidth((Context)this.getContext()) / 3.0f / 4.0f;
        Bitmap bitmap = Bitmap.createBitmap((int)((int)side), (int)((int)side), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(0);
        Paint paint = new Paint();
        paint.setColor(AnkoContextCompatKt.getColorCompat((Context)this.getContext(), (int)color));
        paint.setStrokeWidth(4.0f);
        paint.setAntiAlias(true);
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawCircle(side / (float)2, side / (float)2, side / (float)2 - AnkoDimensionsKt.dp2pxRF((Context)this.getContext(), (int)4), paint);
        paint.setAntiAlias(true);
        paint.setStyle(Paint.Style.FILL);
        canvas.drawCircle(side / (float)2, side / (float)2, side / (float)2 - AnkoDimensionsKt.dp2pxRF((Context)this.getContext(), (int)10), paint);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }

    public final void release() {
        this.mPdrImgLoader = null;
    }

    @Override
    protected void setItemClick(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super.setItemClick(holder, this.isPdrNeedCamera ? position - 1 : position);
    }

    @Override
    protected void setItemLongClick(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super.setItemLongClick(holder, this.isPdrNeedCamera ? position - 1 : position);
    }

    public final void setListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.mPdrListener = listener;
    }

    private static final void showCameraItem$lambda-0(PhotoPickerAdapter this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Listener listener = this$0.mPdrListener;
        if (listener != null) {
            listener.onClickCamera();
        }
    }

    private static final void showItem$lambda-2$lambda-1(PhotoPickerAdapter this$0, PickerItemBean $bean, int $position, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$bean, (String)"$bean");
        Listener listener = this$0.mPdrListener;
        if (listener != null) {
            listener.onSelected($bean, $position);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0018\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Lcom/lodz/android/pandora/photopicker/picker/pick/PhotoPickerAdapter$Listener;", "", "onClickCamera", "", "onSelected", "bean", "Lcom/lodz/android/pandora/photopicker/picker/PickerItemBean;", "position", "", "pandora_release"})
    public static interface Listener {
        public void onSelected(@NotNull PickerItemBean var1, int var2);

        public void onClickCamera();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/lodz/android/pandora/photopicker/picker/pick/PhotoPickerAdapter$PickerCameraViewHolder;", "Lcom/lodz/android/pandora/widget/rv/recycler/DataViewHolder;", "itemView", "Landroid/view/View;", "(Lcom/lodz/android/pandora/photopicker/picker/pick/PhotoPickerAdapter;Landroid/view/View;)V", "pandora_release"})
    private final class PickerCameraViewHolder
    extends DataViewHolder {
        public PickerCameraViewHolder(View itemView) {
            Intrinsics.checkNotNullParameter((Object)((Object)PhotoPickerAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/lodz/android/pandora/photopicker/picker/pick/PhotoPickerAdapter$PickerViewHolder;", "Lcom/lodz/android/pandora/widget/rv/recycler/DataViewHolder;", "itemView", "Landroid/view/View;", "(Lcom/lodz/android/pandora/photopicker/picker/pick/PhotoPickerAdapter;Landroid/view/View;)V", "pandora_release"})
    private final class PickerViewHolder
    extends DataViewHolder {
        public PickerViewHolder(View itemView) {
            Intrinsics.checkNotNullParameter((Object)((Object)PhotoPickerAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
        }
    }
}

