/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.photopicker.preview;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.lodz.android.pandora.photopicker.contract.preview.PreviewController;
import com.lodz.android.pandora.photopicker.preview.AbsImageView;
import com.lodz.android.pandora.widget.rv.recycler.BaseRecyclerViewAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00030\u0005:\u0001\u001dB)\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u001a\u001a\u00020\u0010J$\u0010\u001b\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e0\u001cR\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/lodz/android/pandora/photopicker/preview/PicturePagerAdapter;", "V", "Landroid/view/View;", "T", "", "Lcom/lodz/android/pandora/widget/rv/recycler/BaseRecyclerViewAdapter;", "context", "Landroid/content/Context;", "view", "Lcom/lodz/android/pandora/photopicker/preview/AbsImageView;", "controller", "Lcom/lodz/android/pandora/photopicker/contract/preview/PreviewController;", "(Landroid/content/Context;Lcom/lodz/android/pandora/photopicker/preview/AbsImageView;Lcom/lodz/android/pandora/photopicker/contract/preview/PreviewController;)V", "mController", "mView", "onBind", "", "holder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "position", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onViewDetachedFromWindow", "release", "showItem", "Lcom/lodz/android/pandora/photopicker/preview/PicturePagerAdapter$DataViewHolder;", "DataViewHolder", "pandora_release"})
public final class PicturePagerAdapter<V extends View, T>
extends BaseRecyclerViewAdapter<T> {
    @NotNull
    private final AbsImageView<V, T> mView;
    @NotNull
    private PreviewController mController;

    public PicturePagerAdapter(@NotNull Context context, @NotNull AbsImageView<V, T> view, @NotNull PreviewController controller) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        super(context);
        this.mView = view;
        this.mController = controller;
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        FrameLayout frameLayout = new FrameLayout(parent.getContext());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return new DataViewHolder((ViewGroup)frameLayout);
    }

    public void onViewDetachedFromWindow(@NotNull RecyclerView.ViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super.onViewDetachedFromWindow(holder);
        if (holder instanceof DataViewHolder) {
            AbsImageView.onViewDetached$default(this.mView, ((DataViewHolder)holder).getPhotoImg(), false, 2, null);
        }
    }

    @Override
    public void onBind(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (holder instanceof DataViewHolder) {
            this.showItem((DataViewHolder)holder, position);
        }
    }

    private final void showItem(DataViewHolder holder, int position) {
        Object item = this.getItem(position);
        if (item != null) {
            this.mView.onDisplayImg(this.getContext(), item, holder.getPhotoImg());
            this.mView.onClickImpl(holder, holder.getPhotoImg(), item, position, this.mController);
            this.mView.onLongClickImpl(holder, holder.getPhotoImg(), item, position, this.mController);
        }
    }

    public final void release() {
        this.mView.onRelease();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/lodz/android/pandora/photopicker/preview/PicturePagerAdapter$DataViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/ViewGroup;", "(Lcom/lodz/android/pandora/photopicker/preview/PicturePagerAdapter;Landroid/view/ViewGroup;)V", "photoImg", "getPhotoImg", "()Landroid/view/View;", "Landroid/view/View;", "pandora_release"})
    private final class DataViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final V photoImg;

        public DataViewHolder(ViewGroup itemView) {
            Intrinsics.checkNotNullParameter((Object)((Object)PicturePagerAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super((View)itemView);
            AbsImageView absImageView = PicturePagerAdapter.this.mView;
            Context context = itemView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"itemView.context");
            this.photoImg = AbsImageView.onCreateView$default(absImageView, context, false, 2, null);
            itemView.addView(this.photoImg, -1, -1);
        }

        @NotNull
        public final V getPhotoImg() {
            return this.photoImg;
        }
    }
}

