/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.photopicker.preview;

import android.view.View;
import androidx.annotation.ColorRes;
import androidx.annotation.IntRange;
import com.lodz.android.pandora.photopicker.preview.AbsImageView;
import com.lodz.android.pandora.photopicker.preview.PreviewBean;
import com.lodz.android.pandora.photopicker.preview.PreviewManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001f\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0006\u0010\n\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u000bJ%\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\r\u00a2\u0006\u0002\u0010\u000eJ \u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0001\u0010\u0012\u001a\u00020\u0013J&\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0016J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0001\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0001\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u001a\u001a\u00020\u0013J\u001c\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0001\u0010\u001c\u001a\u00020\u0013J\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0001\u0010\u0012\u001a\u00020\u0013R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/lodz/android/pandora/photopicker/preview/PreviewBuilder;", "V", "Landroid/view/View;", "T", "", "()V", "previewBean", "Lcom/lodz/android/pandora/photopicker/preview/PreviewBean;", "build", "Lcom/lodz/android/pandora/photopicker/preview/PreviewManager;", "source", "(Ljava/lang/Object;)Lcom/lodz/android/pandora/photopicker/preview/PreviewManager;", "sourceArray", "", "([Ljava/lang/Object;)Lcom/lodz/android/pandora/photopicker/preview/PreviewManager;", "sourceList", "", "setBackgroundColor", "color", "", "setImageView", "view", "Lcom/lodz/android/pandora/photopicker/preview/AbsImageView;", "setNavigationBarColor", "setPagerTextColor", "setPagerTextSize", "sp", "setPosition", "position", "setShowPagerText", "isShow", "", "setStatusBarColor", "pandora_release"})
public final class PreviewBuilder<V extends View, T> {
    @NotNull
    private final PreviewBean<V, T> previewBean = new PreviewBean();

    @NotNull
    public final PreviewBuilder<V, T> setPosition(@IntRange(from=0L) int position) {
        this.previewBean.setShowPosition(position);
        return this;
    }

    @NotNull
    public final PreviewBuilder<V, T> setBackgroundColor(@ColorRes int color) {
        this.previewBean.setBackgroundColor(color);
        return this;
    }

    @NotNull
    public final PreviewBuilder<V, T> setStatusBarColor(@ColorRes int color) {
        this.previewBean.setStatusBarColor(color);
        return this;
    }

    @NotNull
    public final PreviewBuilder<V, T> setNavigationBarColor(@ColorRes int color) {
        this.previewBean.setNavigationBarColor(color);
        return this;
    }

    @NotNull
    public final PreviewBuilder<V, T> setPagerTextColor(@ColorRes int color) {
        this.previewBean.setPagerTextColor(color);
        return this;
    }

    @NotNull
    public final PreviewBuilder<V, T> setPagerTextSize(int sp) {
        this.previewBean.setPagerTextSize(sp);
        return this;
    }

    @NotNull
    public final PreviewBuilder<V, T> setShowPagerText(boolean isShow) {
        this.previewBean.setShowPagerText(isShow);
        return this;
    }

    @NotNull
    public final PreviewBuilder<V, T> setImageView(@NotNull AbsImageView<V, T> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        this.previewBean.setImgView(view);
        return this;
    }

    @NotNull
    public final PreviewManager<V, T> build(@NotNull T source) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Object[] objectArray = new Object[]{source};
        this.previewBean.setSourceList(CollectionsKt.arrayListOf((Object[])objectArray));
        return new PreviewManager<V, T>(this.previewBean);
    }

    @NotNull
    public final PreviewManager<V, T> build(@NotNull List<? extends T> sourceList) {
        Intrinsics.checkNotNullParameter(sourceList, (String)"sourceList");
        this.previewBean.setSourceList(sourceList);
        return new PreviewManager<V, T>(this.previewBean);
    }

    @NotNull
    public final PreviewManager<V, T> build(@NotNull T[] sourceArray) {
        Intrinsics.checkNotNullParameter(sourceArray, (String)"sourceArray");
        this.previewBean.setSourceList(ArraysKt.toList((Object[])sourceArray));
        return new PreviewManager<V, T>(this.previewBean);
    }
}

