/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.utils.progress;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.appcompat.app.AlertDialog;
import com.lodz.android.corekt.anko.AnkoContextCompatKt;
import com.lodz.android.pandora.R;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0004J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0004J\u0010\u0010\u0014\u001a\u00020\u00002\b\b\u0001\u0010\u0015\u001a\u00020\u0007J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u000bJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/lodz/android/pandora/utils/progress/ProgressDialogHelper;", "", "()V", "mCancelable", "", "mCanceledOnTouchOutside", "mIndeterminateDrawable", "", "mListener", "Landroid/content/DialogInterface$OnCancelListener;", "mMsg", "", "create", "Landroidx/appcompat/app/AlertDialog;", "context", "Landroid/content/Context;", "setCancelable", "cancelable", "setCanceledOnTouchOutside", "canceledOnTouchOutside", "setIndeterminateDrawable", "resId", "setMsg", "msg", "setOnCancelListener", "listener", "Companion", "pandora_release"})
public final class ProgressDialogHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean mCancelable = true;
    private boolean mCanceledOnTouchOutside;
    @NotNull
    private String mMsg = "";
    @Nullable
    private DialogInterface.OnCancelListener mListener;
    @DrawableRes
    private int mIndeterminateDrawable;

    private ProgressDialogHelper() {
    }

    @NotNull
    public final ProgressDialogHelper setCancelable(boolean cancelable) {
        this.mCancelable = cancelable;
        return this;
    }

    @NotNull
    public final ProgressDialogHelper setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
        this.mCanceledOnTouchOutside = canceledOnTouchOutside;
        return this;
    }

    @NotNull
    public final ProgressDialogHelper setMsg(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.mMsg = msg;
        return this;
    }

    @NotNull
    public final ProgressDialogHelper setOnCancelListener(@NotNull DialogInterface.OnCancelListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.mListener = listener;
        return this;
    }

    @NotNull
    public final ProgressDialogHelper setIndeterminateDrawable(@DrawableRes int resId) {
        this.mIndeterminateDrawable = resId;
        return this;
    }

    @SuppressLint(value={"InflateParams"})
    @NotNull
    public final AlertDialog create(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        View view = LayoutInflater.from((Context)context).inflate(R.layout.pandora_view_progress, null);
        Object object = new AlertDialog.Builder(context, R.style.ProgressStyle).setView(view).create();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Builder(context, R.style.ProgressStyle)\n                .setView(view)\n                .create()");
        AlertDialog progressDialog = object;
        object = this.mMsg;
        boolean bl = false;
        if (object.length() > 0) {
            TextView tv = (TextView)view.findViewById(R.id.pdr_msg);
            tv.setVisibility(0);
            tv.setText((CharSequence)this.mMsg);
        }
        if (this.mIndeterminateDrawable != 0) {
            ProgressBar pb = (ProgressBar)view.findViewById(R.id.pdr_progress_bar);
            pb.setIndeterminateDrawable(AnkoContextCompatKt.getDrawableCompat((Context)context, (int)this.mIndeterminateDrawable));
        }
        progressDialog.setCanceledOnTouchOutside(this.mCanceledOnTouchOutside);
        progressDialog.setCancelable(this.mCancelable);
        if (this.mListener != null) {
            progressDialog.setOnCancelListener(this.mListener);
        }
        if ((object = progressDialog.getWindow()) != null) {
            object.setGravity(17);
        }
        return progressDialog;
    }

    @JvmStatic
    @NotNull
    public static final ProgressDialogHelper get() {
        return Companion.get();
    }

    public /* synthetic */ ProgressDialogHelper(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/lodz/android/pandora/utils/progress/ProgressDialogHelper$Companion;", "", "()V", "get", "Lcom/lodz/android/pandora/utils/progress/ProgressDialogHelper;", "pandora_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ProgressDialogHelper get() {
            return new ProgressDialogHelper(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

