/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.utils.transition;

import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.view.View;
import androidx.core.app.ActivityOptionsCompat;
import androidx.core.util.Pair;
import androidx.core.view.ViewCompat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J(\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J2\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u00100\u000fH\u0007J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\rH\u0007\u00a8\u0006\u0018"}, d2={"Lcom/lodz/android/pandora/utils/transition/TransitionHelper;", "", "()V", "finish", "", "activity", "Landroid/app/Activity;", "jumpTransition", "intent", "Landroid/content/Intent;", "sharedElement", "Landroid/view/View;", "sharedElementName", "", "list", "", "Landroidx/core/util/Pair;", "setEnterTransitionDuration", "duration", "", "setReturnTransitionDuration", "setTransition", "view", "shareElementName", "pandora_release"})
public final class TransitionHelper {
    @NotNull
    public static final TransitionHelper INSTANCE = new TransitionHelper();

    private TransitionHelper() {
    }

    @JvmStatic
    public static final void jumpTransition(@NotNull Activity activity, @NotNull Intent intent, @NotNull List<? extends Pair<View, String>> list) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        if (list.isEmpty() || Build.VERSION.SDK_INT < 21) {
            activity.startActivity(intent);
        } else {
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
            if (pairArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Pair[] pairArray2 = pairArray;
            activity.startActivity(intent, ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)activity, (Pair[])Arrays.copyOf(pairArray2, pairArray2.length)).toBundle());
        }
    }

    @JvmStatic
    public static final void jumpTransition(@NotNull Activity activity, @NotNull Intent intent, @NotNull View sharedElement, @NotNull String sharedElementName) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)sharedElement, (String)"sharedElement");
        Intrinsics.checkNotNullParameter((Object)sharedElementName, (String)"sharedElementName");
        if (Build.VERSION.SDK_INT < 21) {
            activity.startActivity(intent);
        } else {
            activity.startActivity(intent, ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)activity, (View)sharedElement, (String)sharedElementName).toBundle());
        }
    }

    @JvmStatic
    public static final void finish(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 21) {
            activity.finishAfterTransition();
        } else {
            activity.finish();
        }
    }

    @JvmStatic
    public static final void setTransition(@NotNull View view, @NotNull String shareElementName) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)shareElementName, (String)"shareElementName");
        ViewCompat.setTransitionName((View)view, (String)shareElementName);
    }

    @JvmStatic
    public static final void setEnterTransitionDuration(@NotNull Activity activity, long duration) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().getEnterTransition().setDuration(duration);
        }
    }

    @JvmStatic
    public static final void setReturnTransitionDuration(@NotNull Activity activity, long duration) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().getReturnTransition().setDuration(duration);
        }
    }
}

