/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.base;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.StringRes;
import com.lodz.android.corekt.anko.AnkoContextCompatKt;
import com.lodz.android.corekt.anko.AnkoDimensionsKt;
import com.lodz.android.corekt.anko.AnkoViewBinderKt;
import com.lodz.android.pandora.R;
import com.lodz.android.pandora.base.application.BaseApplication;
import com.lodz.android.pandora.base.application.config.LoadingLayoutConfig;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\u0006\u0010\u001c\u001a\u00020\u000eJ\u0012\u0010\u001d\u001a\u00020\u001a2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\tJ\u000e\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u000eJ\u0010\u0010%\u001a\u00020\u001a2\b\b\u0001\u0010&\u001a\u00020\tJ\u000e\u0010%\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+J\u0010\u0010)\u001a\u00020\u001a2\b\b\u0001\u0010,\u001a\u00020\tJ\u0010\u0010-\u001a\u00020\u001a2\b\b\u0001\u0010.\u001a\u00020\tJ\u000e\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u000201R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0015\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0014\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00062"}, d2={"Lcom/lodz/android/pandora/widget/base/LoadingLayout;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mPdrConfig", "Lcom/lodz/android/pandora/base/application/config/LoadingLayoutConfig;", "mPdrLoadingProgressBar", "Landroid/widget/ProgressBar;", "mPdrLoadingTipsTv", "Landroid/widget/TextView;", "getMPdrLoadingTipsTv", "()Landroid/widget/TextView;", "mPdrLoadingTipsTv$delegate", "Lkotlin/Lazy;", "mPdrRootView", "getMPdrRootView", "()Landroid/widget/LinearLayout;", "mPdrRootView$delegate", "configLayout", "", "findViews", "getProgressBar", "init", "needTips", "isNeed", "", "setLayoutOrientation", "orientation", "setProgressBar", "progressBar", "setTips", "strResId", "str", "", "setTipsTextColor", "colorStateList", "Landroid/content/res/ColorStateList;", "colorRes", "setTipsTextColorInt", "color", "setTipsTextSize", "sp", "", "pandora_release"})
public final class LoadingLayout
extends LinearLayout {
    @NotNull
    private LoadingLayoutConfig mPdrConfig = new LoadingLayoutConfig();
    @NotNull
    private final Lazy mPdrRootView$delegate = AnkoViewBinderKt.bindView((View)((View)this), (int)R.id.pdr_root_view);
    @NotNull
    private final Lazy mPdrLoadingTipsTv$delegate = AnkoViewBinderKt.bindView((View)((View)this), (int)R.id.pdr_loading_tips_tv);
    private ProgressBar mPdrLoadingProgressBar;

    private final LinearLayout getMPdrRootView() {
        Lazy lazy = this.mPdrRootView$delegate;
        boolean bl = false;
        return (LinearLayout)lazy.getValue();
    }

    private final TextView getMPdrLoadingTipsTv() {
        Lazy lazy = this.mPdrLoadingTipsTv$delegate;
        boolean bl = false;
        return (TextView)lazy.getValue();
    }

    public LoadingLayout(@Nullable Context context) {
        super(context);
        this.init(null);
    }

    public LoadingLayout(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public LoadingLayout(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private final void init(AttributeSet attrs) {
        BaseApplication app = BaseApplication.Companion.get();
        if (app != null) {
            this.mPdrConfig = app.getBaseLayoutConfig().getLoadingLayoutConfig();
        }
        this.findViews();
        this.configLayout(attrs);
    }

    private final void findViews() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pandora_view_loading, (ViewGroup)this);
        View view = this.findViewById(R.id.pdr_loading_progressbar);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.pdr_loading_progressbar)");
        this.mPdrLoadingProgressBar = (ProgressBar)view;
    }

    private final void configLayout(AttributeSet attrs) {
        int pbHeight;
        Drawable drawable2;
        int n;
        int tipsSize;
        ColorStateList tipsColor;
        String string2;
        TypedArray typedArray;
        TypedArray typedArray2 = null;
        if (attrs != null) {
            typedArray2 = this.getContext().obtainStyledAttributes(attrs, R.styleable.LoadingLayout);
        }
        Integer n2 = (typedArray = typedArray2) == null ? null : Integer.valueOf(typedArray.getInt(R.styleable.LoadingLayout_contentOrientation, this.mPdrConfig.getOrientation()));
        int orientation = n2 == null ? this.mPdrConfig.getOrientation() : n2.intValue();
        this.setLayoutOrientation(orientation);
        Object object = typedArray2;
        typedArray = object == null ? null : Boolean.valueOf(object.getBoolean(R.styleable.LoadingLayout_isNeedTips, this.mPdrConfig.isNeedTips()));
        boolean isNeedTips = typedArray == null ? this.mPdrConfig.isNeedTips() : typedArray.booleanValue();
        this.needTips(isNeedTips);
        CharSequence charSequence = this.mPdrConfig.getTips();
        boolean bl = false;
        object = charSequence.length() == 0 ? this.getContext().getString(R.string.pandora_loading) : this.mPdrConfig.getTips();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"if (mPdrConfig.tips.isEmpty()) context.getString(R.string.pandora_loading) else mPdrConfig.tips");
        Object defaultTips = object;
        charSequence = typedArray2;
        Object attrsTips = charSequence == null ? defaultTips : ((string2 = charSequence.getString(R.styleable.LoadingLayout_tips)) == null ? defaultTips : string2);
        charSequence = (CharSequence)attrsTips;
        bl = false;
        this.setTips((String)(charSequence.length() == 0 ? defaultTips : attrsTips));
        TypedArray typedArray3 = typedArray2;
        ColorStateList colorStateList = tipsColor = typedArray3 == null ? null : typedArray3.getColorStateList(R.styleable.LoadingLayout_tipsColor);
        if (tipsColor != null) {
            this.setTipsTextColor(tipsColor);
        } else if (this.mPdrConfig.getTextColor() != 0) {
            this.setTipsTextColor(this.mPdrConfig.getTextColor());
        }
        TypedArray typedArray4 = typedArray2;
        int n3 = tipsSize = typedArray4 == null ? 0 : (n = typedArray4.getDimensionPixelSize(R.styleable.LoadingLayout_tipsSize, 0));
        if (tipsSize != 0) {
            this.setTipsTextSize(AnkoDimensionsKt.px2spRF((View)((View)this), (int)tipsSize));
        } else if (this.mPdrConfig.getTextSize() != 0) {
            this.setTipsTextSize(this.mPdrConfig.getTextSize());
        }
        TypedArray typedArray5 = typedArray2;
        Boolean bl2 = typedArray5 == null ? null : Boolean.valueOf(typedArray5.getBoolean(R.styleable.LoadingLayout_isIndeterminate, this.mPdrConfig.isIndeterminate()));
        boolean isIndeterminate = bl2 == null ? this.mPdrConfig.isIndeterminate() : bl2.booleanValue();
        bl2 = this.mPdrLoadingProgressBar;
        if (bl2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrLoadingProgressBar");
            throw null;
        }
        bl2.setIndeterminate(isIndeterminate);
        TypedArray typedArray6 = typedArray2;
        typedArray5 = typedArray6 == null ? null : Boolean.valueOf(typedArray6.getBoolean(R.styleable.LoadingLayout_useSysDefDrawable, this.mPdrConfig.getUseSysDefDrawable()));
        boolean useSysDefDrawable = typedArray5 == null ? this.mPdrConfig.getUseSysDefDrawable() : typedArray5.booleanValue();
        typedArray6 = typedArray2;
        Drawable drawable3 = drawable2 = typedArray6 == null ? null : typedArray6.getDrawable(R.styleable.LoadingLayout_indeterminateDrawable);
        if (drawable2 != null) {
            typedArray6 = this.mPdrLoadingProgressBar;
            if (typedArray6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrLoadingProgressBar");
                throw null;
            }
            typedArray6.setIndeterminateDrawable(drawable2);
        } else if (this.mPdrConfig.getIndeterminateDrawable() != 0) {
            typedArray6 = this.mPdrLoadingProgressBar;
            if (typedArray6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrLoadingProgressBar");
                throw null;
            }
            typedArray6.setIndeterminateDrawable(AnkoContextCompatKt.getDrawableCompat((View)((View)this), (int)this.mPdrConfig.getIndeterminateDrawable()));
        } else if (!useSysDefDrawable) {
            typedArray6 = this.mPdrLoadingProgressBar;
            if (typedArray6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrLoadingProgressBar");
                throw null;
            }
            typedArray6.setIndeterminateDrawable(AnkoContextCompatKt.getDrawableCompat((View)((View)this), (int)R.drawable.pandora_anims_loading));
        }
        ProgressBar progressBar = this.mPdrLoadingProgressBar;
        if (progressBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrLoadingProgressBar");
            throw null;
        }
        ViewGroup.LayoutParams layoutParams = progressBar.getLayoutParams();
        TypedArray typedArray7 = typedArray2;
        Integer n4 = typedArray7 == null ? null : Integer.valueOf(typedArray7.getDimensionPixelSize(R.styleable.LoadingLayout_pbWidth, this.mPdrConfig.getPbWidthPx()));
        int pbWidth = n4 == null ? this.mPdrConfig.getPbWidthPx() : n4.intValue();
        TypedArray typedArray8 = typedArray2;
        typedArray7 = typedArray8 == null ? null : Integer.valueOf(typedArray8.getDimensionPixelSize(R.styleable.LoadingLayout_pbHeight, this.mPdrConfig.getPbHeightPx()));
        int n5 = pbHeight = typedArray7 == null ? this.mPdrConfig.getPbHeightPx() : typedArray7.intValue();
        if (pbWidth == 0 && !useSysDefDrawable) {
            pbWidth = AnkoDimensionsKt.dp2px((View)((View)this), (int)90);
        }
        if (pbHeight == 0 && !useSysDefDrawable) {
            pbHeight = AnkoDimensionsKt.dp2px((View)((View)this), (int)90);
        }
        if (pbWidth != 0) {
            layoutParams.width = pbWidth;
        }
        if (pbHeight != 0) {
            layoutParams.height = pbHeight;
        }
        Drawable drawableBackground = (typedArray8 = typedArray2) == null ? null : typedArray8.getDrawable(R.styleable.LoadingLayout_contentBackground);
        if (drawableBackground != null) {
            this.setBackground(drawableBackground);
        } else if (this.mPdrConfig.getBackgroundColor() != 0) {
            this.setBackgroundColor(AnkoContextCompatKt.getColorCompat((View)((View)this), (int)this.mPdrConfig.getBackgroundColor()));
        } else {
            this.setBackgroundColor(AnkoContextCompatKt.getColorCompat((View)((View)this), (int)17170443));
        }
        typedArray8 = typedArray2;
        if (typedArray8 != null) {
            typedArray8.recycle();
        }
    }

    public final void needTips(boolean isNeed) {
        this.getMPdrLoadingTipsTv().setVisibility(isNeed ? 0 : 8);
    }

    public final void setTips(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.getMPdrLoadingTipsTv().setText((CharSequence)str);
    }

    public final void setTips(@StringRes int strResId) {
        this.getMPdrLoadingTipsTv().setText((CharSequence)this.getContext().getString(strResId));
    }

    public final void setTipsTextColor(@ColorRes int colorRes) {
        this.getMPdrLoadingTipsTv().setTextColor(AnkoContextCompatKt.getColorCompat((View)((View)this), (int)colorRes));
    }

    public final void setTipsTextColorInt(@ColorInt int color) {
        this.getMPdrLoadingTipsTv().setTextColor(color);
    }

    public final void setTipsTextColor(@NotNull ColorStateList colorStateList) {
        Intrinsics.checkNotNullParameter((Object)colorStateList, (String)"colorStateList");
        this.getMPdrLoadingTipsTv().setTextColor(colorStateList);
    }

    public final void setTipsTextSize(float sp) {
        this.getMPdrLoadingTipsTv().setTextSize(2, sp);
    }

    public final void setProgressBar(@NotNull ProgressBar progressBar) {
        Intrinsics.checkNotNullParameter((Object)progressBar, (String)"progressBar");
        this.mPdrLoadingProgressBar = progressBar;
    }

    @NotNull
    public final ProgressBar getProgressBar() {
        ProgressBar progressBar = this.mPdrLoadingProgressBar;
        if (progressBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrLoadingProgressBar");
            throw null;
        }
        return progressBar;
    }

    public final void setLayoutOrientation(int orientation) {
        switch (orientation) {
            case 0: 
            case 1: {
                this.getMPdrRootView().setOrientation(orientation);
            }
        }
    }

    public void _$_clearFindViewByIdCache() {
    }
}

