/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.base;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import com.lodz.android.corekt.anko.AnkoContextCompatKt;
import com.lodz.android.corekt.anko.AnkoDimensionsKt;
import com.lodz.android.corekt.anko.AnkoViewBinderKt;
import com.lodz.android.pandora.R;
import com.lodz.android.pandora.base.application.BaseApplication;
import com.lodz.android.pandora.base.application.config.NoDataLayoutConfig;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010\u001e\u001a\u00020\u001d2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!J\u000e\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%J\u0010\u0010#\u001a\u00020\u001d2\b\b\u0001\u0010&\u001a\u00020\tJ\u000e\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\tJ\u0010\u0010)\u001a\u00020\u001d2\b\b\u0001\u0010*\u001a\u00020\tJ\u000e\u0010)\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020/J\u0010\u0010-\u001a\u00020\u001d2\b\b\u0001\u00100\u001a\u00020\tJ\u0010\u00101\u001a\u00020\u001d2\b\b\u0001\u00102\u001a\u00020\tJ\u000e\u00103\u001a\u00020\u001d2\u0006\u00104\u001a\u000205R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0018\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0012\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00066"}, d2={"Lcom/lodz/android/pandora/widget/base/NoDataLayout;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mPdrConfig", "Lcom/lodz/android/pandora/base/application/config/NoDataLayoutConfig;", "mPdrNoDataImg", "Landroid/widget/ImageView;", "getMPdrNoDataImg", "()Landroid/widget/ImageView;", "mPdrNoDataImg$delegate", "Lkotlin/Lazy;", "mPdrNoDataTv", "Landroid/widget/TextView;", "getMPdrNoDataTv", "()Landroid/widget/TextView;", "mPdrNoDataTv$delegate", "mPdrRootView", "getMPdrRootView", "()Landroid/widget/LinearLayout;", "mPdrRootView$delegate", "configLayout", "", "init", "needImg", "isNeed", "", "needTips", "setImg", "drawable", "Landroid/graphics/drawable/Drawable;", "drawableResId", "setLayoutOrientation", "orientation", "setTips", "strResId", "str", "", "setTipsTextColor", "colorStateList", "Landroid/content/res/ColorStateList;", "colorRes", "setTipsTextColorInt", "color", "setTipsTextSize", "sp", "", "pandora_release"})
public final class NoDataLayout
extends LinearLayout {
    @NotNull
    private NoDataLayoutConfig mPdrConfig = new NoDataLayoutConfig();
    @NotNull
    private final Lazy mPdrRootView$delegate = AnkoViewBinderKt.bindView((View)((View)this), (int)R.id.pdr_root_view);
    @NotNull
    private final Lazy mPdrNoDataImg$delegate = AnkoViewBinderKt.bindView((View)((View)this), (int)R.id.pdr_no_data_img);
    @NotNull
    private final Lazy mPdrNoDataTv$delegate = AnkoViewBinderKt.bindView((View)((View)this), (int)R.id.pdr_no_data_tv);

    private final LinearLayout getMPdrRootView() {
        Lazy lazy = this.mPdrRootView$delegate;
        boolean bl = false;
        return (LinearLayout)lazy.getValue();
    }

    private final ImageView getMPdrNoDataImg() {
        Lazy lazy = this.mPdrNoDataImg$delegate;
        boolean bl = false;
        return (ImageView)lazy.getValue();
    }

    private final TextView getMPdrNoDataTv() {
        Lazy lazy = this.mPdrNoDataTv$delegate;
        boolean bl = false;
        return (TextView)lazy.getValue();
    }

    public NoDataLayout(@Nullable Context context) {
        super(context);
        this.init(null);
    }

    public NoDataLayout(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public NoDataLayout(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private final void init(AttributeSet attrs) {
        BaseApplication app = BaseApplication.Companion.get();
        if (app != null) {
            this.mPdrConfig = app.getBaseLayoutConfig().getNoDataLayoutConfig();
        }
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pandora_view_no_data, (ViewGroup)this);
        this.configLayout(attrs);
    }

    private final void configLayout(AttributeSet attrs) {
        int n;
        int tipsSize;
        ColorStateList tipsColor;
        String string2;
        TypedArray typedArray;
        TypedArray typedArray2 = null;
        if (attrs != null) {
            typedArray2 = this.getContext().obtainStyledAttributes(attrs, R.styleable.NoDataLayout);
        }
        Integer n2 = (typedArray = typedArray2) == null ? null : Integer.valueOf(typedArray.getInt(R.styleable.NoDataLayout_contentOrientation, this.mPdrConfig.getOrientation()));
        int orientation = n2 == null ? this.mPdrConfig.getOrientation() : n2.intValue();
        this.setLayoutOrientation(orientation);
        TypedArray typedArray3 = typedArray2;
        typedArray = typedArray3 == null ? null : Boolean.valueOf(typedArray3.getBoolean(R.styleable.NoDataLayout_isNeedTips, this.mPdrConfig.isNeedTips()));
        boolean isNeedTips = typedArray == null ? this.mPdrConfig.isNeedTips() : typedArray.booleanValue();
        this.needTips(isNeedTips);
        TypedArray typedArray4 = typedArray2;
        typedArray3 = typedArray4 == null ? null : Boolean.valueOf(typedArray4.getBoolean(R.styleable.NoDataLayout_isNeedImg, this.mPdrConfig.isNeedImg()));
        boolean isNeedImg = typedArray3 == null ? this.mPdrConfig.isNeedImg() : typedArray3.booleanValue();
        this.needImg(isNeedImg);
        typedArray4 = typedArray2;
        Drawable src = typedArray4 == null ? null : typedArray4.getDrawable(R.styleable.NoDataLayout_src);
        if (src != null) {
            this.setImg(src);
        } else if (this.mPdrConfig.getDrawableResId() != 0) {
            this.setImg(this.mPdrConfig.getDrawableResId());
        } else {
            this.setImg(R.drawable.pandora_ic_no_data);
        }
        CharSequence charSequence = this.mPdrConfig.getTips();
        boolean bl = false;
        String string3 = charSequence.length() == 0 ? this.getContext().getString(R.string.pandora_no_data) : this.mPdrConfig.getTips();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"if (mPdrConfig.tips.isEmpty()) context.getString(R.string.pandora_no_data) else mPdrConfig.tips");
        String defaultTips = string3;
        charSequence = typedArray2;
        String attrsTips = charSequence == null ? defaultTips : ((string2 = charSequence.getString(R.styleable.NoDataLayout_tips)) == null ? defaultTips : string2);
        charSequence = attrsTips;
        bl = false;
        this.setTips(charSequence.length() == 0 ? defaultTips : attrsTips);
        TypedArray typedArray5 = typedArray2;
        ColorStateList colorStateList = tipsColor = typedArray5 == null ? null : typedArray5.getColorStateList(R.styleable.NoDataLayout_tipsColor);
        if (tipsColor != null) {
            this.setTipsTextColor(tipsColor);
        } else if (this.mPdrConfig.getTextColor() != 0) {
            this.setTipsTextColor(this.mPdrConfig.getTextColor());
        }
        TypedArray typedArray6 = typedArray2;
        int n3 = tipsSize = typedArray6 == null ? 0 : (n = typedArray6.getDimensionPixelSize(R.styleable.NoDataLayout_tipsSize, 0));
        if (tipsSize != 0) {
            this.setTipsTextSize(AnkoDimensionsKt.px2spRF((View)((View)this), (int)tipsSize));
        } else if (this.mPdrConfig.getTextSize() != 0) {
            this.setTipsTextSize(this.mPdrConfig.getTextSize());
        }
        TypedArray typedArray7 = typedArray2;
        Drawable drawableBackground = typedArray7 == null ? null : typedArray7.getDrawable(R.styleable.NoDataLayout_contentBackground);
        if (drawableBackground != null) {
            this.setBackground(drawableBackground);
        } else if (this.mPdrConfig.getBackgroundColor() != 0) {
            this.setBackgroundColor(AnkoContextCompatKt.getColorCompat((View)((View)this), (int)this.mPdrConfig.getBackgroundColor()));
        } else {
            this.setBackgroundColor(AnkoContextCompatKt.getColorCompat((View)((View)this), (int)17170443));
        }
        typedArray7 = typedArray2;
        if (typedArray7 != null) {
            typedArray7.recycle();
        }
    }

    public final void needImg(boolean isNeed) {
        this.getMPdrNoDataImg().setVisibility(isNeed ? 0 : 8);
    }

    public final void needTips(boolean isNeed) {
        this.getMPdrNoDataTv().setVisibility(isNeed ? 0 : 8);
    }

    public final void setImg(@DrawableRes int drawableResId) {
        this.getMPdrNoDataImg().setImageResource(drawableResId);
    }

    public final void setImg(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        this.getMPdrNoDataImg().setImageDrawable(drawable2);
    }

    public final void setTips(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.getMPdrNoDataTv().setText((CharSequence)str);
    }

    public final void setTips(@StringRes int strResId) {
        this.getMPdrNoDataTv().setText((CharSequence)this.getContext().getString(strResId));
    }

    public final void setTipsTextColor(@ColorRes int colorRes) {
        this.getMPdrNoDataTv().setTextColor(AnkoContextCompatKt.getColorCompat((View)((View)this), (int)colorRes));
    }

    public final void setTipsTextColorInt(@ColorInt int color) {
        this.getMPdrNoDataTv().setTextColor(color);
    }

    public final void setTipsTextColor(@NotNull ColorStateList colorStateList) {
        Intrinsics.checkNotNullParameter((Object)colorStateList, (String)"colorStateList");
        this.getMPdrNoDataTv().setTextColor(colorStateList);
    }

    public final void setTipsTextSize(float sp) {
        this.getMPdrNoDataTv().setTextSize(2, sp);
    }

    public final void setLayoutOrientation(int orientation) {
        switch (orientation) {
            case 0: 
            case 1: {
                this.getMPdrRootView().setOrientation(orientation);
            }
        }
    }

    public void _$_clearFindViewByIdCache() {
    }
}

