/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.bottomsheets.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.Window;
import androidx.annotation.FloatRange;
import androidx.annotation.LayoutRes;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.lodz.android.corekt.anko.AnkoScreenKt;
import com.lodz.android.corekt.utils.ReflectUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u0006H\u0014J\u0012\u0010\u0011\u001a\u00020\u000e2\b\b\u0001\u0010\u0012\u001a\u00020\u0006H\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0014J\b\u0010\u0014\u001a\u00020\u000eH\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0004J\b\u0010\u0017\u001a\u00020\u0006H%J\b\u0010\u0018\u001a\u00020\u000eH\u0014J\u0014\u0010\u0019\u001a\u00020\u000e2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH$J\u0012\u0010\u001c\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0004J\u0012\u0010\u001f\u001a\u00020\u000e2\b\b\u0001\u0010 \u001a\u00020!H\u0004J\b\u0010\"\u001a\u00020\u000eH\u0014J\b\u0010#\u001a\u00020\u000eH\u0014\u00a8\u0006$"}, d2={"Lcom/lodz/android/pandora/widget/bottomsheets/dialog/BaseBottomSheetDialog;", "Lcom/google/android/material/bottomsheet/BottomSheetDialog;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "theme", "", "(Landroid/content/Context;I)V", "cancelable", "", "cancelListener", "Landroid/content/DialogInterface$OnCancelListener;", "(Landroid/content/Context;ZLandroid/content/DialogInterface$OnCancelListener;)V", "configBehavior", "", "configStatusBar", "configTopOffsetPx", "createContentView", "layoutId", "endCreate", "findViews", "getDialogInterface", "Landroid/content/DialogInterface;", "getLayoutId", "initData", "onBehaviorInit", "behavior", "Lcom/google/android/material/bottomsheet/BottomSheetBehavior;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "setDim", "value", "", "setListeners", "startCreate", "pandora_release"})
public abstract class BaseBottomSheetDialog
extends BottomSheetDialog {
    public BaseBottomSheetDialog(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    public BaseBottomSheetDialog(@NotNull Context context, int theme) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, theme);
    }

    public BaseBottomSheetDialog(@NotNull Context context, boolean cancelable, @Nullable DialogInterface.OnCancelListener cancelListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, cancelable, cancelListener);
    }

    protected final void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.startCreate();
        this.createContentView(this.getLayoutId());
        this.findViews();
        this.setListeners();
        this.initData();
        this.endCreate();
        this.configStatusBar();
        this.configBehavior();
    }

    protected void startCreate() {
    }

    private final void createContentView(@LayoutRes int layoutId) {
        this.setContentView(layoutId);
    }

    @LayoutRes
    protected abstract int getLayoutId();

    protected void findViews() {
    }

    protected void setListeners() {
    }

    protected void initData() {
    }

    protected void endCreate() {
    }

    protected abstract void onBehaviorInit(@NotNull BottomSheetBehavior<?> var1);

    @NotNull
    protected final DialogInterface getDialogInterface() {
        return (DialogInterface)this;
    }

    protected final void setDim(@FloatRange(from=0.0, to=1.0) float value) {
        Window window = this.getWindow();
        if (window != null) {
            window.setDimAmount(value);
        }
    }

    private final void configStatusBar() {
        Window window;
        Window window2 = this.getWindow();
        if (window2 == null) {
            return;
        }
        Window wd = window = window2;
        wd.setGravity(81);
        window2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)window2, (String)"context");
        int realScreenHeight = AnkoScreenKt.getRealScreenHeight((Context)window2, (Window)wd);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        int screenHeight = AnkoScreenKt.getScreenHeight((Context)context);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        int statusBarHeight = AnkoScreenKt.getStatusBarHeight((Context)context2);
        Context context3 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
        int navigationBarHeight = AnkoScreenKt.getNavigationBarHeight((Context)context3);
        int dialogHeight = realScreenHeight - statusBarHeight - this.configTopOffsetPx();
        wd.setLayout(-1, dialogHeight == 0 ? -1 : dialogHeight);
    }

    private final void configBehavior() {
        Class clazz = ReflectUtils.getClassForName((String)"com.google.android.material.bottomsheet.BottomSheetDialog");
        if (clazz == null) {
            return;
        }
        Class cls = clazz;
        Object behavior = ReflectUtils.getFieldValue((Class)cls, (Object)((Object)this), (String)"behavior");
        if (behavior != null && behavior instanceof BottomSheetBehavior) {
            this.onBehaviorInit((BottomSheetBehavior)behavior);
        }
    }

    protected int configTopOffsetPx() {
        return 0;
    }
}

