/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.camera;

import android.app.Activity;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.hardware.Camera;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.widget.Toast;
import com.lodz.android.corekt.log.PrintLog;
import com.lodz.android.pandora.widget.camera.OnCameraListener;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010:\u001a\u00060#R\u00020\u000f2\n\u0010;\u001a\u00060#R\u00020\u000fH\u0014J\u0006\u0010<\u001a\u00020=J\u0006\u0010>\u001a\u00020?J0\u0010@\u001a\b\u0018\u00010AR\u00020\u000f2\u0006\u0010B\u001a\u00020\u00072\u0006\u0010C\u001a\u00020\u00072\u0010\u0010D\u001a\f\u0012\b\u0012\u00060AR\u00020\u000f0EH\u0002J\b\u0010F\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010G\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010H\u001a\u00020\u0007J\u0006\u0010I\u001a\u00020\u0007J\b\u0010J\u001a\u00020?H\u0002J\u0010\u0010K\u001a\u00020=2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010L\u001a\u00020=2\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010O\u001a\u00020=2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0006\u0010P\u001a\u00020?J\u000e\u0010Q\u001a\u00020?2\u0006\u0010R\u001a\u00020\u001dJ\b\u0010S\u001a\u00020?H\u0002J\u0006\u0010T\u001a\u00020?J\u0006\u0010U\u001a\u00020?J\u0010\u0010V\u001a\u00020?2\u0006\u0010W\u001a\u00020NH\u0002J+\u0010X\u001a\u0012\u0012\u0004\u0012\u00020Z0Yj\b\u0012\u0004\u0012\u00020Z`[2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020^0]H\u0002\u00a2\u0006\u0002\u0010_R\u001a\u0010\t\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001e\u0010\"\u001a\u00060#R\u00020\u000fX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\"\u0010(\u001a\n **\u0004\u0018\u00010)0)X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0016\"\u0004\b6\u0010\u0018R\u001a\u00107\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u0016\"\u0004\b9\u0010\u0018\u00a8\u0006`"}, d2={"Lcom/lodz/android/pandora/widget/camera/CameraHelper;", "", "activity", "Landroid/app/Activity;", "surfaceView", "Landroid/view/SurfaceView;", "cameraFacing", "", "(Landroid/app/Activity;Landroid/view/SurfaceView;I)V", "mActivity", "getMActivity", "()Landroid/app/Activity;", "setMActivity", "(Landroid/app/Activity;)V", "mCamera", "Landroid/hardware/Camera;", "getMCamera", "()Landroid/hardware/Camera;", "setMCamera", "(Landroid/hardware/Camera;)V", "mCameraFacing", "getMCameraFacing", "()I", "setMCameraFacing", "(I)V", "mDisplayOrientation", "getMDisplayOrientation", "setMDisplayOrientation", "mListener", "Lcom/lodz/android/pandora/widget/camera/OnCameraListener;", "getMListener", "()Lcom/lodz/android/pandora/widget/camera/OnCameraListener;", "setMListener", "(Lcom/lodz/android/pandora/widget/camera/OnCameraListener;)V", "mParameters", "Landroid/hardware/Camera$Parameters;", "getMParameters", "()Landroid/hardware/Camera$Parameters;", "setMParameters", "(Landroid/hardware/Camera$Parameters;)V", "mSurfaceHolder", "Landroid/view/SurfaceHolder;", "kotlin.jvm.PlatformType", "getMSurfaceHolder", "()Landroid/view/SurfaceHolder;", "setMSurfaceHolder", "(Landroid/view/SurfaceHolder;)V", "mSurfaceView", "getMSurfaceView", "()Landroid/view/SurfaceView;", "setMSurfaceView", "(Landroid/view/SurfaceView;)V", "picHeight", "getPicHeight", "setPicHeight", "picWidth", "getPicWidth", "setPicWidth", "configParameters", "parameters", "controlFlash", "", "exchangeCamera", "", "getBestSize", "Landroid/hardware/Camera$Size;", "width", "height", "sizeList", "", "getCamera", "getCameraDisplayOrientation", "getCameraFacing", "getDisplayOrientation", "initParameters", "isSupportCameraFacing", "isSupportFocus", "focusMode", "", "openCamera", "releaseCamera", "setOnCameraListener", "listener", "startFaceDetect", "startPreview", "takePic", "toast", "msg", "transForm", "Ljava/util/ArrayList;", "Landroid/graphics/RectF;", "Lkotlin/collections/ArrayList;", "faces", "", "Landroid/hardware/Camera$Face;", "([Landroid/hardware/Camera$Face;)Ljava/util/ArrayList;", "pandora_release"})
public class CameraHelper {
    @Nullable
    private Camera mCamera;
    protected Camera.Parameters mParameters;
    @NotNull
    private SurfaceView mSurfaceView;
    private SurfaceHolder mSurfaceHolder;
    @NotNull
    private Activity mActivity;
    @Nullable
    private OnCameraListener mListener;
    private int mCameraFacing;
    private int mDisplayOrientation;
    private int picWidth;
    private int picHeight;

    @JvmOverloads
    public CameraHelper(@NotNull Activity activity, @NotNull SurfaceView surfaceView, int cameraFacing) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"surfaceView");
        this.mSurfaceView = surfaceView;
        this.mSurfaceHolder = this.mSurfaceView.getHolder();
        this.mActivity = activity;
        this.mCameraFacing = cameraFacing;
        this.picWidth = 2160;
        this.picHeight = 3840;
        this.mSurfaceHolder.addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(@NotNull SurfaceHolder holder) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                if (this.getMCamera() == null) {
                    this.openCamera(this.getMCameraFacing());
                }
                this.startPreview();
            }

            public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            }

            public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                this.releaseCamera();
            }
        });
    }

    public /* synthetic */ CameraHelper(Activity activity, SurfaceView surfaceView, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(activity, surfaceView, n);
    }

    @Nullable
    protected final Camera getMCamera() {
        return this.mCamera;
    }

    protected final void setMCamera(@Nullable Camera camera) {
        this.mCamera = camera;
    }

    @NotNull
    protected final Camera.Parameters getMParameters() {
        Camera.Parameters parameters = this.mParameters;
        if (parameters != null) {
            return parameters;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mParameters");
        throw null;
    }

    protected final void setMParameters(@NotNull Camera.Parameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"<set-?>");
        this.mParameters = parameters;
    }

    @NotNull
    protected final SurfaceView getMSurfaceView() {
        return this.mSurfaceView;
    }

    protected final void setMSurfaceView(@NotNull SurfaceView surfaceView) {
        Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"<set-?>");
        this.mSurfaceView = surfaceView;
    }

    protected final SurfaceHolder getMSurfaceHolder() {
        return this.mSurfaceHolder;
    }

    protected final void setMSurfaceHolder(SurfaceHolder surfaceHolder) {
        this.mSurfaceHolder = surfaceHolder;
    }

    @NotNull
    protected final Activity getMActivity() {
        return this.mActivity;
    }

    protected final void setMActivity(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"<set-?>");
        this.mActivity = activity;
    }

    @Nullable
    protected final OnCameraListener getMListener() {
        return this.mListener;
    }

    protected final void setMListener(@Nullable OnCameraListener onCameraListener) {
        this.mListener = onCameraListener;
    }

    protected final int getMCameraFacing() {
        return this.mCameraFacing;
    }

    protected final void setMCameraFacing(int n) {
        this.mCameraFacing = n;
    }

    protected final int getMDisplayOrientation() {
        return this.mDisplayOrientation;
    }

    protected final void setMDisplayOrientation(int n) {
        this.mDisplayOrientation = n;
    }

    protected final int getPicWidth() {
        return this.picWidth;
    }

    protected final void setPicWidth(int n) {
        this.picWidth = n;
    }

    protected final int getPicHeight() {
        return this.picHeight;
    }

    protected final void setPicHeight(int n) {
        this.picHeight = n;
    }

    public final void takePic() {
        Camera camera = this.mCamera;
        if (camera != null) {
            camera.takePicture(CameraHelper::takePic$lambda-0, null, (arg_0, arg_1) -> CameraHelper.takePic$lambda-1(this, arg_0, arg_1));
        }
    }

    private final boolean openCamera(int cameraFacing) {
        OnCameraListener onCameraListener;
        boolean isSupport = this.isSupportCameraFacing(cameraFacing);
        if (isSupport) {
            try {
                this.mCamera = Camera.open((int)cameraFacing);
                this.initParameters();
                onCameraListener = this.mCamera;
                if (onCameraListener != null) {
                    onCameraListener.setPreviewCallback((arg_0, arg_1) -> CameraHelper.openCamera$lambda-2(this, arg_0, arg_1));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                OnCameraListener onCameraListener2 = this.mListener;
                if (onCameraListener2 != null) {
                    onCameraListener2.onStatusChange(3, "\u4e0d\u652f\u6301\u8be5\u6444\u50cf\u5934");
                }
                return false;
            }
        }
        if ((onCameraListener = this.mListener) != null) {
            onCameraListener.onStatusChange(3, "\u4e0d\u652f\u6301\u8be5\u6444\u50cf\u5934");
        }
        return false;
    }

    private final void initParameters() {
        block9: {
            try {
                boolean bl;
                Object object;
                Camera camera = this.mCamera;
                if (camera == null) {
                    OnCameraListener onCameraListener = this.mListener;
                    if (onCameraListener != null) {
                        onCameraListener.onStatusChange(2, "\u76f8\u673a\u6253\u5f00\u5931\u8d25");
                    }
                    return;
                }
                Camera.Parameters parameters = camera.getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)parameters, (String)"camera.parameters");
                this.setMParameters(parameters);
                this.getMParameters().setPreviewFormat(17);
                int n = this.mSurfaceView.getWidth();
                int n2 = this.mSurfaceView.getHeight();
                List list = this.getMParameters().getSupportedPreviewSizes();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mParameters.supportedPreviewSizes");
                Camera.Size bestPreviewSize = this.getBestSize(n, n2, list);
                list = bestPreviewSize;
                if (list != null) {
                    object = list;
                    boolean bl2 = false;
                    bl = false;
                    List it = object;
                    boolean bl3 = false;
                    this.getMParameters().setPreviewSize(((Camera.Size)it).width, ((Camera.Size)it).height);
                }
                object = this.getMParameters().getSupportedPictureSizes();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mParameters.supportedPictureSizes");
                Camera.Size bestPicSize = this.getBestSize(this.picWidth, this.picHeight, (List<? extends Camera.Size>)object);
                object = bestPicSize;
                if (object != null) {
                    List list2 = object;
                    bl = false;
                    boolean bl4 = false;
                    List it = list2;
                    boolean bl5 = false;
                    this.getMParameters().setPictureSize(((Camera.Size)it).width, ((Camera.Size)it).height);
                }
                if (this.isSupportFocus("continuous-picture")) {
                    this.getMParameters().setFocusMode("continuous-picture");
                }
                this.setMParameters(this.configParameters(this.getMParameters()));
                camera.setParameters(this.getMParameters());
                object = this.mListener;
                if (object != null) {
                    object.onStatusChange(4, "\u76f8\u673a\u53c2\u6570\u521d\u59cb\u5316\u6210\u529f");
                }
                object = this.mListener;
                if (object != null) {
                    object.onStatusChange(1, "\u76f8\u673a\u6253\u5f00\u6210\u529f");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.toast("\u76f8\u673a\u521d\u59cb\u5316\u5931\u8d25!");
                OnCameraListener onCameraListener = this.mListener;
                if (onCameraListener == null) break block9;
                onCameraListener.onStatusChange(5, "\u76f8\u673a\u53c2\u6570\u521d\u59cb\u5316\u5931\u8d25");
            }
        }
    }

    @NotNull
    protected Camera.Parameters configParameters(@NotNull Camera.Parameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        return parameters;
    }

    public final void startPreview() {
        Camera camera = this.mCamera;
        if (camera != null) {
            camera.setPreviewDisplay(this.mSurfaceHolder);
        }
        camera = this.mCamera;
        if (camera != null) {
            camera.setDisplayOrientation(this.getCameraDisplayOrientation(this.mActivity));
        }
        camera = this.mCamera;
        if (camera != null) {
            camera.startPreview();
        }
        this.startFaceDetect();
    }

    private final void startFaceDetect() {
        Camera camera = this.mCamera;
        if (camera != null) {
            camera.startFaceDetection();
        }
        camera = this.mCamera;
        if (camera != null) {
            camera.setFaceDetectionListener((arg_0, arg_1) -> CameraHelper.startFaceDetect$lambda-5(this, arg_0, arg_1));
        }
    }

    private final boolean isSupportFocus(String focusMode) {
        boolean autoFocus = false;
        List listFocusMode = this.getMParameters().getSupportedFocusModes();
        for (String mode : listFocusMode) {
            Log.d((String)"testtag", (String)Intrinsics.stringPlus((String)"\u76f8\u673a\u652f\u6301\u7684\u5bf9\u7126\u6a21\u5f0f\uff1a ", (Object)mode));
            if (!Intrinsics.areEqual((Object)mode, (Object)focusMode)) continue;
            autoFocus = true;
        }
        return autoFocus;
    }

    public final void exchangeCamera() {
        this.releaseCamera();
        this.mCameraFacing = this.mCameraFacing == 0 ? 1 : 0;
        this.openCamera(this.mCameraFacing);
        this.startPreview();
    }

    public final void releaseCamera() {
        Camera camera = this.mCamera;
        if (camera != null) {
            camera.stopPreview();
        }
        camera = this.mCamera;
        if (camera != null) {
            camera.setPreviewCallback(null);
        }
        camera = this.mCamera;
        if (camera != null) {
            camera.release();
        }
        this.mCamera = null;
    }

    private final Camera.Size getBestSize(int width, int height, List<? extends Camera.Size> sizeList) {
        double targetRatio = (double)height / (double)width;
        PrintLog.v((String)"testtag", (String)("\u76ee\u6807\u5c3a\u5bf8 \uff1a" + height + " * " + width + " \uff0c   \u9ad8\u5bbd\u6bd4  " + targetRatio));
        ArrayList<Camera.Size> suitableList = new ArrayList<Camera.Size>();
        for (Camera.Size size : sizeList) {
            double sizeRatio = (double)size.width / (double)size.height;
            PrintLog.i((String)"testtag", (String)("\u7cfb\u7edf\u652f\u6301\u7684\u5c3a\u5bf8 : " + size.width + " * " + size.height + " ,    \u6bd4\u4f8b" + sizeRatio));
            if (!(targetRatio <= sizeRatio)) continue;
            suitableList.add(size);
        }
        if (suitableList.size() == 0) {
            return null;
        }
        if (suitableList.size() == 1) {
            Log.d((String)"testtag", (String)("\u6700\u4f18\u5c3a\u5bf8 \uff1a" + ((Camera.Size)suitableList.get((int)0)).height + " * " + ((Camera.Size)suitableList.get((int)0)).width));
            return (Camera.Size)suitableList.get(0);
        }
        Camera.Size bestSize = null;
        Object e = suitableList.get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"suitableList[0]");
        bestSize = (Camera.Size)e;
        Iterable iterable = suitableList;
        boolean $i$f$forEach = false;
        for (Object element$iv : iterable) {
            Camera.Size it = (Camera.Size)element$iv;
            boolean bl = false;
            if (it.width <= ((Camera.Size)bestSize).width) continue;
            bestSize = it;
        }
        Log.d((String)"testtag", (String)("\u6700\u4f18\u5c3a\u5bf8 \uff1a" + ((Camera.Size)bestSize).width + " * " + ((Camera.Size)bestSize).height));
        return bestSize;
    }

    private final int getCameraDisplayOrientation(Activity activity) {
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.mCameraFacing, (Camera.CameraInfo)info);
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int screenDegree = 0;
        int n = rotation;
        switch (n) {
            case 0: {
                screenDegree = 0;
                break;
            }
            case 1: {
                screenDegree = 90;
                break;
            }
            case 2: {
                screenDegree = 180;
                break;
            }
            case 3: {
                screenDegree = 270;
            }
        }
        if (info.facing == 1) {
            this.mDisplayOrientation = (info.orientation + screenDegree) % 360;
            this.mDisplayOrientation = (360 - this.mDisplayOrientation) % 360;
        } else {
            this.mDisplayOrientation = (info.orientation - screenDegree + 360) % 360;
        }
        Log.d((String)"testtag", (String)Intrinsics.stringPlus((String)"\u5c4f\u5e55\u7684\u65cb\u8f6c\u89d2\u5ea6 : ", (Object)rotation));
        Log.d((String)"testtag", (String)Intrinsics.stringPlus((String)"setDisplayOrientation(result) : ", (Object)this.mDisplayOrientation));
        return this.mDisplayOrientation;
    }

    private final boolean isSupportCameraFacing(int cameraFacing) {
        Camera.CameraInfo info = new Camera.CameraInfo();
        int n = 0;
        int n2 = Camera.getNumberOfCameras();
        if (n < n2) {
            do {
                int i = n++;
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
                if (info.facing != cameraFacing) continue;
                return true;
            } while (n < n2);
        }
        return false;
    }

    private final ArrayList<RectF> transForm(Camera.Face[] faces) {
        Matrix matrix = new Matrix();
        boolean mirror = this.mCameraFacing == 1;
        matrix.setScale(mirror ? -1.0f : 1.0f, 1.0f);
        matrix.postRotate((float)this.mDisplayOrientation);
        matrix.postScale((float)this.mSurfaceView.getWidth() / 2000.0f, (float)this.mSurfaceView.getHeight() / 2000.0f);
        matrix.postTranslate((float)this.mSurfaceView.getWidth() / 2.0f, (float)this.mSurfaceView.getHeight() / 2.0f);
        ArrayList<RectF> rectList = new ArrayList<RectF>();
        for (Camera.Face face : faces) {
            RectF srcRect = new RectF(face.rect);
            RectF dstRect = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
            matrix.mapRect(dstRect, srcRect);
            rectList.add(dstRect);
        }
        return rectList;
    }

    public final boolean controlFlash() {
        String flashMode = this.getMParameters().getFlashMode();
        CharSequence charSequence = flashMode;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        if (Intrinsics.areEqual((Object)flashMode, (Object)"torch")) {
            this.getMParameters().setFlashMode("off");
        } else {
            this.getMParameters().setFlashMode("torch");
            this.getMParameters().setExposureCompensation(-1);
        }
        try {
            if (this.mCamera == null) {
                return false;
            }
            charSequence = this.mCamera;
            if (charSequence != null) {
                charSequence.setParameters(this.getMParameters());
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private final void toast(String msg) {
        Toast.makeText((Context)((Context)this.mActivity), (CharSequence)msg, (int)0).show();
    }

    @Nullable
    public final Camera getCamera() {
        return this.mCamera;
    }

    public final int getCameraFacing() {
        return this.mCameraFacing;
    }

    public final int getDisplayOrientation() {
        return this.mDisplayOrientation;
    }

    public final void setOnCameraListener(@NotNull OnCameraListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.mListener = listener;
    }

    @JvmOverloads
    public CameraHelper(@NotNull Activity activity, @NotNull SurfaceView surfaceView) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"surfaceView");
        this(activity, surfaceView, 0, 4, null);
    }

    private static final void takePic$lambda-0() {
    }

    private static final void takePic$lambda-1(CameraHelper this$0, byte[] data, Camera camera) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        camera.startPreview();
        OnCameraListener onCameraListener = this$0.getMListener();
        if (onCameraListener != null) {
            Intrinsics.checkNotNullExpressionValue((Object)camera, (String)"camera");
            onCameraListener.onTakePic(data, camera);
        }
    }

    private static final void openCamera$lambda-2(CameraHelper this$0, byte[] data, Camera camera) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        OnCameraListener onCameraListener = this$0.getMListener();
        if (onCameraListener != null) {
            Intrinsics.checkNotNullExpressionValue((Object)camera, (String)"camera");
            onCameraListener.onPreviewFrame(data, camera);
        }
    }

    private static final void startFaceDetect$lambda-5(CameraHelper this$0, Camera.Face[] faces, Camera $noName_1) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        OnCameraListener onCameraListener = this$0.getMListener();
        if (onCameraListener != null) {
            Intrinsics.checkNotNullExpressionValue((Object)faces, (String)"faces");
            onCameraListener.onFaceDetect(this$0.transForm(faces));
        }
        Log.d((String)"testtag", (String)("\u68c0\u6d4b\u5230 " + faces.length + " \u5f20\u4eba\u8138"));
    }
}

