/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.camera;

import android.app.Activity;
import android.content.Context;
import android.hardware.Camera;
import android.media.MediaRecorder;
import android.util.Log;
import android.view.Surface;
import android.widget.Toast;
import com.lodz.android.corekt.anko.AnkoStringKt;
import com.lodz.android.corekt.utils.FileUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u0006\u0010!\u001a\u00020\u001fR\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/lodz/android/pandora/widget/camera/MediaRecorderHelper;", "", "mContext", "Landroid/app/Activity;", "mCamera", "Landroid/hardware/Camera;", "rotation", "", "surface", "Landroid/view/Surface;", "savePath", "", "fileName", "(Landroid/app/Activity;Landroid/hardware/Camera;ILandroid/view/Surface;Ljava/lang/String;Ljava/lang/String;)V", "filePath", "isRunning", "", "()Z", "setRunning", "(Z)V", "getMContext", "()Landroid/app/Activity;", "setMContext", "(Landroid/app/Activity;)V", "mMediaRecorder", "Landroid/media/MediaRecorder;", "getMMediaRecorder", "()Landroid/media/MediaRecorder;", "setMMediaRecorder", "(Landroid/media/MediaRecorder;)V", "release", "", "startRecord", "stopRecord", "pandora_release"})
public final class MediaRecorderHelper {
    @NotNull
    private Activity mContext;
    @NotNull
    private Camera mCamera;
    private int rotation;
    @NotNull
    private Surface surface;
    @NotNull
    private String savePath;
    @NotNull
    private String fileName;
    @Nullable
    private MediaRecorder mMediaRecorder;
    private boolean isRunning;
    @NotNull
    private String filePath;

    public MediaRecorderHelper(@NotNull Activity mContext, @NotNull Camera mCamera, int rotation, @NotNull Surface surface, @NotNull String savePath, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        Intrinsics.checkNotNullParameter((Object)mCamera, (String)"mCamera");
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)savePath, (String)"savePath");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.mContext = mContext;
        this.mCamera = mCamera;
        this.rotation = rotation;
        this.surface = surface;
        this.savePath = savePath;
        this.fileName = fileName;
        this.filePath = "";
    }

    @NotNull
    public final Activity getMContext() {
        return this.mContext;
    }

    public final void setMContext(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"<set-?>");
        this.mContext = activity;
    }

    @Nullable
    public final MediaRecorder getMMediaRecorder() {
        return this.mMediaRecorder;
    }

    public final void setMMediaRecorder(@Nullable MediaRecorder mediaRecorder) {
        this.mMediaRecorder = mediaRecorder;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final void setRunning(boolean bl) {
        this.isRunning = bl;
    }

    public final void startRecord() {
        try {
            String string2;
            Object object = this.savePath;
            boolean bl = false;
            Object object2 = object.length() == 0 ? ((object = this.mContext.getExternalFilesDir("")) == null ? null : ((File)object).getAbsolutePath()) : (string2 = this.savePath);
            if (string2 == null) {
                return;
            }
            String path = string2;
            string2 = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
            if (!StringsKt.endsWith$default((String)path, (String)string2, (boolean)false, (int)2, null)) {
                AnkoStringKt.append((String)path, (Object)File.separator);
            }
            AnkoStringKt.append((String)path, (Object)this.fileName);
            this.filePath = path;
            FileUtils.createNewFile((String)path);
            this.mMediaRecorder = new MediaRecorder();
            string2 = this.mMediaRecorder;
            if (string2 != null) {
                object = string2;
                bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                this.mCamera.unlock();
                it.reset();
                it.setCamera(this.mCamera);
                it.setOrientationHint(this.rotation);
                it.setAudioSource(1);
                it.setVideoSource(1);
                it.setOutputFormat(2);
                it.setAudioEncoder(0);
                it.setVideoEncoder(0);
                it.setVideoSize(3840, 2160);
                it.setVideoEncodingBitRate(16588800);
                it.setPreviewDisplay(this.surface);
                it.setOutputFile(path);
                it.prepare();
                it.start();
                this.setRunning(true);
                Log.d((String)"testtag", (String)"\u5f00\u59cb\u5f55\u5236\u89c6\u9891");
                Log.d((String)"testtag", (String)Intrinsics.stringPlus((String)"\u89c6\u9891\u4fdd\u5b58\u8def\u5f84\uff1a", (Object)path));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void stopRecord() {
        MediaRecorder mediaRecorder = this.mMediaRecorder;
        if (mediaRecorder != null) {
            mediaRecorder.stop();
        }
        this.isRunning = false;
        Log.d((String)"testtag", (String)"\u505c\u6b62\u5f55\u5236\u89c6\u9891");
        Toast.makeText((Context)((Context)this.mContext), (CharSequence)Intrinsics.stringPlus((String)"\u89c6\u9891\u4fdd\u5b58\u8def\u5f84\uff1a", (Object)this.filePath), (int)1).show();
    }

    public final void release() {
        if (this.mMediaRecorder != null) {
            MediaRecorder mediaRecorder = this.mMediaRecorder;
            if (mediaRecorder != null) {
                mediaRecorder.release();
            }
            this.mMediaRecorder = null;
            this.isRunning = false;
        }
    }
}

