/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.custom;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.core.view.ViewGroupKt;
import com.lodz.android.corekt.anko.AnkoContextCompatKt;
import com.lodz.android.pandora.R;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0014\b\u0016\u0018\u0000 A2\u00020\u0001:\u0001AB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\tH\u0002J\u0018\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\tH\u0002J\u0018\u0010$\u001a\u00020 2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\tH\u0002J\u0018\u0010%\u001a\u00020 2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\tH\u0002J\u0006\u0010&\u001a\u00020\tJ\b\u0010'\u001a\u00020\tH\u0007J\u0012\u0010(\u001a\u00020\u001e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010)\u001a\u00020\u001e2\b\u0010*\u001a\u0004\u0018\u00010+H\u0014J0\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\tH\u0014J\u001e\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020\tJ\u000e\u00107\u001a\u00020\u001e2\u0006\u00108\u001a\u00020\tJ\u0010\u00109\u001a\u00020\u001e2\b\b\u0001\u0010:\u001a\u00020\tJ\u0010\u0010;\u001a\u00020\u001e2\b\b\u0001\u0010:\u001a\u00020\tJ&\u0010<\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020\t2\u0006\u0010@\u001a\u00020\tR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/lodz/android/pandora/widget/custom/HoleLayout;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "mChildrenView", "Landroid/view/View;", "mCircleRadius", "mCircleX", "mCircleY", "mHolePaint", "Landroid/graphics/Paint;", "mHoleType", "mMaskPaint", "mPaint", "mRectangleLong", "mRectangleWidth", "mRectangleX", "mRectangleY", "mXfermode", "Landroid/graphics/PorterDuffXfermode;", "configLayout", "", "createDstChildBitmap", "Landroid/graphics/Bitmap;", "width", "height", "createDstCircleBitmap", "createDstRectangleBitmap", "createMaskSrcBitmap", "getHoleType", "getMaskColor", "init", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onLayout", "changed", "", "left", "top", "right", "bottom", "setCirclePosition", "circleX", "circleY", "circleRadius", "setHoleType", "holeType", "setMaskColor", "color", "setMaskColorRes", "setRectanglePosition", "rectangleX", "rectangleY", "rectangleLong", "rectangleWidth", "Companion", "pandora_release"})
public class HoleLayout
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private View mChildrenView;
    @NotNull
    private final Paint mMaskPaint;
    @NotNull
    private final Paint mHolePaint;
    @NotNull
    private final Paint mPaint;
    @NotNull
    private final PorterDuffXfermode mXfermode;
    private int mHoleType;
    private int mCircleX;
    private int mCircleY;
    private int mCircleRadius;
    private int mRectangleX;
    private int mRectangleY;
    private int mRectangleLong;
    private int mRectangleWidth;
    public static final int NONE = -1;
    public static final int FIRST_CHILD = 0;
    public static final int CIRCLE = 1;
    public static final int RECTANGLE = 2;

    public HoleLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.mMaskPaint = new Paint(1);
        this.mHolePaint = new Paint(1);
        this.mPaint = new Paint(1);
        this.mXfermode = new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT);
        this.mHoleType = -1;
        this.init(null);
    }

    public HoleLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.mMaskPaint = new Paint(1);
        this.mHolePaint = new Paint(1);
        this.mPaint = new Paint(1);
        this.mXfermode = new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT);
        this.mHoleType = -1;
        this.init(attrs);
    }

    public HoleLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mMaskPaint = new Paint(1);
        this.mHolePaint = new Paint(1);
        this.mPaint = new Paint(1);
        this.mXfermode = new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT);
        this.mHoleType = -1;
        this.init(attrs);
    }

    public HoleLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mMaskPaint = new Paint(1);
        this.mHolePaint = new Paint(1);
        this.mPaint = new Paint(1);
        this.mXfermode = new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT);
        this.mHoleType = -1;
        this.init(attrs);
    }

    private final void init(AttributeSet attrs) {
        this.configLayout(attrs);
        this.mHolePaint.setColor(-1);
        this.setBackgroundColor(0);
    }

    private final void configLayout(AttributeSet attrs) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        TypedArray typedArray = null;
        if (attrs != null) {
            typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.HoleLayout);
        }
        int defMaskColor = AnkoContextCompatKt.getColorCompat((View)((View)this), (int)R.color.design_bottom_navigation_shadow_color);
        TypedArray typedArray2 = typedArray;
        int maskColor = typedArray2 == null ? defMaskColor : (n9 = typedArray2.getColor(R.styleable.HoleLayout_maskColor, defMaskColor));
        this.setMaskColor(maskColor);
        TypedArray typedArray3 = typedArray;
        int holeType = typedArray3 == null ? -1 : (n8 = typedArray3.getInt(R.styleable.HoleLayout_holeType, -1));
        this.setHoleType(holeType);
        TypedArray typedArray4 = typedArray;
        int circleX = typedArray4 == null ? 0 : (n7 = typedArray4.getDimensionPixelSize(R.styleable.HoleLayout_circleX, 0));
        TypedArray typedArray5 = typedArray;
        int circleY = typedArray5 == null ? 0 : (n6 = typedArray5.getDimensionPixelSize(R.styleable.HoleLayout_circleY, 0));
        TypedArray typedArray6 = typedArray;
        int circleRadius = typedArray6 == null ? 0 : (n5 = typedArray6.getDimensionPixelSize(R.styleable.HoleLayout_circleRadius, 0));
        this.setCirclePosition(circleX, circleY, circleRadius);
        TypedArray typedArray7 = typedArray;
        int rectangleX = typedArray7 == null ? 0 : (n4 = typedArray7.getDimensionPixelSize(R.styleable.HoleLayout_rectangleX, 0));
        TypedArray typedArray8 = typedArray;
        int rectangleY = typedArray8 == null ? 0 : (n3 = typedArray8.getDimensionPixelSize(R.styleable.HoleLayout_rectangleY, 0));
        TypedArray typedArray9 = typedArray;
        int rectangleLong = typedArray9 == null ? 0 : (n2 = typedArray9.getDimensionPixelSize(R.styleable.HoleLayout_rectangleLong, 0));
        TypedArray typedArray10 = typedArray;
        int rectangleWidth = typedArray10 == null ? 0 : (n = typedArray10.getDimensionPixelSize(R.styleable.HoleLayout_rectangleWidth, 0));
        this.setRectanglePosition(rectangleX, rectangleY, rectangleLong, rectangleWidth);
        typedArray10 = typedArray;
        if (typedArray10 != null) {
            typedArray10.recycle();
        }
    }

    public final void setHoleType(int holeType) {
        this.mHoleType = holeType;
    }

    public final int getHoleType() {
        return this.mHoleType;
    }

    public final void setMaskColor(@ColorInt int color2) {
        this.mMaskPaint.setColor(color2);
    }

    public final void setMaskColorRes(@ColorRes int color2) {
        this.setMaskColor(AnkoContextCompatKt.getColorCompat((View)((View)this), (int)color2));
    }

    @ColorInt
    public final int getMaskColor() {
        return this.mMaskPaint.getColor();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (SequencesKt.count((Sequence)ViewGroupKt.getChildren((ViewGroup)((ViewGroup)this))) > 0) {
            this.mChildrenView = (View)SequencesKt.elementAt((Sequence)ViewGroupKt.getChildren((ViewGroup)((ViewGroup)this)), (int)0);
        }
    }

    public final void setCirclePosition(int circleX, int circleY, int circleRadius) {
        this.mCircleX = circleX;
        this.mCircleY = circleY;
        this.mCircleRadius = circleRadius;
    }

    public final void setRectanglePosition(int rectangleX, int rectangleY, int rectangleLong, int rectangleWidth) {
        this.mRectangleX = rectangleX;
        this.mRectangleY = rectangleY;
        this.mRectangleLong = rectangleLong;
        this.mRectangleWidth = rectangleWidth;
    }

    protected void onDraw(@Nullable Canvas canvas) {
        Bitmap bitmap;
        super.onDraw(canvas);
        if (this.mHoleType == -1) {
            return;
        }
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int n = this.mHoleType;
        switch (n) {
            case 1: {
                Bitmap bitmap2 = this.createDstCircleBitmap(width, height);
                break;
            }
            case 2: {
                Bitmap bitmap2 = this.createDstRectangleBitmap(width, height);
                break;
            }
            case 0: {
                Bitmap bitmap2 = this.createDstChildBitmap(width, height);
                break;
            }
            default: {
                Bitmap bitmap2 = bitmap = null;
            }
        }
        if (bitmap == null) {
            return;
        }
        Bitmap dstCircle = bitmap;
        Bitmap srcRect = this.createMaskSrcBitmap(width, height);
        this.mPaint.setFilterBitmap(false);
        Canvas canvas2 = canvas;
        if (canvas2 != null) {
            canvas2.saveLayer(0.0f, 0.0f, (float)width, (float)height, null);
        }
        canvas2 = canvas;
        if (canvas2 != null) {
            canvas2.drawBitmap(dstCircle, 0.0f, 0.0f, this.mPaint);
        }
        this.mPaint.setXfermode((Xfermode)this.mXfermode);
        canvas2 = canvas;
        if (canvas2 != null) {
            canvas2.drawBitmap(srcRect, 0.0f, 0.0f, this.mPaint);
        }
        this.mPaint.setXfermode(null);
        canvas2 = canvas;
        if (canvas2 != null) {
            canvas2.saveLayer(0.0f, 0.0f, (float)width, (float)height, null);
        }
    }

    private final Bitmap createMaskSrcBitmap(int width, int height) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvcs = new Canvas(bitmap);
        canvcs.drawRect(new RectF(0.0f, 0.0f, (float)width, (float)height), this.mMaskPaint);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }

    private final Bitmap createDstCircleBitmap(int width, int height) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvcs = new Canvas(bitmap);
        canvcs.drawCircle((float)this.mCircleX, (float)this.mCircleY, (float)this.mCircleRadius, this.mHolePaint);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }

    private final Bitmap createDstRectangleBitmap(int width, int height) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvcs = new Canvas(bitmap);
        canvcs.drawRect((float)this.mRectangleX, (float)this.mRectangleY, (float)(this.mRectangleX + this.mRectangleLong), (float)(this.mRectangleY + this.mRectangleWidth), this.mHolePaint);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }

    private final Bitmap createDstChildBitmap(int width, int height) {
        float f;
        float f2;
        float f3;
        float f4;
        int n;
        float f5;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvcs = new Canvas(bitmap);
        View view = this.mChildrenView;
        if (view == null) {
            f5 = 0.0f;
        } else {
            n = view.getLeft();
            f5 = f4 = (float)n;
        }
        view = this.mChildrenView;
        if (view == null) {
            f3 = 0.0f;
        } else {
            n = view.getTop();
            f3 = f4 = (float)n;
        }
        view = this.mChildrenView;
        if (view == null) {
            f2 = 0.0f;
        } else {
            n = view.getRight();
            f2 = f4 = (float)n;
        }
        view = this.mChildrenView;
        if (view == null) {
            f = 0.0f;
        } else {
            n = view.getBottom();
            f = f4 = (float)n;
        }
        canvcs.drawRect(f5, f3, f2, f, this.mHolePaint);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }

    public void _$_clearFindViewByIdCache() {
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/lodz/android/pandora/widget/custom/HoleLayout$Companion;", "", "()V", "CIRCLE", "", "FIRST_CHILD", "NONE", "RECTANGLE", "pandora_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

