/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.custom;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.DrawableRes;
import androidx.core.widget.NestedScrollView;
import com.lodz.android.corekt.anko.AnkoArrayKt;
import com.lodz.android.corekt.utils.BitmapUtils;
import com.lodz.android.pandora.R;
import com.lodz.android.pandora.rx.subscribe.observer.BaseObserver;
import com.lodz.android.pandora.rx.utils.RxUtils;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u00020\u00192\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\u0006\u0010\u001c\u001a\u00020\u0012J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0002J\u0012\u0010 \u001a\u00020\u00192\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0016\u0010!\u001a\u00020\u00192\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0006\u0010#\u001a\u00020\u0019J\u000e\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u0017J\u000e\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020\u00192\b\b\u0001\u0010*\u001a\u00020\tJ\u0012\u0010+\u001a\u00020\u00192\b\u0010,\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010-\u001a\u00020\u00192\b\u0010,\u001a\u0004\u0018\u00010\u0010H\u0016J\u000e\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u00020\tJ\u0010\u00103\u001a\u00020\u00192\b\b\u0001\u0010*\u001a\u00020\tJ\u000e\u00104\u001a\u00020\u00192\u0006\u00105\u001a\u00020\u001eJ\u000e\u00106\u001a\u00020\u00192\u0006\u00107\u001a\u00020\tJ\u0012\u00108\u001a\u00020\u00192\b\b\u0002\u00109\u001a\u00020:H\u0007R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/lodz/android/pandora/widget/custom/LongImageView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mPdrClickListener", "Landroid/view/View$OnClickListener;", "mPdrImgLayout", "Landroid/widget/LinearLayout;", "mPdrLongClickListener", "Landroid/view/View$OnLongClickListener;", "mPdrPlaceholderImg", "Landroid/widget/ImageView;", "mPdrScrollView", "Landroidx/core/widget/NestedScrollView;", "mPdrTempBitmaps", "", "Landroid/graphics/Bitmap;", "clearViews", "", "configLayout", "findViews", "getPlaceholderImageView", "getTypeById", "Landroid/widget/ImageView$ScaleType;", "type", "init", "loadImageBitmaps", "bitmaps", "release", "setImageBitmap", "bitmap", "setImageFile", "file", "Ljava/io/File;", "setImageRes", "resId", "setOnClickListener", "l", "setOnLongClickListener", "setPlaceholderDrawable", "drawable", "Landroid/graphics/drawable/Drawable;", "setPlaceholderHeight", "height", "setPlaceholderRes", "setPlaceholderScaleType", "scaleType", "setPlaceholderWidth", "width", "showPlaceholder", "isShow", "", "pandora_release"})
public final class LongImageView
extends FrameLayout {
    private LinearLayout mPdrImgLayout;
    private NestedScrollView mPdrScrollView;
    private ImageView mPdrPlaceholderImg;
    @Nullable
    private List<Bitmap> mPdrTempBitmaps;
    @Nullable
    private View.OnClickListener mPdrClickListener;
    @Nullable
    private View.OnLongClickListener mPdrLongClickListener;

    public LongImageView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.init(null);
    }

    public LongImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.init(attrs);
    }

    public LongImageView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private final void init(AttributeSet attrs) {
        this.findViews();
        this.configLayout(attrs);
    }

    private final void findViews() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pandora_view_long_img, (ViewGroup)this);
        View view = this.findViewById(R.id.pdr_root_layout);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.pdr_root_layout)");
        this.mPdrImgLayout = (LinearLayout)view;
        view = this.findViewById(R.id.pdr_scroll_view);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.pdr_scroll_view)");
        this.mPdrScrollView = (NestedScrollView)view;
        view = this.findViewById(R.id.pdr_placeholder_img);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.pdr_placeholder_img)");
        this.mPdrPlaceholderImg = (ImageView)view;
    }

    private final void configLayout(AttributeSet attrs) {
        boolean bl;
        TypedArray typedArray;
        int n;
        int scaleType;
        int n2;
        TypedArray typedArray2;
        Drawable placeholder;
        TypedArray typedArray3 = null;
        if (attrs != null) {
            typedArray3 = this.getContext().obtainStyledAttributes(attrs, R.styleable.LongImageView);
        }
        Drawable drawable2 = placeholder = (typedArray2 = typedArray3) == null ? null : typedArray2.getDrawable(R.styleable.LongImageView_placeholderDrawable);
        if (placeholder != null) {
            this.setPlaceholderDrawable(placeholder);
        } else {
            this.setPlaceholderRes(R.drawable.pandora_ic_launcher);
        }
        typedArray2 = typedArray3;
        this.setPlaceholderWidth(typedArray2 == null ? -2 : (n2 = typedArray2.getDimensionPixelSize(R.styleable.LongImageView_placeholderWidth, -2)));
        typedArray2 = typedArray3;
        this.setPlaceholderHeight(typedArray2 == null ? -2 : (n2 = typedArray2.getDimensionPixelSize(R.styleable.LongImageView_placeholderHeight, -2)));
        TypedArray typedArray4 = typedArray3;
        int n3 = scaleType = typedArray4 == null ? -1 : (n = typedArray4.getInt(R.styleable.LongImageView_placeholderScaleType, -1));
        if (scaleType != -1) {
            this.setPlaceholderScaleType(this.getTypeById(scaleType));
        }
        boolean isShowPlaceholder = (typedArray = typedArray3) == null ? true : (bl = typedArray.getBoolean(R.styleable.LongImageView_showPlaceholder, true));
        this.showPlaceholder(isShowPlaceholder);
        typedArray = typedArray3;
        if (typedArray != null) {
            typedArray.recycle();
        }
    }

    private final ImageView.ScaleType getTypeById(int type) {
        ImageView.ScaleType scaleType;
        int n = type;
        switch (n) {
            case 0: {
                scaleType = ImageView.ScaleType.MATRIX;
                break;
            }
            case 1: {
                scaleType = ImageView.ScaleType.FIT_XY;
                break;
            }
            case 2: {
                scaleType = ImageView.ScaleType.FIT_START;
                break;
            }
            case 3: {
                scaleType = ImageView.ScaleType.FIT_CENTER;
                break;
            }
            case 4: {
                scaleType = ImageView.ScaleType.FIT_END;
                break;
            }
            case 5: {
                scaleType = ImageView.ScaleType.CENTER;
                break;
            }
            case 6: {
                scaleType = ImageView.ScaleType.CENTER_CROP;
                break;
            }
            case 7: {
                scaleType = ImageView.ScaleType.CENTER_INSIDE;
                break;
            }
            default: {
                scaleType = ImageView.ScaleType.CENTER;
            }
        }
        return scaleType;
    }

    public final void setPlaceholderRes(@DrawableRes int resId) {
        ImageView imageView = this.mPdrPlaceholderImg;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrPlaceholderImg");
            throw null;
        }
        imageView.setImageResource(resId);
    }

    public final void setPlaceholderDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        ImageView imageView = this.mPdrPlaceholderImg;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrPlaceholderImg");
            throw null;
        }
        imageView.setImageDrawable(drawable2);
    }

    public final void setPlaceholderScaleType(@NotNull ImageView.ScaleType scaleType) {
        Intrinsics.checkNotNullParameter((Object)scaleType, (String)"scaleType");
        ImageView imageView = this.mPdrPlaceholderImg;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrPlaceholderImg");
            throw null;
        }
        imageView.setScaleType(scaleType);
    }

    public final void setPlaceholderWidth(int width) {
        ImageView imageView = this.mPdrPlaceholderImg;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrPlaceholderImg");
            throw null;
        }
        ViewGroup.LayoutParams layoutParams = imageView.getLayoutParams();
        if ((imageView = layoutParams) != null) {
            imageView.width = width;
        }
    }

    public final void setPlaceholderHeight(int height) {
        ImageView imageView = this.mPdrPlaceholderImg;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrPlaceholderImg");
            throw null;
        }
        ViewGroup.LayoutParams layoutParams = imageView.getLayoutParams();
        if ((imageView = layoutParams) != null) {
            imageView.height = height;
        }
    }

    @JvmOverloads
    public final void showPlaceholder(boolean isShow) {
        ImageView imageView = this.mPdrPlaceholderImg;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrPlaceholderImg");
            throw null;
        }
        imageView.setVisibility(isShow ? 0 : 8);
        imageView = this.mPdrScrollView;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrScrollView");
            throw null;
        }
        imageView.setVisibility(isShow ? 8 : 0);
    }

    public static /* synthetic */ void showPlaceholder$default(LongImageView longImageView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        longImageView.showPlaceholder(bl);
    }

    @NotNull
    public final ImageView getPlaceholderImageView() {
        ImageView imageView = this.mPdrPlaceholderImg;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrPlaceholderImg");
            throw null;
        }
        return imageView;
    }

    public final void setImageRes(@DrawableRes int resId) {
        LongImageView.showPlaceholder$default(this, false, 1, null);
        this.clearViews();
        Observable.just((Object)resId).map(arg_0 -> LongImageView.setImageRes$lambda-0(this, arg_0)).compose(RxUtils.ioToMainObservable()).subscribe((Observer)new BaseObserver<Bitmap>(this){
            final /* synthetic */ LongImageView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onBaseNext(@NotNull Bitmap any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                this.this$0.setImageBitmap(any);
            }

            public void onBaseError(@NotNull Throwable e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
    }

    public final void setImageFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        LongImageView.showPlaceholder$default(this, false, 1, null);
        this.clearViews();
        Observable.just((Object)file).map(LongImageView::setImageFile$lambda-1).compose(RxUtils.ioToMainObservable()).subscribe((Observer)new BaseObserver<Bitmap>(this){
            final /* synthetic */ LongImageView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onBaseNext(@NotNull Bitmap any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                this.this$0.setImageBitmap(any);
            }

            public void onBaseError(@NotNull Throwable e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
    }

    public final void setImageBitmap(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        LongImageView.showPlaceholder$default(this, false, 1, null);
        this.clearViews();
        Observable.just((Object)bitmap).map(arg_0 -> LongImageView.setImageBitmap$lambda-2(this, arg_0)).compose(RxUtils.ioToMainObservable()).subscribe((Observer)new BaseObserver<List<? extends Bitmap>>(this){
            final /* synthetic */ LongImageView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onBaseNext(@NotNull List<Bitmap> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                LongImageView.access$loadImageBitmaps(this.this$0, any);
            }

            public void onBaseError(@NotNull Throwable e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
    }

    private final void loadImageBitmaps(List<Bitmap> bitmaps) {
        this.mPdrTempBitmaps = bitmaps;
        for (Bitmap bitmap : bitmaps) {
            ImageView imageView = new ImageView(this.getContext());
            imageView.setAdjustViewBounds(true);
            imageView.setImageBitmap(bitmap);
            imageView.setOnClickListener(arg_0 -> LongImageView.loadImageBitmaps$lambda-3(this, arg_0));
            imageView.setOnLongClickListener(arg_0 -> LongImageView.loadImageBitmaps$lambda-4(this, arg_0));
            LinearLayout linearLayout = this.mPdrImgLayout;
            if (linearLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrImgLayout");
                throw null;
            }
            linearLayout.addView((View)imageView, new ViewGroup.LayoutParams(-1, -2));
        }
        ImageView imageView = this.mPdrPlaceholderImg;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrPlaceholderImg");
            throw null;
        }
        imageView.setVisibility(8);
        imageView = this.mPdrScrollView;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrScrollView");
            throw null;
        }
        imageView.setVisibility(0);
    }

    private final void clearViews() {
        LinearLayout linearLayout = this.mPdrImgLayout;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPdrImgLayout");
            throw null;
        }
        linearLayout.removeAllViews();
        if (AnkoArrayKt.getSize((Collection)this.mPdrTempBitmaps) > 0) {
            List<Bitmap> list = this.mPdrTempBitmaps;
            Intrinsics.checkNotNull(list);
            for (Bitmap bitmap : list) {
                bitmap.recycle();
            }
            this.mPdrTempBitmaps = null;
        }
    }

    public final void release() {
        this.clearViews();
        this.mPdrClickListener = null;
        this.mPdrLongClickListener = null;
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        super.setOnClickListener(l);
        this.mPdrClickListener = l;
    }

    public void setOnLongClickListener(@Nullable View.OnLongClickListener l) {
        super.setOnLongClickListener(l);
        this.mPdrLongClickListener = l;
    }

    public void _$_clearFindViewByIdCache() {
    }

    @JvmOverloads
    public final void showPlaceholder() {
        LongImageView.showPlaceholder$default(this, false, 1, null);
    }

    private static final Bitmap setImageRes$lambda-0(LongImageView this$0, Integer id2) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Resources resources = this$0.getContext().getResources();
        Intrinsics.checkNotNullExpressionValue((Object)id2, (String)"id");
        return BitmapFactory.decodeResource((Resources)resources, (int)id2);
    }

    private static final Bitmap setImageFile$lambda-1(File f) {
        return BitmapFactory.decodeFile((String)f.getAbsolutePath());
    }

    private static final List setImageBitmap$lambda-2(LongImageView this$0, Bitmap bmp) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Context context = this$0.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Intrinsics.checkNotNullExpressionValue((Object)bmp, (String)"bmp");
        return BitmapUtils.createLongLargeBitmaps((Context)context, (Bitmap)bmp);
    }

    private static final void loadImageBitmaps$lambda-3(LongImageView this$0, View v) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        View.OnClickListener onClickListener = this$0.mPdrClickListener;
        if (onClickListener != null) {
            onClickListener.onClick(v);
        }
    }

    private static final boolean loadImageBitmaps$lambda-4(LongImageView this$0, View v) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        View.OnLongClickListener onLongClickListener = this$0.mPdrLongClickListener;
        return onLongClickListener == null ? false : (bl = onLongClickListener.onLongClick(v));
    }

    public static final /* synthetic */ void access$loadImageBitmaps(LongImageView $this, List bitmaps) {
        $this.loadImageBitmaps(bitmaps);
    }
}

