/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.Window;
import androidx.annotation.LayoutRes;
import androidx.annotation.StyleRes;
import com.lodz.android.pandora.R;
import com.lodz.android.pandora.widget.dialog.RxDialog;
import com.trello.rxlifecycle4.LifecycleTransformer;
import com.trello.rxlifecycle4.android.FragmentEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0004J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\f0\t\"\u0004\b\u0000\u0010\fH\u0004J\b\u0010\r\u001a\u00020\u0006H\u0015J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0004J\b\u0010\u0013\u001a\u00020\u0006H%J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0014J\u0012\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0004J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0004J\b\u0010\u001e\u001a\u00020\u000fH\u0014J\b\u0010\u001f\u001a\u00020\u000fH\u0002J\b\u0010 \u001a\u00020\u000fH\u0014\u00a8\u0006!"}, d2={"Lcom/lodz/android/pandora/widget/dialog/BaseDialog;", "Lcom/lodz/android/pandora/widget/dialog/RxDialog;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "themeResId", "", "(Landroid/content/Context;I)V", "bindAnyStopEvent", "Lcom/trello/rxlifecycle4/LifecycleTransformer;", "", "bindStopEvent", "T", "configAnimations", "endCreate", "", "findViews", "getDialogInterface", "Landroid/content/DialogInterface;", "getLayoutId", "init", "initData", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "setElevation", "elevation", "", "background", "Landroid/graphics/drawable/Drawable;", "setListeners", "setWindowAnimations", "startCreate", "pandora_release"})
public abstract class BaseDialog
extends RxDialog {
    public BaseDialog(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, R.style.BaseDialog);
        this.init();
    }

    public BaseDialog(@NotNull Context context, @StyleRes int themeResId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, themeResId);
        this.init();
    }

    private final void init() {
        this.setContentView(this.getLayoutId());
        this.setWindowAnimations();
    }

    @Override
    protected final void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.startCreate();
        this.findViews();
        this.setListeners();
        this.initData();
        this.endCreate();
    }

    protected void startCreate() {
    }

    @LayoutRes
    protected abstract int getLayoutId();

    protected void findViews() {
    }

    protected void setListeners() {
    }

    protected void initData() {
    }

    protected void endCreate() {
    }

    @StyleRes
    protected int configAnimations() {
        return -1;
    }

    private final void setWindowAnimations() {
        Window window;
        int animations = this.configAnimations();
        if (animations != -1 && (window = this.getWindow()) != null) {
            window.setWindowAnimations(animations);
        }
    }

    protected final void setElevation(float elevation, @NotNull Drawable background) {
        Window window;
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        Window window2 = this.getWindow();
        if (window2 == null) {
            return;
        }
        Window wd = window = window2;
        if (Build.VERSION.SDK_INT >= 21) {
            wd.getDecorView().setElevation(elevation);
            wd.getDecorView().setBackground(background);
        }
    }

    @NotNull
    protected final DialogInterface getDialogInterface() {
        return (DialogInterface)this;
    }

    @NotNull
    protected final <T> LifecycleTransformer<T> bindStopEvent() {
        return this.bindUntilEvent(FragmentEvent.STOP);
    }

    @NotNull
    protected final LifecycleTransformer<Object> bindAnyStopEvent() {
        return this.bindUntilEvent(FragmentEvent.STOP);
    }
}

