/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.index;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import com.lodz.android.corekt.anko.AnkoContextCompatKt;
import com.lodz.android.corekt.anko.AnkoDimensionsKt;
import com.lodz.android.pandora.R;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001:\u00014B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB+\b\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\u0012\u0010\"\u001a\u00020\u001a2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010#\u001a\u00020\u000e2\b\u0010$\u001a\u0004\u0018\u00010%H\u0017J\u000e\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u0010J\u0014\u0010(\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0010\u0010)\u001a\u00020\u001a2\b\b\u0001\u0010*\u001a\u00020\tJ\u0010\u0010+\u001a\u00020\u001a2\b\b\u0001\u0010*\u001a\u00020\tJ\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\tJ\u000e\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u0012J\u0010\u00100\u001a\u00020\u001a2\b\b\u0001\u0010*\u001a\u00020\tJ\u0010\u00101\u001a\u00020\u001a2\b\b\u0001\u0010*\u001a\u00020\tJ\u000e\u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u00020\u000eR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/lodz/android/pandora/widget/index/IndexBar;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "isPdrTextBold", "", "mPdrHintTextView", "Landroid/widget/TextView;", "mPdrOnIndexListener", "Lcom/lodz/android/pandora/widget/index/IndexBar$OnIndexListener;", "mPdrPressBgDrawable", "Landroid/graphics/drawable/Drawable;", "mPdrTextColor", "mPdrTextColorStateList", "Landroid/content/res/ColorStateList;", "mPdrTextSizeSp", "addTextView", "", "list", "", "", "callbackTouch", "x", "", "y", "init", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "setHintTextView", "textView", "setIndexList", "setIndexTextColorInt", "color", "setIndexTextColorRes", "setIndexTextSize", "textSize", "setOnIndexListener", "listener", "setPressBgColorInt", "setPressBgColorRes", "setTextBold", "isBold", "OnIndexListener", "pandora_release"})
public final class IndexBar
extends LinearLayout {
    @ColorInt
    private int mPdrTextColor = -16777216;
    @Nullable
    private ColorStateList mPdrTextColorStateList;
    private int mPdrTextSizeSp = 13;
    private boolean isPdrTextBold = true;
    @Nullable
    private Drawable mPdrPressBgDrawable;
    @Nullable
    private OnIndexListener mPdrOnIndexListener;
    @Nullable
    private TextView mPdrHintTextView;

    public IndexBar(@Nullable Context context) {
        super(context);
        this.init(null);
    }

    public IndexBar(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public IndexBar(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public IndexBar(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    private final void init(AttributeSet attrs) {
        TypedArray typedArray;
        TypedArray typedArray2 = null;
        if (attrs != null) {
            typedArray2 = this.getContext().obtainStyledAttributes(attrs, R.styleable.IndexBar);
        }
        ColorStateList colorStateList = this.mPdrTextColorStateList = (typedArray = typedArray2) == null ? null : typedArray.getColorStateList(R.styleable.IndexBar_indexTextColor);
        if (typedArray2 != null) {
            this.mPdrTextSizeSp = AnkoDimensionsKt.px2sp((View)((View)this), (int)typedArray2.getDimensionPixelSize(R.styleable.IndexBar_indexTextSize, 13));
            this.isPdrTextBold = typedArray2.getBoolean(R.styleable.IndexBar_isTextBold, true);
        }
        this.mPdrPressBgDrawable = (typedArray = typedArray2) == null ? null : typedArray.getDrawable(R.styleable.IndexBar_pressBackgroundColor);
        typedArray = typedArray2;
        if (typedArray != null) {
            typedArray.recycle();
        }
    }

    public final void setOnIndexListener(@NotNull OnIndexListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.mPdrOnIndexListener = listener;
    }

    public final void setIndexTextColorInt(@ColorInt int color2) {
        this.mPdrTextColor = color2;
    }

    public final void setIndexTextColorRes(@ColorRes int color2) {
        this.mPdrTextColor = AnkoContextCompatKt.getColorCompat((View)((View)this), (int)color2);
    }

    public final void setIndexTextSize(int textSize) {
        this.mPdrTextSizeSp = textSize;
    }

    public final void setTextBold(boolean isBold) {
        this.isPdrTextBold = isBold;
    }

    public final void setPressBgColorInt(@ColorInt int color2) {
        this.mPdrPressBgDrawable = (Drawable)new ColorDrawable(color2);
    }

    public final void setPressBgColorRes(@ColorRes int color2) {
        this.mPdrPressBgDrawable = (Drawable)new ColorDrawable(AnkoContextCompatKt.getColorCompat((View)((View)this), (int)color2));
    }

    public final void setHintTextView(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        this.mPdrHintTextView = textView;
    }

    public final void setIndexList(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        if (list.isEmpty()) {
            return;
        }
        this.addTextView(list);
        this.requestLayout();
        this.invalidate();
    }

    private final void addTextView(List<String> list) {
        for (String str : list) {
            TextView textView = new TextView(this.getContext());
            textView.setText((CharSequence)str);
            if (this.mPdrTextColorStateList != null) {
                textView.setTextColor(this.mPdrTextColorStateList);
            } else {
                textView.setTextColor(this.mPdrTextColor);
            }
            textView.setTextSize(2, (float)this.mPdrTextSizeSp);
            textView.setTypeface(this.isPdrTextBold ? Typeface.DEFAULT_BOLD : Typeface.DEFAULT);
            textView.setGravity(17);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(this.getOrientation() == 1 ? -1 : 0, this.getOrientation() == 1 ? 0 : -1, 1.0f);
            this.addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@Nullable MotionEvent event) {
        Object object;
        if (event == null) {
            return super.onTouchEvent(event);
        }
        if (event.getAction() == 0 || event.getAction() == 2) {
            if (this.mPdrPressBgDrawable != null) {
                this.setBackground(this.mPdrPressBgDrawable);
            }
            if ((object = this.mPdrHintTextView) != null) {
                object.setVisibility(0);
            }
            this.callbackTouch(event.getX(), event.getY());
        }
        if (event.getAction() == 1) {
            object = this.mPdrOnIndexListener;
            if (object != null) {
                object.onEnd();
            }
            object = this.mPdrHintTextView;
            if (object != null) {
                object.setVisibility(8);
            }
            this.setBackground((Drawable)new ColorDrawable(0));
        }
        return true;
    }

    private final void callbackTouch(float x, float y) {
        int n = 0;
        int count = this.getChildCount();
        if (n < count) {
            do {
                int i;
                View view;
                Object object;
                Object object2 = object = (view = this.getChildAt(i = n++)) instanceof TextView ? (TextView)view : null;
                if (object == null) continue;
                TextView view2 = object;
                if (this.getOrientation() == 1) {
                    if (!(y >= (float)view2.getTop()) || !(y <= (float)view2.getBottom())) continue;
                    object = this.mPdrHintTextView;
                    if (object != null) {
                        object.setText(view2.getText());
                    }
                    object = this.mPdrOnIndexListener;
                    if (object != null) {
                        object.onStart(i, ((Object)view2.getText()).toString());
                    }
                    return;
                }
                if (!(x >= (float)view2.getLeft()) || !(x <= (float)view2.getRight())) continue;
                object = this.mPdrHintTextView;
                if (object != null) {
                    object.setText(view2.getText());
                }
                object = this.mPdrOnIndexListener;
                if (object != null) {
                    object.onStart(i, ((Object)view2.getText()).toString());
                }
                return;
            } while (n < count);
        }
    }

    public void _$_clearFindViewByIdCache() {
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0018\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Lcom/lodz/android/pandora/widget/index/IndexBar$OnIndexListener;", "", "onEnd", "", "onStart", "position", "", "indexText", "", "pandora_release"})
    public static interface OnIndexListener {
        public void onStart(int var1, @NotNull String var2);

        public void onEnd();
    }
}

