/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.popup;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import androidx.annotation.LayoutRes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u000b\u001a\u00020\tH\u0014J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0003H\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0013H%J\u0006\u0010\u0015\u001a\u00020\u0007J\b\u0010\u0016\u001a\u00020\u0013H\u0014J\b\u0010\u0017\u001a\u00020\tH\u0014J\b\u0010\u0018\u001a\u00020\tH\u0014J\b\u0010\u0019\u001a\u00020\tH\u0014R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/lodz/android/pandora/widget/popup/BasePopupWindow;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mPdrContext", "mPdrPopupWindow", "Landroid/widget/PopupWindow;", "create", "", "createPopupWindow", "endCreate", "findViews", "view", "Landroid/view/View;", "getContext", "getElevationValue", "", "getHeightPx", "", "getLayoutId", "getPopup", "getWidthPx", "initData", "setListeners", "startCreate", "pandora_release"})
public abstract class BasePopupWindow {
    @NotNull
    private final Context mPdrContext;
    @NotNull
    private final PopupWindow mPdrPopupWindow;

    public BasePopupWindow(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.mPdrContext = context;
        this.mPdrPopupWindow = this.createPopupWindow(this.mPdrContext);
    }

    private final PopupWindow createPopupWindow(Context context) {
        View popView = LayoutInflater.from((Context)context).inflate(this.getLayoutId(), null);
        PopupWindow popupWindow = new PopupWindow(popView, this.getWidthPx(), this.getHeightPx(), true);
        popupWindow.setTouchable(true);
        popupWindow.setOutsideTouchable(true);
        if (Build.VERSION.SDK_INT >= 21) {
            popupWindow.setElevation(this.getElevationValue());
        }
        popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(-1));
        return popupWindow;
    }

    public final void create() {
        this.startCreate();
        View view = this.mPdrPopupWindow.getContentView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"mPdrPopupWindow.contentView");
        this.findViews(view);
        this.setListeners();
        this.initData();
        this.endCreate();
    }

    protected int getWidthPx() {
        return -2;
    }

    protected int getHeightPx() {
        return -2;
    }

    protected float getElevationValue() {
        return 12.0f;
    }

    protected void startCreate() {
    }

    @LayoutRes
    protected abstract int getLayoutId();

    protected void findViews(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
    }

    protected void setListeners() {
    }

    protected void initData() {
    }

    protected void endCreate() {
    }

    @NotNull
    protected final Context getContext() {
        return this.mPdrContext;
    }

    @NotNull
    public final PopupWindow getPopup() {
        return this.mPdrPopupWindow;
    }
}

