/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.rv.binder;

import android.content.Context;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.lodz.android.pandora.widget.rv.binder.DefaultRecyclerBinder;
import com.lodz.android.pandora.widget.rv.binder.RecyclerBinder;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\nJ\u0006\u0010\u000f\u001a\u00020\rJ\u0016\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0006\u0010\u0014\u001a\u00020\u0004J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u000e\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/lodz/android/pandora/widget/rv/binder/RvBinderAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "DEFAULT_BINDER_TYPE", "", "mPdrBinderList", "Ljava/util/ArrayList;", "Lcom/lodz/android/pandora/widget/rv/binder/RecyclerBinder;", "Lkotlin/collections/ArrayList;", "addBinder", "", "binder", "clearBinder", "getBinderByViewType", "viewType", "getBinderPosition", "position", "getContext", "getItemCount", "getItemViewType", "getViewTypeByPosition", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "removeBinder", "pandora_release"})
public class RvBinderAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    private final Context context;
    private final int DEFAULT_BINDER_TYPE;
    @NotNull
    private final ArrayList<RecyclerBinder<?>> mPdrBinderList;

    public RvBinderAdapter(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.DEFAULT_BINDER_TYPE = -1;
        this.mPdrBinderList = new ArrayList();
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public int getItemViewType(int position) {
        return this.getViewTypeByPosition(position);
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        RecyclerBinder<?> recyclerBinder = this.getBinderByViewType(viewType);
        if (recyclerBinder == null) {
            return new DefaultRecyclerBinder(this.getContext(), this.DEFAULT_BINDER_TYPE).onCreateViewHolder(parent);
        }
        RecyclerBinder<?> binder = recyclerBinder;
        return binder.onCreateViewHolder(parent);
    }

    public int getItemCount() {
        int sumCount = 0;
        for (RecyclerBinder<?> binder : this.mPdrBinderList) {
            sumCount += binder.getCount();
        }
        return sumCount;
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        RecyclerBinder<?> recyclerBinder = this.getBinderByViewType(this.getItemViewType(position));
        if (recyclerBinder == null) {
            return;
        }
        RecyclerBinder<?> binder = recyclerBinder;
        binder.onBindViewHolder(holder, this.getBinderPosition(position));
    }

    public final void addBinder(@NotNull RecyclerBinder<?> binder) {
        Intrinsics.checkNotNullParameter(binder, (String)"binder");
        this.mPdrBinderList.add(binder);
    }

    public final void removeBinder(int viewType) {
        RecyclerBinder<?> binder = this.getBinderByViewType(viewType);
        if (binder != null) {
            this.mPdrBinderList.remove(binder);
        }
    }

    public final void clearBinder() {
        this.mPdrBinderList.clear();
    }

    private final RecyclerBinder<?> getBinderByViewType(int viewType) {
        for (RecyclerBinder<?> binder : this.mPdrBinderList) {
            if (binder.getViewType() != viewType) continue;
            return binder;
        }
        return null;
    }

    private final int getViewTypeByPosition(int position) {
        int size = 0;
        for (RecyclerBinder<?> binder : this.mPdrBinderList) {
            if (position >= (size += binder.getCount())) continue;
            return binder.getViewType();
        }
        return this.DEFAULT_BINDER_TYPE;
    }

    private final int getBinderPosition(int position) {
        int currentSize = 0;
        int lastSize = 0;
        for (RecyclerBinder<?> binder : this.mPdrBinderList) {
            if (position < (currentSize += binder.getCount())) {
                return position - lastSize;
            }
            lastSize = currentSize;
        }
        return 0;
    }
}

