/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.rv.decoration;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextPaint;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.FloatRange;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.lodz.android.corekt.anko.AnkoContextCompatKt;
import com.lodz.android.corekt.anko.AnkoDimensionsKt;
import com.lodz.android.pandora.widget.rv.decoration.BaseItemDecoration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 .2\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0004J8\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0004J\u0010\u0010\u001f\u001a\u00020\u00002\b\b\u0001\u0010 \u001a\u00020\bJ\u0010\u0010!\u001a\u00020\u00002\b\b\u0001\u0010 \u001a\u00020\bJ\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\bJ\u0010\u0010$\u001a\u00020\u00002\b\b\u0001\u0010 \u001a\u00020\bJ\u0010\u0010%\u001a\u00020\u00002\b\b\u0001\u0010 \u001a\u00020\bJ\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\bJ\u0010\u0010(\u001a\u00020\u00002\b\b\u0001\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/lodz/android/pandora/widget/rv/decoration/BaseSectionItemDecoration;", "Lcom/lodz/android/pandora/widget/rv/decoration/BaseItemDecoration;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mPdrBgPaint", "Landroid/graphics/Paint;", "mPdrSectionHeightPx", "", "getMPdrSectionHeightPx", "()I", "setMPdrSectionHeightPx", "(I)V", "mPdrTextPaddingLeftDp", "mPdrTextPaint", "Landroid/text/TextPaint;", "drawBgPaint", "", "canvas", "Landroid/graphics/Canvas;", "left", "top", "right", "bottom", "drawTextPaint", "text", "", "isVerLinearLayout", "", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "setSectionBgColorInt", "color", "setSectionBgColorRes", "setSectionHeight", "height", "setSectionTextColorInt", "setSectionTextColorRes", "setSectionTextPaddingLeftDp", "paddingLeft", "setSectionTextSize", "textSize", "", "setSectionTextTypeface", "typeface", "Landroid/graphics/Typeface;", "Companion", "pandora_release"})
public class BaseSectionItemDecoration
extends BaseItemDecoration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextPaint mPdrTextPaint;
    @NotNull
    private final Paint mPdrBgPaint;
    private int mPdrSectionHeightPx;
    private int mPdrTextPaddingLeftDp;
    protected static final float DEFAULT_TEXT_SIZE_SP = 20.0f;
    protected static final int DEFAULT_SECTION_HEIGHT_DP = 32;

    public BaseSectionItemDecoration(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.mPdrBgPaint = new Paint();
        this.mPdrBgPaint.setColor(-7829368);
        this.mPdrTextPaint = new TextPaint();
        this.mPdrTextPaint.setColor(-16777216);
        this.mPdrTextPaint.setTypeface(Typeface.DEFAULT_BOLD);
        this.mPdrTextPaint.setAntiAlias(true);
        this.mPdrTextPaint.setDither(true);
        this.mPdrTextPaint.setTextSize(AnkoDimensionsKt.sp2px((Context)this.getContext(), (float)20.0f));
        this.mPdrTextPaint.setTextAlign(Paint.Align.LEFT);
        this.mPdrSectionHeightPx = AnkoDimensionsKt.dp2px((Context)this.getContext(), (int)32);
    }

    protected final int getMPdrSectionHeightPx() {
        return this.mPdrSectionHeightPx;
    }

    protected final void setMPdrSectionHeightPx(int n) {
        this.mPdrSectionHeightPx = n;
    }

    @NotNull
    public final BaseSectionItemDecoration setSectionHeight(int height) {
        this.mPdrSectionHeightPx = AnkoDimensionsKt.dp2px((Context)this.getContext(), (int)height);
        return this;
    }

    @NotNull
    public final BaseSectionItemDecoration setSectionTextPaddingLeftDp(int paddingLeft) {
        this.mPdrTextPaddingLeftDp = AnkoDimensionsKt.dp2px((Context)this.getContext(), (int)paddingLeft);
        return this;
    }

    @NotNull
    public final BaseSectionItemDecoration setSectionTextSize(@FloatRange(from=1.0) float textSize) {
        this.mPdrTextPaint.setTextSize(AnkoDimensionsKt.sp2px((Context)this.getContext(), (float)(textSize <= 0.0f ? 20.0f : textSize)));
        return this;
    }

    @NotNull
    public final BaseSectionItemDecoration setSectionTextTypeface(@NotNull Typeface typeface) {
        Intrinsics.checkNotNullParameter((Object)typeface, (String)"typeface");
        this.mPdrTextPaint.setTypeface(typeface);
        return this;
    }

    @NotNull
    public final BaseSectionItemDecoration setSectionTextColorRes(@ColorRes int color2) {
        this.mPdrTextPaint.setColor(AnkoContextCompatKt.getColorCompat((Context)this.getContext(), (int)color2));
        return this;
    }

    @NotNull
    public final BaseSectionItemDecoration setSectionTextColorInt(@ColorInt int color2) {
        this.mPdrTextPaint.setColor(color2);
        return this;
    }

    @NotNull
    public final BaseSectionItemDecoration setSectionBgColorRes(@ColorRes int color2) {
        this.mPdrBgPaint.setColor(AnkoContextCompatKt.getColorCompat((Context)this.getContext(), (int)color2));
        return this;
    }

    @NotNull
    public final BaseSectionItemDecoration setSectionBgColorInt(@ColorInt int color2) {
        this.mPdrBgPaint.setColor(color2);
        return this;
    }

    protected final void drawBgPaint(@NotNull Canvas canvas, int left, int top, int right, int bottom) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.drawRect((float)this.checkValue(left), (float)this.checkValue(top), (float)this.checkValue(right), (float)this.checkValue(bottom), this.mPdrBgPaint);
    }

    protected void drawTextPaint(@NotNull Canvas canvas, @NotNull String text, int left, int top, int right, int bottom) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Paint.FontMetrics fontMetrics = this.mPdrTextPaint.getFontMetrics();
        float baseline = ((float)(bottom + top) - fontMetrics.bottom - fontMetrics.top) / (float)2;
        canvas.drawText(text, this.checkValue((float)(left + this.mPdrTextPaddingLeftDp)), this.checkValue(baseline), (Paint)this.mPdrTextPaint);
    }

    protected final boolean isVerLinearLayout(@NotNull RecyclerView parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager == null) {
            return false;
        }
        RecyclerView.LayoutManager layoutManager2 = layoutManager;
        RecyclerView.LayoutManager layoutManager3 = layoutManager2;
        if (layoutManager3 instanceof GridLayoutManager) {
            return false;
        }
        if (layoutManager3 instanceof LinearLayoutManager) {
            return ((LinearLayoutManager)layoutManager3).getOrientation() == 1;
        }
        return false;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/lodz/android/pandora/widget/rv/decoration/BaseSectionItemDecoration$Companion;", "", "()V", "DEFAULT_SECTION_HEIGHT_DP", "", "DEFAULT_TEXT_SIZE_SP", "", "pandora_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

