/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.rv.decoration;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.IntRange;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.lodz.android.corekt.anko.AnkoContextCompatKt;
import com.lodz.android.corekt.anko.AnkoDimensionsKt;
import com.lodz.android.pandora.widget.rv.decoration.BaseItemDecoration;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J0\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J0\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J0\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J(\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00002\b\b\u0001\u0010\u001e\u001a\u00020\bJ\u0010\u0010\u001f\u001a\u00020\u00002\b\b\u0001\u0010\u001e\u001a\u00020\bJ\u0010\u0010 \u001a\u00020\u00002\b\b\u0001\u0010!\u001a\u00020\bJ(\u0010\"\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0002J(\u0010%\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/lodz/android/pandora/widget/rv/decoration/GridItemDecoration;", "Lcom/lodz/android/pandora/widget/rv/decoration/BaseItemDecoration;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mPdrPaint", "Landroid/graphics/Paint;", "mPdrPx", "", "drawBottomDivider", "", "canvas", "Landroid/graphics/Canvas;", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "childCount", "px", "paint", "drawLeftDivider", "drawRightDivider", "drawTopDivider", "getItemOffsets", "outRect", "Landroid/graphics/Rect;", "view", "Landroid/view/View;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "onDraw", "setDividerInt", "color", "setDividerRes", "setDividerSpace", "space", "setGridOffsets", "layoutManager", "Landroidx/recyclerview/widget/GridLayoutManager;", "setLinearOffsets", "Landroidx/recyclerview/widget/LinearLayoutManager;", "setStaggeredGridOffsets", "Companion", "pandora_release"})
public final class GridItemDecoration
extends BaseItemDecoration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mPdrPx;
    @NotNull
    private final Paint mPdrPaint = new Paint();

    private GridItemDecoration(Context context) {
        super(context);
        this.mPdrPaint.setColor(-7829368);
    }

    @NotNull
    public final GridItemDecoration setDividerSpace(@IntRange(from=1L) int space) {
        this.mPdrPx = AnkoDimensionsKt.dp2px((Context)this.getContext(), (int)space);
        return this;
    }

    @NotNull
    public final GridItemDecoration setDividerRes(@ColorRes int color2) {
        this.mPdrPaint.setColor(AnkoContextCompatKt.getColorCompat((Context)this.getContext(), (int)color2));
        return this;
    }

    @NotNull
    public final GridItemDecoration setDividerInt(@ColorInt int color2) {
        this.mPdrPaint.setColor(color2);
        return this;
    }

    public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.getItemOffsets(outRect, view, parent, state);
        if (this.mPdrPx <= 0) {
            return;
        }
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            this.setStaggeredGridOffsets(outRect);
            return;
        }
        if (layoutManager instanceof GridLayoutManager) {
            this.setGridOffsets(outRect, view, parent, (GridLayoutManager)layoutManager);
            return;
        }
        if (layoutManager instanceof LinearLayoutManager) {
            this.setLinearOffsets(outRect, view, parent, (LinearLayoutManager)layoutManager);
            return;
        }
    }

    private final void setStaggeredGridOffsets(Rect outRect) {
        outRect.top = this.mPdrPx;
        outRect.bottom = this.mPdrPx;
        outRect.left = this.mPdrPx;
        outRect.right = this.mPdrPx;
    }

    private final void setLinearOffsets(Rect outRect, View view, RecyclerView parent, LinearLayoutManager layoutManager) {
        int position = parent.getChildAdapterPosition(view);
        if (layoutManager.getOrientation() == 1) {
            outRect.top = position == 0 ? this.mPdrPx : 0;
            outRect.bottom = this.mPdrPx;
            outRect.left = this.mPdrPx;
            outRect.right = this.mPdrPx;
            return;
        }
        outRect.top = this.mPdrPx;
        outRect.bottom = this.mPdrPx;
        outRect.left = position == 0 ? this.mPdrPx : 0;
        outRect.right = this.mPdrPx;
    }

    private final void setGridOffsets(Rect outRect, View view, RecyclerView parent, GridLayoutManager layoutManager) {
        int position = parent.getChildAdapterPosition(view);
        int spanCount = layoutManager.getSpanCount();
        if (layoutManager.getOrientation() == 1) {
            if (position == 0) {
                outRect.top = this.mPdrPx;
                outRect.bottom = this.mPdrPx;
                outRect.left = this.mPdrPx;
                outRect.right = this.mPdrPx;
                return;
            }
            if (position < spanCount) {
                outRect.top = this.mPdrPx;
                outRect.bottom = this.mPdrPx;
                outRect.left = 0;
                outRect.right = this.mPdrPx;
                return;
            }
            if (position % spanCount == 0) {
                outRect.top = 0;
                outRect.bottom = this.mPdrPx;
                outRect.left = this.mPdrPx;
                outRect.right = this.mPdrPx;
                return;
            }
            outRect.top = 0;
            outRect.bottom = this.mPdrPx;
            outRect.left = 0;
            outRect.right = this.mPdrPx;
            return;
        }
        parent.setPadding(parent.getPaddingStart(), parent.getPaddingTop(), parent.getPaddingEnd(), parent.getPaddingBottom() >= this.mPdrPx ? parent.getPaddingBottom() : parent.getPaddingBottom() + this.mPdrPx);
        if (position < spanCount) {
            outRect.top = this.mPdrPx;
            outRect.bottom = 0;
            outRect.left = this.mPdrPx;
            outRect.right = this.mPdrPx;
            return;
        }
        outRect.top = this.mPdrPx;
        outRect.bottom = 0;
        outRect.left = 0;
        outRect.right = this.mPdrPx;
    }

    public void onDraw(@NotNull Canvas canvas, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.onDraw(canvas, parent, state);
        if (this.mPdrPx <= 0) {
            return;
        }
        int childCount = parent.getChildCount();
        if (childCount == 0) {
            return;
        }
        this.drawTopDivider(canvas, parent, childCount, this.mPdrPx, this.mPdrPaint);
        this.drawBottomDivider(canvas, parent, childCount, this.mPdrPx, this.mPdrPaint);
        this.drawLeftDivider(canvas, parent, childCount, this.mPdrPx, this.mPdrPaint);
        this.drawRightDivider(canvas, parent, childCount, this.mPdrPx, this.mPdrPaint);
    }

    private final void drawTopDivider(Canvas canvas, RecyclerView parent, int childCount, int px, Paint paint) {
        int n = 0;
        if (n < childCount) {
            do {
                int i = n++;
                View view = parent.getChildAt(i);
                int top = view.getTop() - px;
                int bottom = view.getTop();
                int left = view.getLeft() - px;
                int right = view.getRight() + px;
                canvas.drawRect(this.checkValue((float)left), this.checkValue((float)top), this.checkValue((float)right), this.checkValue((float)bottom), paint);
            } while (n < childCount);
        }
    }

    private final void drawBottomDivider(Canvas canvas, RecyclerView parent, int childCount, int px, Paint paint) {
        int n = 0;
        if (n < childCount) {
            do {
                int i = n++;
                View view = parent.getChildAt(i);
                int top = view.getBottom();
                int bottom = view.getBottom() + px;
                int left = view.getLeft() - px;
                int right = view.getRight() + px;
                canvas.drawRect(this.checkValue((float)left), this.checkValue((float)top), this.checkValue((float)right), this.checkValue((float)bottom), paint);
            } while (n < childCount);
        }
    }

    private final void drawLeftDivider(Canvas canvas, RecyclerView parent, int childCount, int px, Paint paint) {
        int n = 0;
        if (n < childCount) {
            do {
                int i = n++;
                View view = parent.getChildAt(i);
                int top = view.getTop();
                int bottom = view.getBottom();
                int left = view.getLeft() - px;
                int right = view.getLeft();
                canvas.drawRect(this.checkValue((float)left), this.checkValue((float)top), this.checkValue((float)right), this.checkValue((float)bottom), paint);
            } while (n < childCount);
        }
    }

    private final void drawRightDivider(Canvas canvas, RecyclerView parent, int childCount, int px, Paint paint) {
        int n = 0;
        if (n < childCount) {
            do {
                int i = n++;
                View view = parent.getChildAt(i);
                int top = view.getTop();
                int bottom = view.getBottom();
                int left = view.getRight();
                int right = view.getRight() + px;
                canvas.drawRect(this.checkValue((float)left), this.checkValue((float)top), this.checkValue((float)right), this.checkValue((float)bottom), paint);
            } while (n < childCount);
        }
    }

    @JvmStatic
    @NotNull
    public static final GridItemDecoration create(@NotNull Context context) {
        return Companion.create(context);
    }

    public /* synthetic */ GridItemDecoration(Context context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/lodz/android/pandora/widget/rv/decoration/GridItemDecoration$Companion;", "", "()V", "create", "Lcom/lodz/android/pandora/widget/rv/decoration/GridItemDecoration;", "context", "Landroid/content/Context;", "pandora_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GridItemDecoration create(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new GridItemDecoration(context, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

