/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.rv.decoration;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.lodz.android.pandora.widget.rv.decoration.BaseSectionItemDecoration;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000  *\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001 B1\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0006\u00a2\u0006\u0002\u0010\tJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J \u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lcom/lodz/android/pandora/widget/rv/decoration/SectionFixItemDecoration;", "T", "Lcom/lodz/android/pandora/widget/rv/decoration/BaseSectionItemDecoration;", "context", "Landroid/content/Context;", "sections", "", "", "sources", "(Landroid/content/Context;Ljava/util/List;Ljava/util/List;)V", "mPdrSections", "mPdrSources", "getMPdrSources", "()Ljava/util/List;", "getItemOffsets", "", "outRect", "Landroid/graphics/Rect;", "view", "Landroid/view/View;", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "getSectionText", "position", "", "isFirstGroupItem", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "Companion", "pandora_release"})
public class SectionFixItemDecoration<T>
extends BaseSectionItemDecoration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> mPdrSections;
    @NotNull
    private final List<List<T>> mPdrSources;

    protected SectionFixItemDecoration(@NotNull Context context, @NotNull List<String> sections, @NotNull List<? extends List<? extends T>> sources) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sections, (String)"sections");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        super(context);
        this.mPdrSections = sections;
        this.mPdrSources = sources;
    }

    @NotNull
    protected final List<List<T>> getMPdrSources() {
        return this.mPdrSources;
    }

    public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.getItemOffsets(outRect, view, parent, state);
        if (!this.isVerLinearLayout(parent)) {
            return;
        }
        int position = parent.getChildAdapterPosition(view);
        outRect.top = this.isFirstGroupItem(position) ? this.getMPdrSectionHeightPx() : 0;
    }

    public void onDraw(@NotNull Canvas canvas, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.onDraw(canvas, parent, state);
        if (!this.isVerLinearLayout(parent)) {
            return;
        }
        int childCount = parent.getChildCount();
        if (childCount == 0) {
            return;
        }
        int left = parent.getPaddingLeft();
        int right = parent.getWidth() - parent.getPaddingRight();
        int n = 0;
        if (n < childCount) {
            do {
                int i;
                View view;
                int position;
                if (!this.isFirstGroupItem(position = parent.getChildAdapterPosition(view = parent.getChildAt(i = n++)))) continue;
                int top = view.getTop() - this.getMPdrSectionHeightPx();
                int bottom = view.getTop();
                this.drawBgPaint(canvas, left, top, right, bottom);
                this.drawTextPaint(canvas, this.getSectionText(position), left, top, right, bottom);
            } while (n < childCount);
        }
    }

    protected final boolean isFirstGroupItem(int position) {
        int size = 0;
        for (List<T> list : this.mPdrSources) {
            if (position == size) {
                return true;
            }
            if (position < size) {
                return false;
            }
            size += list.size();
        }
        return false;
    }

    @NotNull
    protected final String getSectionText(int position) {
        int size = 0;
        Iterator<List<T>> iterator = this.mPdrSources.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            List<T> list = iterator.next();
            if (position >= size && position < size + list.size()) {
                return this.mPdrSections.get(index);
            }
            size += list.size();
        }
        return "";
    }

    @JvmStatic
    @NotNull
    public static final <T> SectionFixItemDecoration<T> create(@NotNull Context context, @NotNull List<String> sections, @NotNull List<? extends List<? extends T>> sources) {
        return Companion.create(context, sections, sources);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\t0\tH\u0007\u00a8\u0006\f"}, d2={"Lcom/lodz/android/pandora/widget/rv/decoration/SectionFixItemDecoration$Companion;", "", "()V", "create", "Lcom/lodz/android/pandora/widget/rv/decoration/SectionFixItemDecoration;", "T", "context", "Landroid/content/Context;", "sections", "", "", "sources", "pandora_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T> SectionFixItemDecoration<T> create(@NotNull Context context, @NotNull List<String> sections, @NotNull List<? extends List<? extends T>> sources) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(sections, (String)"sections");
            Intrinsics.checkNotNullParameter(sources, (String)"sources");
            if (sections.isEmpty() || sources.isEmpty()) {
                throw new IllegalArgumentException("sections or sources is can not be empty");
            }
            if (sections.size() != sources.size()) {
                throw new IllegalArgumentException("sections size and sources size must be consistent");
            }
            return new SectionFixItemDecoration(context, sections, sources);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

