/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.rv.decoration;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.lodz.android.corekt.array.Groupable;
import com.lodz.android.pandora.widget.rv.decoration.BaseSectionItemDecoration;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u0000 '*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002'(B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0014J\u001e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0004J(\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u001e\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0004J \u0010%\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u001a\u0010&\u001a\u0006\u0012\u0002\b\u00030\u00002\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007R\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006)"}, d2={"Lcom/lodz/android/pandora/widget/rv/decoration/SectionItemDecoration;", "T", "Lcom/lodz/android/pandora/widget/rv/decoration/BaseSectionItemDecoration;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mPdrOnSectionCallback", "Lcom/lodz/android/pandora/widget/rv/decoration/SectionItemDecoration$OnSectionCallback;", "getMPdrOnSectionCallback", "()Lcom/lodz/android/pandora/widget/rv/decoration/SectionItemDecoration$OnSectionCallback;", "setMPdrOnSectionCallback", "(Lcom/lodz/android/pandora/widget/rv/decoration/SectionItemDecoration$OnSectionCallback;)V", "drawTextPaint", "", "canvas", "Landroid/graphics/Canvas;", "text", "", "left", "", "top", "right", "bottom", "getItem", "position", "callback", "getItemOffsets", "outRect", "Landroid/graphics/Rect;", "view", "Landroid/view/View;", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "isFirstGroupItem", "", "onDraw", "setOnSectionCallback", "Companion", "OnSectionCallback", "pandora_release"})
public class SectionItemDecoration<T>
extends BaseSectionItemDecoration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private OnSectionCallback<T> mPdrOnSectionCallback;

    protected SectionItemDecoration(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    @Nullable
    protected final OnSectionCallback<T> getMPdrOnSectionCallback() {
        return this.mPdrOnSectionCallback;
    }

    protected final void setMPdrOnSectionCallback(@Nullable OnSectionCallback<T> onSectionCallback) {
        this.mPdrOnSectionCallback = onSectionCallback;
    }

    @NotNull
    public final SectionItemDecoration<?> setOnSectionCallback(@Nullable OnSectionCallback<T> callback) {
        this.mPdrOnSectionCallback = callback;
        return this;
    }

    public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.getItemOffsets(outRect, view, parent, state);
        if (this.mPdrOnSectionCallback == null) {
            return;
        }
        if (!this.isVerLinearLayout(parent)) {
            return;
        }
        int position = parent.getChildAdapterPosition(view);
        OnSectionCallback<T> onSectionCallback = this.mPdrOnSectionCallback;
        Intrinsics.checkNotNull(onSectionCallback);
        CharSequence charSequence = this.getItem(position, onSectionCallback);
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        OnSectionCallback<T> onSectionCallback2 = this.mPdrOnSectionCallback;
        Intrinsics.checkNotNull(onSectionCallback2);
        outRect.top = this.isFirstGroupItem(position, onSectionCallback2) ? this.getMPdrSectionHeightPx() : 0;
    }

    public void onDraw(@NotNull Canvas canvas, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.onDraw(canvas, parent, state);
        if (!this.isVerLinearLayout(parent)) {
            return;
        }
        if (this.mPdrOnSectionCallback == null) {
            return;
        }
        int childCount = parent.getChildCount();
        if (childCount == 0) {
            return;
        }
        int left = parent.getPaddingLeft();
        int right = parent.getWidth() - parent.getPaddingRight();
        int n = 0;
        if (n < childCount) {
            do {
                int i = n++;
                View view = parent.getChildAt(i);
                int position = parent.getChildAdapterPosition(view);
                OnSectionCallback<T> onSectionCallback = this.mPdrOnSectionCallback;
                Intrinsics.checkNotNull(onSectionCallback);
                if (!this.isFirstGroupItem(position, onSectionCallback)) continue;
                int top = view.getTop() - this.getMPdrSectionHeightPx();
                int bottom = view.getTop();
                this.drawBgPaint(canvas, left, top, right, bottom);
                OnSectionCallback<T> onSectionCallback2 = this.mPdrOnSectionCallback;
                Intrinsics.checkNotNull(onSectionCallback2);
                this.drawTextPaint(canvas, this.getItem(position, onSectionCallback2), left, top, right, bottom);
            } while (n < childCount);
        }
    }

    protected final boolean isFirstGroupItem(int position, @NotNull OnSectionCallback<T> callback) {
        int n;
        CharSequence charSequence;
        String previous;
        String current;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter(callback, (String)"callback");
                if (position == 0) {
                    return true;
                }
                current = this.getItem(position, callback);
                previous = this.getItem(position - 1, callback);
                charSequence = current;
                n = 0;
                if (charSequence.length() == 0) break block6;
                charSequence = previous;
                n = 0;
                if (!(charSequence.length() == 0)) break block7;
            }
            return false;
        }
        charSequence = current;
        n = 0;
        int n2 = 1;
        boolean bl = false;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)charSequence2).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        charSequence = previous;
        n = 0;
        n2 = 1;
        bl = false;
        CharSequence charSequence3 = charSequence;
        if (charSequence3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = ((String)charSequence3).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return !Intrinsics.areEqual((Object)string2, (Object)string3);
    }

    @NotNull
    protected final String getItem(int position, @NotNull OnSectionCallback<T> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (position < 0) {
            return "";
        }
        T t = callback.getSourceItem(position);
        if (!(t instanceof Groupable) && !(t instanceof String)) {
            return "";
        }
        String item = t instanceof Groupable ? ((Groupable)t).getSortStr() : (String)t;
        CharSequence charSequence = item;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return "";
        }
        return item;
    }

    @Override
    protected void drawTextPaint(@NotNull Canvas canvas, @NotNull String text, int left, int top, int right, int bottom) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String title = "";
        CharSequence charSequence = text;
        int n = 0;
        if (charSequence.length() > 0) {
            charSequence = text;
            n = 0;
            int n2 = 1;
            boolean bl = false;
            String string2 = ((String)charSequence).substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            title = string2;
        }
        super.drawTextPaint(canvas, title, left, top, right, bottom);
    }

    @JvmStatic
    @NotNull
    public static final <T> SectionItemDecoration<T> create(@NotNull Context context) {
        return Companion.create(context);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/lodz/android/pandora/widget/rv/decoration/SectionItemDecoration$Companion;", "", "()V", "create", "Lcom/lodz/android/pandora/widget/rv/decoration/SectionItemDecoration;", "T", "context", "Landroid/content/Context;", "pandora_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T> SectionItemDecoration<T> create(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new SectionItemDecoration(context);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00028\u00012\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/lodz/android/pandora/widget/rv/decoration/SectionItemDecoration$OnSectionCallback;", "T", "", "getSourceItem", "position", "", "(I)Ljava/lang/Object;", "pandora_release"})
    public static interface OnSectionCallback<T> {
        public T getSourceItem(int var1);
    }
}

