/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.rv.decoration;

import android.content.Context;
import android.graphics.Canvas;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.lodz.android.pandora.widget.rv.decoration.SectionFixItemDecoration;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u0017*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0017B1\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/lodz/android/pandora/widget/rv/decoration/StickyFixItemDecoration;", "T", "Lcom/lodz/android/pandora/widget/rv/decoration/SectionFixItemDecoration;", "context", "Landroid/content/Context;", "sections", "", "", "sources", "(Landroid/content/Context;Ljava/util/List;Ljava/util/List;)V", "isLastGroupItem", "", "position", "", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "onDrawOver", "Companion", "pandora_release"})
public final class StickyFixItemDecoration<T>
extends SectionFixItemDecoration<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private StickyFixItemDecoration(Context context, List<String> sections, List<? extends List<? extends T>> sources) {
        super(context, sections, sources);
    }

    @Override
    public void onDraw(@NotNull Canvas canvas, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    public void onDrawOver(@NotNull Canvas canvas, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.onDrawOver(canvas, parent, state);
        if (!this.isVerLinearLayout(parent)) {
            return;
        }
        int childCount = parent.getChildCount();
        if (childCount == 0) {
            return;
        }
        int left = parent.getPaddingLeft();
        int right = parent.getWidth() - parent.getPaddingRight();
        int n = 0;
        if (n < childCount) {
            do {
                int i = n++;
                View view = parent.getChildAt(i);
                int position = parent.getChildAdapterPosition(view);
                int top = 0;
                int bottom = this.getMPdrSectionHeightPx();
                int sectionTop = Math.max(top, view.getTop() - this.getMPdrSectionHeightPx());
                int sectionBottom = Math.max(bottom, view.getTop());
                if (this.isFirstGroupItem(position)) {
                    this.drawBgPaint(canvas, left, sectionTop, right, sectionBottom);
                    this.drawTextPaint(canvas, this.getSectionText(position), left, sectionTop, right, sectionBottom);
                    continue;
                }
                if (this.isLastGroupItem(position) && view.getBottom() <= this.getMPdrSectionHeightPx()) {
                    this.drawBgPaint(canvas, left, top, right, view.getBottom());
                    this.drawTextPaint(canvas, this.getSectionText(position), left, top, right, view.getBottom());
                    continue;
                }
                if (i != 0) continue;
                this.drawBgPaint(canvas, left, sectionTop, right, sectionBottom);
                this.drawTextPaint(canvas, this.getSectionText(position), left, sectionTop, right, sectionBottom);
            } while (n < childCount);
        }
    }

    private final boolean isLastGroupItem(int position) {
        int size = 0;
        for (List list : this.getMPdrSources()) {
            if (position + 1 == (size += list.size())) {
                return true;
            }
            if (position >= size) continue;
            return false;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final <T> StickyFixItemDecoration<T> create(@NotNull Context context, @NotNull List<String> sections, @NotNull List<? extends List<? extends T>> sources) {
        return Companion.create(context, sections, sources);
    }

    public /* synthetic */ StickyFixItemDecoration(Context context, List sections, List sources, DefaultConstructorMarker $constructor_marker) {
        this(context, sections, sources);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\t0\tH\u0007\u00a8\u0006\f"}, d2={"Lcom/lodz/android/pandora/widget/rv/decoration/StickyFixItemDecoration$Companion;", "", "()V", "create", "Lcom/lodz/android/pandora/widget/rv/decoration/StickyFixItemDecoration;", "T", "context", "Landroid/content/Context;", "sections", "", "", "sources", "pandora_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T> StickyFixItemDecoration<T> create(@NotNull Context context, @NotNull List<String> sections, @NotNull List<? extends List<? extends T>> sources) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(sections, (String)"sections");
            Intrinsics.checkNotNullParameter(sources, (String)"sources");
            return new StickyFixItemDecoration(context, sections, sources, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

