/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.rv.decoration;

import android.content.Context;
import android.graphics.Canvas;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.lodz.android.pandora.widget.rv.decoration.SectionItemDecoration;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u0016*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0016B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/lodz/android/pandora/widget/rv/decoration/StickyItemDecoration;", "T", "Lcom/lodz/android/pandora/widget/rv/decoration/SectionItemDecoration;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "isLastGroupItem", "", "position", "", "itemCount", "callback", "Lcom/lodz/android/pandora/widget/rv/decoration/SectionItemDecoration$OnSectionCallback;", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "onDrawOver", "Companion", "pandora_release"})
public final class StickyItemDecoration<T>
extends SectionItemDecoration<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private StickyItemDecoration(Context context) {
        super(context);
    }

    @Override
    public void onDraw(@NotNull Canvas canvas, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    public void onDrawOver(@NotNull Canvas canvas, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.onDrawOver(canvas, parent, state);
        if (!this.isVerLinearLayout(parent)) {
            return;
        }
        if (this.getMPdrOnSectionCallback() == null) {
            return;
        }
        int childCount = parent.getChildCount();
        if (childCount == 0) {
            return;
        }
        int itemCount = state.getItemCount();
        int left = parent.getPaddingLeft();
        int right = parent.getWidth() - parent.getPaddingRight();
        int n = 0;
        if (n < childCount) {
            do {
                int i = n++;
                View view = parent.getChildAt(i);
                int position = parent.getChildAdapterPosition(view);
                SectionItemDecoration.OnSectionCallback onSectionCallback = this.getMPdrOnSectionCallback();
                Intrinsics.checkNotNull(onSectionCallback);
                CharSequence charSequence = this.getItem(position, onSectionCallback);
                boolean bl = false;
                if (charSequence.length() == 0) continue;
                int top = 0;
                int bottom = this.getMPdrSectionHeightPx();
                int sectionTop = Math.max(top, view.getTop() - this.getMPdrSectionHeightPx());
                int sectionBottom = Math.max(bottom, view.getTop());
                SectionItemDecoration.OnSectionCallback onSectionCallback2 = this.getMPdrOnSectionCallback();
                Intrinsics.checkNotNull(onSectionCallback2);
                if (this.isFirstGroupItem(position, onSectionCallback2)) {
                    this.drawBgPaint(canvas, left, sectionTop, right, sectionBottom);
                    SectionItemDecoration.OnSectionCallback onSectionCallback3 = this.getMPdrOnSectionCallback();
                    Intrinsics.checkNotNull(onSectionCallback3);
                    this.drawTextPaint(canvas, this.getItem(position, onSectionCallback3), left, sectionTop, right, sectionBottom);
                    continue;
                }
                SectionItemDecoration.OnSectionCallback onSectionCallback4 = this.getMPdrOnSectionCallback();
                Intrinsics.checkNotNull(onSectionCallback4);
                if (this.isLastGroupItem(position, itemCount, onSectionCallback4) && view.getBottom() <= this.getMPdrSectionHeightPx()) {
                    this.drawBgPaint(canvas, left, top, right, view.getBottom());
                    SectionItemDecoration.OnSectionCallback onSectionCallback5 = this.getMPdrOnSectionCallback();
                    Intrinsics.checkNotNull(onSectionCallback5);
                    this.drawTextPaint(canvas, this.getItem(position, onSectionCallback5), left, top, right, view.getBottom());
                    continue;
                }
                if (i != 0) continue;
                this.drawBgPaint(canvas, left, sectionTop, right, sectionBottom);
                SectionItemDecoration.OnSectionCallback onSectionCallback6 = this.getMPdrOnSectionCallback();
                Intrinsics.checkNotNull(onSectionCallback6);
                this.drawTextPaint(canvas, this.getItem(position, onSectionCallback6), left, sectionTop, right, sectionBottom);
            } while (n < childCount);
        }
    }

    private final boolean isLastGroupItem(int position, int itemCount, SectionItemDecoration.OnSectionCallback<T> callback) {
        int n;
        CharSequence charSequence;
        String next;
        String current;
        block7: {
            block6: {
                if (position + 1 >= itemCount) {
                    return true;
                }
                current = this.getItem(position, callback);
                next = this.getItem(position + 1, callback);
                charSequence = current;
                n = 0;
                if (charSequence.length() == 0) break block6;
                charSequence = next;
                n = 0;
                if (!(charSequence.length() == 0)) break block7;
            }
            return false;
        }
        charSequence = current;
        n = 0;
        int n2 = 1;
        boolean bl = false;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)charSequence2).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        charSequence = next;
        n = 0;
        n2 = 1;
        bl = false;
        CharSequence charSequence3 = charSequence;
        if (charSequence3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = ((String)charSequence3).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return !Intrinsics.areEqual((Object)string2, (Object)string3);
    }

    @JvmStatic
    @NotNull
    public static final <T> StickyItemDecoration<T> create(@NotNull Context context) {
        return Companion.create(context);
    }

    public /* synthetic */ StickyItemDecoration(Context context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/lodz/android/pandora/widget/rv/decoration/StickyItemDecoration$Companion;", "", "()V", "create", "Lcom/lodz/android/pandora/widget/rv/decoration/StickyItemDecoration;", "T", "context", "Landroid/content/Context;", "pandora_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T> StickyItemDecoration<T> create(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new StickyItemDecoration(context, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

