/*
 * Decompiled with CFR 0.152.
 */
package com.lodz.android.pandora.widget.rv.drag;

import android.content.Context;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.lodz.android.corekt.anko.AnkoArrayKt;
import com.lodz.android.corekt.anko.AnkoVibratorKt;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u001a\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0016J\b\u0010\u001f\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020\u0005H\u0016J \u0010!\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nH\u0016J\u001a\u0010#\u001a\u00020\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010$\u001a\u00020\u001eH\u0016J\u0018\u0010%\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u001eH\u0016J\u0014\u0010'\u001a\u00020\u00152\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u000e\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\fJ\u0016\u0010+\u001a\u00020\u00152\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000eJ1\u0010,\u001a\u00020\u00152)\u0010-\u001a%\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0010J\u000e\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u0005J\u000e\u00100\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u0005J\u000e\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u0005J\u000e\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0005J\u000e\u00105\u001a\u00020\u00152\u0006\u00106\u001a\u00020\u0005J\u000e\u00107\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R1\u0010\u000f\u001a%\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/lodz/android/pandora/widget/rv/drag/DragHelperCallback;", "T", "Landroidx/recyclerview/widget/ItemTouchHelper$Callback;", "()V", "isPdrLongPressDrag", "", "isPdrSwipe", "isPdrVibrate", "mPdrAdapter", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "mPdrContext", "Landroid/content/Context;", "mPdrList", "", "mPdrListener", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "list", "", "mPdrUseDrag", "mPdrUseLeftToRightSwipe", "mPdrUseRightToLeftSwipe", "clearView", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "viewHolder", "getMovementFlags", "", "isItemViewSwipeEnabled", "isLongPressDragEnabled", "onMove", "target", "onSelectedChanged", "actionState", "onSwiped", "direction", "setAdapter", "adapter", "setContext", "context", "setList", "setListener", "listener", "setLongPressDrag", "enabled", "setSwipe", "setUseDrag", "useDrag", "setUseLeftToRightSwipe", "leftToRightSwipe", "setUseRightToLeftSwipe", "rightToLeftSwipe", "setVibrate", "pandora_release"})
public class DragHelperCallback<T>
extends ItemTouchHelper.Callback {
    @Nullable
    private Context mPdrContext;
    private boolean mPdrUseDrag = true;
    private boolean mPdrUseRightToLeftSwipe = true;
    private boolean mPdrUseLeftToRightSwipe = true;
    private boolean isPdrLongPressDrag = true;
    private boolean isPdrSwipe = true;
    private boolean isPdrVibrate;
    @Nullable
    private Function1<? super List<? extends T>, Unit> mPdrListener;
    @Nullable
    private List<T> mPdrList;
    @Nullable
    private RecyclerView.Adapter<RecyclerView.ViewHolder> mPdrAdapter;

    public final void setContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.mPdrContext = context;
    }

    public final void setUseDrag(boolean useDrag) {
        this.mPdrUseDrag = useDrag;
    }

    public final void setUseRightToLeftSwipe(boolean rightToLeftSwipe) {
        this.mPdrUseRightToLeftSwipe = rightToLeftSwipe;
    }

    public final void setUseLeftToRightSwipe(boolean leftToRightSwipe) {
        this.mPdrUseLeftToRightSwipe = leftToRightSwipe;
    }

    public final void setLongPressDrag(boolean enabled) {
        this.isPdrLongPressDrag = enabled;
    }

    public final void setSwipe(boolean enabled) {
        this.isPdrSwipe = enabled;
    }

    public final void setVibrate(boolean enabled) {
        this.isPdrVibrate = enabled;
    }

    public final void setAdapter(@NotNull RecyclerView.Adapter<RecyclerView.ViewHolder> adapter) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        this.mPdrAdapter = adapter;
    }

    public final void setListener(@Nullable Function1<? super List<? extends T>, Unit> listener) {
        this.mPdrListener = listener;
    }

    public final void setList(@Nullable List<T> list) {
        this.mPdrList = list;
    }

    public int getMovementFlags(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        int dragFlags = 0;
        int swipeFlags = 0;
        if (recyclerView.getLayoutManager() instanceof GridLayoutManager) {
            dragFlags = this.mPdrUseDrag ? 15 : 0;
            swipeFlags = 0;
        } else if (recyclerView.getLayoutManager() instanceof LinearLayoutManager) {
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            if (layoutManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
            }
            LinearLayoutManager layoutManager2 = (LinearLayoutManager)layoutManager;
            if (layoutManager2.getOrientation() == 1) {
                dragFlags = this.mPdrUseDrag ? 3 : 0;
                swipeFlags = (this.mPdrUseRightToLeftSwipe ? 16 : 0) | (this.mPdrUseLeftToRightSwipe ? 32 : 0);
            } else {
                dragFlags = this.mPdrUseDrag ? 12 : 0;
                swipeFlags = 0;
            }
        } else if (recyclerView.getLayoutManager() instanceof StaggeredGridLayoutManager) {
            dragFlags = this.mPdrUseDrag ? 15 : 0;
            swipeFlags = 0;
        } else {
            dragFlags = this.mPdrUseDrag ? 15 : 0;
            swipeFlags = (this.mPdrUseRightToLeftSwipe ? 16 : 0) | (this.mPdrUseLeftToRightSwipe ? 32 : 0);
        }
        return ItemTouchHelper.Callback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
    }

    public boolean onMove(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder, @NotNull RecyclerView.ViewHolder target) {
        RecyclerView.Adapter<RecyclerView.ViewHolder> adapter;
        int n;
        int toPosition;
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (this.mPdrList == null) {
            return false;
        }
        int fromPosition = viewHolder.getAdapterPosition();
        if (fromPosition < (toPosition = target.getAdapterPosition())) {
            n = fromPosition;
            if (n < toPosition) {
                do {
                    int i = n++;
                    List<T> list = this.mPdrList;
                    Intrinsics.checkNotNull(list);
                    Collections.swap(list, i, i + 1);
                } while (n < toPosition);
            }
        } else {
            int n2 = toPosition + 1;
            n = fromPosition;
            if (n2 <= n) {
                int i;
                do {
                    i = n--;
                    List<T> list = this.mPdrList;
                    Intrinsics.checkNotNull(list);
                    Collections.swap(list, i, i - 1);
                } while (i != n2);
            }
        }
        if ((adapter = this.mPdrAdapter) != null) {
            adapter.notifyItemMoved(fromPosition, toPosition);
        }
        adapter = this.mPdrListener;
        if (adapter != null) {
            List<T> list = this.mPdrList;
            Intrinsics.checkNotNull(list);
            adapter.invoke(list);
        }
        return true;
    }

    public void onSwiped(@NotNull RecyclerView.ViewHolder viewHolder, int direction) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        if (this.mPdrList == null) {
            return;
        }
        int position = viewHolder.getAdapterPosition();
        List<T> list = this.mPdrList;
        if (list != null) {
            list.remove(position);
        }
        if (this.mPdrAdapter != null) {
            list = this.mPdrAdapter;
            if (list != null) {
                list.notifyItemRemoved(position);
            }
            if (position != AnkoArrayKt.getSize((Collection)this.mPdrList) && (list = this.mPdrAdapter) != null) {
                list.notifyItemRangeChanged(position, AnkoArrayKt.getSize((Collection)this.mPdrList) - position);
            }
        }
        if ((list = this.mPdrListener) != null) {
            List<T> list2 = this.mPdrList;
            Intrinsics.checkNotNull(list2);
            list.invoke(list2);
        }
    }

    public void onSelectedChanged(@Nullable RecyclerView.ViewHolder viewHolder, int actionState) {
        Context context;
        if (actionState != 0 && this.isPdrVibrate && this.mPdrContext != null && ((context = this.mPdrContext) == null ? false : AnkoVibratorKt.hasVibrator((Context)context)) && (context = this.mPdrContext) != null) {
            AnkoVibratorKt.createVibrator((Context)context, (long)100L);
        }
        super.onSelectedChanged(viewHolder, actionState);
    }

    public void clearView(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        super.clearView(recyclerView, viewHolder);
    }

    public boolean isLongPressDragEnabled() {
        return this.isPdrLongPressDrag;
    }

    public boolean isItemViewSwipeEnabled() {
        return this.isPdrSwipe;
    }
}

